/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.filesystem;

import java.io.IOException;
import java.net.URI;
import org.apache.tephra.shaded.org.apache.twill.filesystem.ForwardingLocationFactory;
import org.apache.tephra.shaded.org.apache.twill.filesystem.Location;
import org.apache.tephra.shaded.org.apache.twill.filesystem.LocationFactory;

public final class LocationFactories {
    public static LocationFactory namespace(LocationFactory delegate, final String namespace) {
        return new ForwardingLocationFactory(delegate){

            @Override
            public Location create(String path) {
                try {
                    Location base = this.getDelegate().create(namespace);
                    return base.append(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Location create(URI uri) {
                if (uri.isAbsolute()) {
                    return this.getDelegate().create(uri);
                }
                try {
                    Location base = this.getDelegate().create(namespace);
                    return base.append(uri.getPath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Location getHomeLocation() {
                return this.getDelegate().getHomeLocation();
            }
        };
    }

    private LocationFactories() {
    }
}

