/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.metrics.TxMetricsCollector;
import org.apache.tephra.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsCollector
extends TxMetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetricsCollector.class);
    private final MetricRegistry metrics = new MetricRegistry();
    private JmxReporter jmxReporter;
    private ScheduledReporter reporter;
    private int reportPeriod;
    private ConcurrentMap<String, AtomicLong> gauges = Maps.newConcurrentMap();

    @Override
    public void configure(Configuration conf) {
        this.reportPeriod = conf.getInt("data.tx.metrics.period", 60);
        LOG.info("Configured metrics report to emit every {} seconds", (Object)this.reportPeriod);
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).build();
        this.reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metrics).outputTo(LoggerFactory.getLogger((String)"tephra-metrics")).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void gauge(String metricName, int value, String ... tags) {
        AtomicLong gauge = (AtomicLong)this.gauges.get(metricName);
        if (gauge == null) {
            final AtomicLong newValue = new AtomicLong();
            if (this.gauges.putIfAbsent(metricName, newValue) == null) {
                this.metrics.register(metricName, (Metric)new Gauge<Long>(){

                    public Long getValue() {
                        return newValue.get();
                    }
                });
                gauge = newValue;
            } else {
                gauge = (AtomicLong)this.gauges.get(metricName);
            }
        }
        gauge.set(value);
    }

    @Override
    public void histogram(String metricName, int value) {
        this.metrics.histogram(metricName).update(value);
    }

    @Override
    public void rate(String metricName) {
        this.metrics.meter(metricName).mark();
    }

    @Override
    public void rate(String metricName, int count) {
        this.metrics.meter(metricName).mark((long)count);
    }

    @Override
    protected void startUp() throws Exception {
        this.jmxReporter.start();
        this.reporter.start((long)this.reportPeriod, TimeUnit.SECONDS);
        LOG.info("Started metrics reporter");
    }

    @Override
    protected void shutDown() throws Exception {
        this.jmxReporter.stop();
        this.reporter.stop();
        LOG.info("Stopped metrics reporter");
    }
}

