/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserInfoResult {
    protected final String familyName;
    protected final String givenName;
    protected final String email;
    protected final Boolean emailVerified;
    protected final String iss;
    protected final String sub;

    public UserInfoResult(String familyName, String givenName, String email, Boolean emailVerified, String iss, String sub) {
        this.familyName = familyName;
        this.givenName = givenName;
        this.email = email;
        this.emailVerified = emailVerified;
        if (iss == null) {
            throw new IllegalArgumentException("Required value for 'iss' is null");
        }
        this.iss = iss;
        if (sub == null) {
            throw new IllegalArgumentException("Required value for 'sub' is null");
        }
        this.sub = sub;
    }

    public UserInfoResult() {
        this(null, null, null, null, "", "");
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public String getIss() {
        return this.iss;
    }

    public String getSub() {
        return this.sub;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.familyName, this.givenName, this.email, this.emailVerified, this.iss, this.sub});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserInfoResult other = (UserInfoResult)obj;
            return !(this.familyName != other.familyName && (this.familyName == null || !this.familyName.equals(other.familyName)) || this.givenName != other.givenName && (this.givenName == null || !this.givenName.equals(other.givenName)) || this.email != other.email && (this.email == null || !this.email.equals(other.email)) || this.emailVerified != other.emailVerified && (this.emailVerified == null || !this.emailVerified.equals(other.emailVerified)) || this.iss != other.iss && !this.iss.equals(other.iss) || this.sub != other.sub && !this.sub.equals(other.sub));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserInfoResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserInfoResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.familyName != null) {
                g.writeFieldName("family_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.familyName, g);
            }
            if (value.givenName != null) {
                g.writeFieldName("given_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.givenName, g);
            }
            if (value.email != null) {
                g.writeFieldName("email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.email, g);
            }
            if (value.emailVerified != null) {
                g.writeFieldName("email_verified");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.emailVerified, g);
            }
            g.writeFieldName("iss");
            StoneSerializers.string().serialize(value.iss, g);
            g.writeFieldName("sub");
            StoneSerializers.string().serialize(value.sub, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserInfoResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_sub;
            String f_iss;
            Boolean f_emailVerified;
            String f_email;
            String f_givenName;
            String f_familyName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_familyName = null;
                f_givenName = null;
                f_email = null;
                f_emailVerified = null;
                f_iss = "";
                f_sub = "";
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("family_name".equals(field)) {
                        f_familyName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("given_name".equals(field)) {
                        f_givenName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("iss".equals(field)) {
                        f_iss = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("sub".equals(field)) {
                        f_sub = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserInfoResult value = new UserInfoResult(f_familyName, f_givenName, f_email, f_emailVerified, f_iss, f_sub);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String familyName = null;
        protected String givenName = null;
        protected String email = null;
        protected Boolean emailVerified = null;
        protected String iss = "";
        protected String sub = "";

        protected Builder() {
        }

        public Builder withFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder withGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withEmailVerified(Boolean emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        public Builder withIss(String iss) {
            this.iss = iss != null ? iss : "";
            return this;
        }

        public Builder withSub(String sub) {
            this.sub = sub != null ? sub : "";
            return this;
        }

        public UserInfoResult build() {
            return new UserInfoResult(this.familyName, this.givenName, this.email, this.emailVerified, this.iss, this.sub);
        }
    }
}

