/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.AbstractRequestProcessor;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.jboss.netty.channel.Channel;

public class RequestProcessorSkipCT
extends AbstractRequestProcessor {
    private final ReplyProcessor replyProcessor;
    private final LeaseManagement leaseManager;
    private final Panicker panicker;
    private final String tsoHostAndPort;

    @Inject
    RequestProcessorSkipCT(MetricsRegistry metrics, TimestampOracle timestampOracle, ReplyProcessor replyProcessor, Panicker panicker, LeaseManagement leaseManager, TSOServerConfig config, LowWatermarkWriter lowWatermarkWriter, String tsoHostAndPort) throws IOException {
        super(metrics, timestampOracle, panicker, config, lowWatermarkWriter, replyProcessor);
        this.replyProcessor = replyProcessor;
        this.tsoHostAndPort = tsoHostAndPort;
        this.requestRing = this.disruptor.start();
        this.leaseManager = leaseManager;
        this.panicker = panicker;
    }

    private void commitSuicideIfNotMaster() {
        if (!this.leaseManager.stillInLeasePeriod()) {
            this.panicker.panic("Replica " + this.tsoHostAndPort + " lost mastership whilst flushing data. Committing suicide");
        }
    }

    @Override
    public void forwardCommit(long startTimestamp, long commitTimestamp, Channel c, MonitoringContext monCtx, Optional<Long> newLowWatermark) {
        this.commitSuicideIfNotMaster();
        monCtx.timerStart("reply.processor.commit.latency");
        this.replyProcessor.sendCommitResponse(startTimestamp, commitTimestamp, c, monCtx, newLowWatermark);
    }

    @Override
    public void forwardCommitRetry(long startTimestamp, Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("reply.processor.abort.latency");
        this.replyProcessor.sendAbortResponse(startTimestamp, c, monCtx);
    }

    @Override
    public void forwardAbort(long startTimestamp, Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("reply.processor.abort.latency");
        this.replyProcessor.sendAbortResponse(startTimestamp, c, monCtx);
    }

    @Override
    public void forwardTimestamp(long startTimestamp, Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("reply.processor.timestamp.latency");
        this.replyProcessor.sendTimestampResponse(startTimestamp, c, monCtx);
    }

    @Override
    public void onTimeout() {
    }
}

