/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.Arrays;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.PersistEvent;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private final int id;
    private final int size;
    private int numEvents;
    private final PersistEvent[] events;

    Batch(int id, int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Size [%s] must be positive", (int)size);
        this.size = size;
        this.id = id;
        this.numEvents = 0;
        this.events = new PersistEvent[size];
        for (int i = 0; i < size; ++i) {
            this.events[i] = new PersistEvent();
        }
        LOG.info("Batch id {} created with size {}", (Object)id, (Object)size);
    }

    PersistEvent get(int idx) {
        Preconditions.checkState((this.numEvents > 0 && 0 <= idx && idx < this.numEvents ? 1 : 0) != 0, (String)"Accessing Events array (Size = %s) with wrong index [%s]", (int)this.numEvents, (int)idx);
        return this.events[idx];
    }

    void set(int idx, PersistEvent event) {
        Preconditions.checkState((0 <= idx && idx < this.numEvents ? 1 : 0) != 0);
        this.events[idx] = event;
    }

    void clear() {
        this.numEvents = 0;
    }

    void decreaseNumEvents() {
        --this.numEvents;
    }

    int getNumEvents() {
        return this.numEvents;
    }

    int getLastEventIdx() {
        return this.numEvents - 1;
    }

    boolean isFull() {
        Preconditions.checkState((this.numEvents <= this.size ? 1 : 0) != 0, (String)"Batch Full: numEvents [%s] > size [%s]", (int)this.numEvents, (int)this.size);
        return this.numEvents == this.size;
    }

    boolean isEmpty() {
        return this.numEvents == 0;
    }

    void addTimestamp(long startTimestamp, Channel c, MonitoringContext context) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"batch is full");
        int index = this.numEvents++;
        PersistEvent e = this.events[index];
        context.timerStart("persistence.processor.timestamp.latency");
        e.makePersistTimestamp(startTimestamp, c, context);
    }

    void addFence(long tableID, long fenceTimestamp, Channel c, MonitoringContext context) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"batch is full");
        int index = this.numEvents++;
        PersistEvent e = this.events[index];
        context.timerStart("persistence.processor.fence.latency");
        e.makePersistFence(tableID, fenceTimestamp, c, context);
    }

    void addCommit(long startTimestamp, long commitTimestamp, Channel c, MonitoringContext context, Optional<Long> newLowWatermark) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"batch is full");
        int index = this.numEvents++;
        PersistEvent e = this.events[index];
        context.timerStart("persistence.processor.commit.latency");
        e.makePersistCommit(startTimestamp, commitTimestamp, newLowWatermark, c, context);
    }

    void addCommitRetry(long startTimestamp, Channel c, MonitoringContext context) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"batch is full");
        int index = this.numEvents++;
        PersistEvent e = this.events[index];
        context.timerStart("persistence.processor.commit-retry.latency");
        e.makeCommitRetry(startTimestamp, c, context);
    }

    void addAbort(long startTimestamp, Channel c, MonitoringContext context) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"batch is full");
        int index = this.numEvents++;
        PersistEvent e = this.events[index];
        context.timerStart("persistence.processor.abort.latency");
        e.makePersistAbort(startTimestamp, c, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("size", this.size).add("num events", this.numEvents).add("events", (Object)Arrays.toString(this.events)).toString();
    }

    static class BatchFactory
    extends BasePooledObjectFactory<Batch> {
        private static int batchId = 0;
        private int batchSize;

        BatchFactory(int batchSize) {
            this.batchSize = batchSize;
        }

        public Batch create() throws Exception {
            return new Batch(batchId++, this.batchSize);
        }

        public PooledObject<Batch> wrap(Batch batch) {
            return new DefaultPooledObject((Object)batch);
        }

        public void passivateObject(PooledObject<Batch> pooledObject) {
            ((Batch)pooledObject.getObject()).clear();
        }
    }
}

