/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.CellUtils;
import org.apache.omid.transaction.ColumnWrapper;
import org.apache.omid.transaction.CommitTimestampLocator;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.SnapshotFilter;
import org.apache.omid.transaction.TableAccessWrapper;
import org.apache.omid.transaction.TransactionException;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFilterImpl
implements SnapshotFilter {
    private static Logger LOG = LoggerFactory.getLogger(SnapshotFilterImpl.class);
    private TableAccessWrapper tableAccessWrapper;
    private CommitTable.Client commitTableClient;

    public TableAccessWrapper getTableAccessWrapper() {
        return this.tableAccessWrapper;
    }

    public SnapshotFilterImpl(TableAccessWrapper tableAccessWrapper, CommitTable.Client commitTableClient) throws IOException {
        this.tableAccessWrapper = tableAccessWrapper;
        this.commitTableClient = commitTableClient;
    }

    public SnapshotFilterImpl(TableAccessWrapper tableAccessWrapper) throws IOException {
        this(tableAccessWrapper, null);
    }

    public SnapshotFilterImpl(CommitTable.Client commitTableClient) throws IOException {
        this(null, commitTableClient);
    }

    void setTableAccessWrapper(TableAccessWrapper tableAccessWrapper) {
        this.tableAccessWrapper = tableAccessWrapper;
    }

    void setCommitTableClient(CommitTable.Client commitTableClient) {
        this.commitTableClient = commitTableClient;
    }

    private String getRowFamilyString(Cell cell) {
        return Bytes.toString((byte[])CellUtil.cloneRow((Cell)cell)) + ":" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell));
    }

    private boolean checkFamilyDeletionCache(Cell cell, HBaseTransaction transaction, Map<String, Long> familyDeletionCache, Map<Long, Long> commitCache) throws IOException {
        String key = this.getRowFamilyString(cell);
        Long familyDeletionCommitTimestamp = familyDeletionCache.get(key);
        return familyDeletionCommitTimestamp != null && familyDeletionCommitTimestamp >= cell.getTimestamp();
    }

    private void healShadowCell(Cell cell, long commitTimestamp) {
        Put put = new Put(CellUtil.cloneRow((Cell)cell));
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        byte[] shadowCellQualifier = CellUtils.addShadowCellSuffixPrefix((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        put.addColumn(family, shadowCellQualifier, cell.getTimestamp(), Bytes.toBytes((long)commitTimestamp));
        try {
            this.tableAccessWrapper.put(put);
        }
        catch (IOException e) {
            LOG.warn("Failed healing shadow cell for kv {}", (Object)cell, (Object)e);
        }
    }

    public Optional<CommitTable.CommitTimestamp> readCommitTimestampFromShadowCell(long cellStartTimestamp, CommitTimestampLocator locator) throws IOException {
        Optional commitTS = Optional.absent();
        Optional commitTimestamp = locator.readCommitTimestampFromShadowCell(cellStartTimestamp);
        if (commitTimestamp.isPresent()) {
            commitTS = Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.SHADOW_CELL, ((Long)commitTimestamp.get()).longValue(), true));
        }
        return commitTS;
    }

    public CommitTable.CommitTimestamp locateCellCommitTimestamp(long cellStartTimestamp, long epoch, CommitTimestampLocator locator, boolean isLowLatency) throws IOException {
        try {
            boolean invalidated;
            Optional<CommitTable.CommitTimestamp> commitTimeStamp;
            Optional commitTimestamp = locator.readCommitTimestampFromCache(cellStartTimestamp);
            if (commitTimestamp.isPresent()) {
                return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.CACHE, ((Long)commitTimestamp.get()).longValue(), true);
            }
            boolean invalidatedByOther = false;
            Optional commitTimestampFromCT = (Optional)this.commitTableClient.getCommitTimestamp(cellStartTimestamp).get();
            if (commitTimestampFromCT.isPresent()) {
                if (isLowLatency && !((CommitTable.CommitTimestamp)commitTimestampFromCT.get()).isValid()) {
                    invalidatedByOther = true;
                } else {
                    return (CommitTable.CommitTimestamp)commitTimestampFromCT.get();
                }
            }
            if ((commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator)).isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            if (invalidatedByOther) {
                assert (!((CommitTable.CommitTimestamp)commitTimestampFromCT.get()).isValid());
                return (CommitTable.CommitTimestamp)commitTimestampFromCT.get();
            }
            if ((cellStartTimestamp < epoch || isLowLatency) && (invalidated = ((Boolean)this.commitTableClient.tryInvalidateTransaction(cellStartTimestamp).get()).booleanValue())) {
                if (isLowLatency && (commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator)).isPresent()) {
                    this.commitTableClient.deleteCommitEntry(cellStartTimestamp);
                    return (CommitTable.CommitTimestamp)commitTimeStamp.get();
                }
                return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false);
            }
            commitTimeStamp = (Optional<CommitTable.CommitTimestamp>)this.commitTableClient.getCommitTimestamp(cellStartTimestamp).get();
            if (commitTimeStamp.isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            commitTimeStamp = this.readCommitTimestampFromShadowCell(cellStartTimestamp, locator);
            if (commitTimeStamp.isPresent()) {
                return (CommitTable.CommitTimestamp)commitTimeStamp.get();
            }
            return new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.NOT_PRESENT, -1L, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while finding commit timestamp", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Problem finding commit timestamp", e);
        }
    }

    public Optional<Long> tryToLocateCellCommitTimestamp(long epoch, Cell cell, Map<Long, Long> commitCache, boolean isLowLatency) throws IOException {
        CommitTable.CommitTimestamp tentativeCommitTimestamp = this.locateCellCommitTimestamp(cell.getTimestamp(), epoch, new HBaseTransactionManager.CommitTimestampLocatorImpl(new HBaseCellId(null, CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp()), commitCache, this.tableAccessWrapper), isLowLatency);
        if (!tentativeCommitTimestamp.isValid()) {
            return Optional.absent();
        }
        switch (tentativeCommitTimestamp.getLocation()) {
            case COMMIT_TABLE: {
                this.healShadowCell(cell, tentativeCommitTimestamp.getValue());
                return Optional.of((Object)tentativeCommitTimestamp.getValue());
            }
            case CACHE: 
            case SHADOW_CELL: {
                return Optional.of((Object)tentativeCommitTimestamp.getValue());
            }
            case NOT_PRESENT: {
                return Optional.absent();
            }
        }
        assert (false);
        return Optional.absent();
    }

    private Optional<Long> getCommitTimestamp(Cell kv, HBaseTransaction transaction, Map<Long, Long> commitCache) throws IOException {
        long startTimestamp = transaction.getStartTimestamp();
        if (kv.getTimestamp() == startTimestamp) {
            return Optional.of((Object)startTimestamp);
        }
        if (this.commitTableClient == null) {
            assert (transaction.getTransactionManager() != null);
            this.commitTableClient = transaction.getTransactionManager().getCommitTableClient();
        }
        return this.tryToLocateCellCommitTimestamp(transaction.getEpoch(), kv, commitCache, transaction.isLowLatency());
    }

    private Map<Long, Long> buildCommitCache(List<Cell> rawCells) {
        HashMap<Long, Long> commitCache = new HashMap<Long, Long>();
        for (Cell cell : rawCells) {
            if (!CellUtils.isShadowCell((Cell)cell)) continue;
            commitCache.put(cell.getTimestamp(), Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell)));
        }
        return commitCache;
    }

    private void buildFamilyDeletionCache(HBaseTransaction transaction, List<Cell> rawCells, Map<String, Long> familyDeletionCache, Map<Long, Long> commitCache, Map<String, byte[]> attributeMap) throws IOException {
        for (Cell cell : rawCells) {
            Get g;
            Result result;
            List resultCells;
            if (!CellUtils.isFamilyDeleteCell((Cell)cell)) continue;
            String key = this.getRowFamilyString(cell);
            if (familyDeletionCache.containsKey(key)) {
                return;
            }
            Optional<Long> commitTimeStamp = this.getTSIfInTransaction(cell, transaction);
            if (!commitTimeStamp.isPresent()) {
                commitTimeStamp = this.getTSIfInSnapshot(cell, transaction, commitCache);
            }
            if (commitTimeStamp.isPresent()) {
                familyDeletionCache.put(key, (Long)commitTimeStamp.get());
                continue;
            }
            Cell lastCell = cell;
            boolean foundCommittedFamilyDeletion = false;
            block1: while (!foundCommittedFamilyDeletion && (resultCells = (result = this.tableAccessWrapper.get(g = this.createPendingGet(lastCell, 3))).listCells()) != null) {
                Map<Long, Long> cmtCache = this.buildCommitCache(resultCells);
                for (Cell c : resultCells) {
                    if (!CellUtils.isFamilyDeleteCell((Cell)c)) continue;
                    commitTimeStamp = this.getTSIfInSnapshot(c, transaction, cmtCache);
                    if (commitTimeStamp.isPresent()) {
                        familyDeletionCache.put(key, (Long)commitTimeStamp.get());
                        foundCommittedFamilyDeletion = true;
                        continue block1;
                    }
                    lastCell = c;
                }
            }
        }
    }

    public Optional<Long> getTSIfInTransaction(Cell kv, HBaseTransaction transaction) {
        long startTimestamp = transaction.getStartTimestamp();
        long readTimestamp = transaction.getReadTimestamp();
        if (kv.getTimestamp() >= startTimestamp && kv.getTimestamp() <= readTimestamp) {
            return Optional.of((Object)kv.getTimestamp());
        }
        return Optional.absent();
    }

    public Optional<Long> getTSIfInSnapshot(Cell kv, HBaseTransaction transaction, Map<Long, Long> commitCache) throws IOException {
        Optional<Long> commitTimestamp = this.getCommitTimestamp(kv, transaction, commitCache);
        if (commitTimestamp.isPresent() && (Long)commitTimestamp.get() < transaction.getStartTimestamp()) {
            return commitTimestamp;
        }
        return Optional.absent();
    }

    private Get createPendingGet(Cell cell, int versionCount) throws IOException {
        Get pendingGet = new Get(CellUtil.cloneRow((Cell)cell));
        pendingGet.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell));
        pendingGet.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtils.addShadowCellSuffixPrefix((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
        pendingGet.setMaxVersions(versionCount);
        pendingGet.setTimeRange(0L, cell.getTimestamp());
        return pendingGet;
    }

    public List<Cell> filterCellsForSnapshot(List<Cell> rawCells, HBaseTransaction transaction, int versionsToRequest, Map<String, Long> familyDeletionCache, Map<String, byte[]> attributeMap) throws IOException {
        assert (rawCells != null && transaction != null && versionsToRequest >= 1);
        ArrayList<Cell> keyValuesInSnapshot = new ArrayList<Cell>();
        ArrayList<Get> pendingGetsList = new ArrayList<Get>();
        int numberOfVersionsToFetch = versionsToRequest * 2;
        if (numberOfVersionsToFetch < 1) {
            numberOfVersionsToFetch = versionsToRequest;
        }
        Map<Long, Long> commitCache = this.buildCommitCache(rawCells);
        this.buildFamilyDeletionCache(transaction, rawCells, familyDeletionCache, commitCache, attributeMap);
        ImmutableList<Collection<Cell>> filteredCells = transaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL ? SnapshotFilterImpl.groupCellsByColumnFilteringShadowCells(rawCells) : SnapshotFilterImpl.groupCellsByColumnFilteringShadowCellsAndFamilyDeletion(rawCells);
        for (Collection columnCells : filteredCells) {
            boolean snapshotValueFound = false;
            Cell oldestCell = null;
            Iterator iterator = columnCells.iterator();
            while (iterator.hasNext()) {
                Cell cell;
                oldestCell = cell = (Cell)iterator.next();
                if (!this.getTSIfInTransaction(cell, transaction).isPresent() && !this.getTSIfInSnapshot(cell, transaction, commitCache).isPresent()) continue;
                if (transaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL) {
                    keyValuesInSnapshot.add(cell);
                    if (this.getTSIfInTransaction(cell, transaction).isPresent()) {
                        snapshotValueFound = false;
                        continue;
                    }
                    snapshotValueFound = true;
                    break;
                }
                if (!this.checkFamilyDeletionCache(cell, transaction, familyDeletionCache, commitCache) && !CellUtils.isTombstone((Cell)cell)) {
                    keyValuesInSnapshot.add(cell);
                }
                snapshotValueFound = true;
                break;
            }
            if (snapshotValueFound) continue;
            assert (oldestCell != null);
            Get pendingGet = this.createPendingGet(oldestCell, numberOfVersionsToFetch);
            for (Map.Entry<String, byte[]> entry : attributeMap.entrySet()) {
                pendingGet.setAttribute(entry.getKey(), entry.getValue());
            }
            pendingGetsList.add(pendingGet);
        }
        if (!pendingGetsList.isEmpty()) {
            Result[] pendingGetsResults;
            for (Result pendingGetResult : pendingGetsResults = this.tableAccessWrapper.get(pendingGetsList)) {
                if (pendingGetResult.isEmpty()) continue;
                keyValuesInSnapshot.addAll(this.filterCellsForSnapshot(pendingGetResult.listCells(), transaction, numberOfVersionsToFetch, familyDeletionCache, attributeMap));
            }
        }
        Collections.sort(keyValuesInSnapshot, KeyValue.COMPARATOR);
        return keyValuesInSnapshot;
    }

    @Override
    public Result get(Get get, HBaseTransaction transaction) throws IOException {
        Result result = this.tableAccessWrapper.get(get);
        List<Object> filteredKeyValues = Collections.emptyList();
        if (!result.isEmpty()) {
            filteredKeyValues = this.filterCellsForSnapshot(result.listCells(), transaction, get.getMaxVersions(), new HashMap<String, Long>(), get.getAttributesMap());
        }
        return Result.create(filteredKeyValues);
    }

    @Override
    public ResultScanner getScanner(Scan scan, HBaseTransaction transaction) throws IOException {
        return new TransactionalClientScanner(transaction, scan, 1);
    }

    public boolean isCommitted(HBaseCellId hBaseCellId, long epoch, boolean isLowLatency) throws TransactionException {
        try {
            long timestamp = hBaseCellId.getTimestamp();
            CommitTable.CommitTimestamp tentativeCommitTimestamp = this.locateCellCommitTimestamp(timestamp, epoch, new HBaseTransactionManager.CommitTimestampLocatorImpl(hBaseCellId, Maps.newHashMap(), this.tableAccessWrapper), isLowLatency);
            if (!tentativeCommitTimestamp.isValid()) {
                return false;
            }
            switch (tentativeCommitTimestamp.getLocation()) {
                case COMMIT_TABLE: 
                case SHADOW_CELL: {
                    return true;
                }
                case NOT_PRESENT: {
                    return false;
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new TransactionException("Failure while checking if a transaction was committed", (Throwable)e);
        }
    }

    static ImmutableList<Collection<Cell>> groupCellsByColumnFilteringShadowCellsAndFamilyDeletion(List<Cell> rawCells) {
        Predicate<Cell> shadowCellAndFamilyDeletionFilter = new Predicate<Cell>(){

            public boolean apply(Cell cell) {
                boolean familyDeletionMarkerCondition = CellUtils.isFamilyDeleteCell((Cell)cell);
                return cell != null && !CellUtils.isShadowCell((Cell)cell) && !familyDeletionMarkerCondition;
            }
        };
        Function<Cell, ColumnWrapper> cellToColumnWrapper = new Function<Cell, ColumnWrapper>(){

            public ColumnWrapper apply(Cell cell) {
                return new ColumnWrapper(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell));
            }
        };
        return Multimaps.index((Iterable)Iterables.filter(rawCells, (Predicate)shadowCellAndFamilyDeletionFilter), (Function)cellToColumnWrapper).asMap().values().asList();
    }

    static ImmutableList<Collection<Cell>> groupCellsByColumnFilteringShadowCells(List<Cell> rawCells) {
        Predicate<Cell> shadowCellFilter = new Predicate<Cell>(){

            public boolean apply(Cell cell) {
                return cell != null && !CellUtils.isShadowCell((Cell)cell);
            }
        };
        Function<Cell, ColumnWrapper> cellToColumnWrapper = new Function<Cell, ColumnWrapper>(){

            public ColumnWrapper apply(Cell cell) {
                return new ColumnWrapper(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell));
            }
        };
        return Multimaps.index((Iterable)Iterables.filter(rawCells, (Predicate)shadowCellFilter), (Function)cellToColumnWrapper).asMap().values().asList();
    }

    @Override
    public void close() throws Exception {
        this.tableAccessWrapper.close();
    }

    public class TransactionalClientScanner
    implements ResultScanner {
        private HBaseTransaction state;
        private ResultScanner innerScanner;
        private int maxVersions;
        Map<String, Long> familyDeletionCache;
        private Map<String, byte[]> attributeMap;

        TransactionalClientScanner(HBaseTransaction state, Scan scan, int maxVersions) throws IOException {
            if (scan.hasFilter()) {
                LOG.warn("Client scanner with filter will return un expected results. Use Coprocessor scanning");
            }
            this.state = state;
            this.innerScanner = SnapshotFilterImpl.this.tableAccessWrapper.getScanner(scan);
            this.maxVersions = maxVersions;
            this.familyDeletionCache = new HashMap<String, Long>();
            this.attributeMap = scan.getAttributesMap();
        }

        public Result next() throws IOException {
            List<Object> filteredResult = Collections.emptyList();
            while (filteredResult.isEmpty()) {
                Result result = this.innerScanner.next();
                if (result == null) {
                    return null;
                }
                if (result.isEmpty()) continue;
                filteredResult = SnapshotFilterImpl.this.filterCellsForSnapshot(result.listCells(), this.state, this.maxVersions, this.familyDeletionCache, this.attributeMap);
            }
            return Result.create(filteredResult);
        }

        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }

        public void close() {
            this.innerScanner.close();
        }

        public ScanMetrics getScanMetrics() {
            return null;
        }

        public boolean renewLease() {
            return false;
        }

        public Iterator<Result> iterator() {
            return new ResultIterator(this);
        }

        class ResultIterator
        implements Iterator<Result> {
            TransactionalClientScanner scanner;
            Result currentResult;

            ResultIterator(TransactionalClientScanner scanner) {
                try {
                    this.scanner = scanner;
                    this.currentResult = scanner.next();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentResult != null && !this.currentResult.isEmpty();
            }

            @Override
            public Result next() {
                try {
                    Result result = this.currentResult;
                    this.currentResult = this.scanner.next();
                    return result;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not implemented");
            }
        }
    }
}

