/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.RemovalListener;
import com.oracle.bmc.hdfs.store.BmcFSInputStream;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcReadAheadFSInputStream
extends BmcFSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcReadAheadFSInputStream.class);
    private byte[] data;
    private long filePos = 0L;
    private long dataPos = -1L;
    private int dataMax = 0;
    private int dataCurOffset = 0;
    private final int ociReadAheadBlockSize;
    private final Cache<String, ParquetFooterInfo> parquetCache;
    private String reqString;

    public BmcReadAheadFSInputStream(ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics, int ociReadAheadBlockSize, Cache<String, ParquetFooterInfo> parquetCache) {
        super(objectStorage, status, requestBuilder, statistics);
        this.ociReadAheadBlockSize = ociReadAheadBlockSize;
        LOG.info("ReadAhead block size is " + ociReadAheadBlockSize);
        this.parquetCache = parquetCache;
    }

    public BmcReadAheadFSInputStream(ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics, int ociReadAheadBlockSize, String parquetCacheString) {
        super(objectStorage, status, requestBuilder, statistics);
        this.ociReadAheadBlockSize = ociReadAheadBlockSize;
        LOG.info("ReadAhead block size is " + ociReadAheadBlockSize);
        this.parquetCache = this.configureParquetCache(parquetCacheString);
    }

    private Cache<String, ParquetFooterInfo> configureParquetCache(String spec) {
        return CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)spec)).removalListener(BmcReadAheadFSInputStream.getParquetCacheRemovalListener()).build();
    }

    @Override
    public long getPos() {
        return this.filePos;
    }

    @Override
    public int read() throws IOException {
        LOG.debug("{}: Reading single byte at position {}", (Object)this, (Object)this.filePos);
        if (this.dataPos == -1L) {
            this.fillBuffer();
        }
        if (this.dataPos == -1L) {
            return -1;
        }
        ++this.filePos;
        int result = Byte.toUnsignedInt(this.data[this.dataCurOffset++]);
        if (this.atEndOfBuffer()) {
            this.clearBuffer();
        }
        return result;
    }

    private void clearBuffer() {
        this.dataPos = -1L;
        this.data = null;
    }

    private boolean atEndOfBuffer() {
        return this.dataCurOffset == this.dataMax;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        LOG.debug("{}: Reading {} bytes at position {}", new Object[]{this, length, position});
        this.seek(position);
        return this.read(buffer, offset, length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        LOG.debug("{}: Reading {} bytes at current position {}", new Object[]{this, length, this.filePos});
        if (this.dataPos == -1L) {
            this.fillBuffer();
        }
        if (this.dataPos == -1L) {
            return -1;
        }
        int n = Math.min(length, this.dataMax - this.dataCurOffset);
        System.arraycopy(this.data, this.dataCurOffset, buffer, offset, n);
        this.dataCurOffset += n;
        this.filePos += (long)n;
        if (this.atEndOfBuffer()) {
            if (n != length) {
                LOG.debug("{}: Short Read; exhausted buffer", (Object)this);
            }
            this.clearBuffer();
        }
        return n;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int n;
        LOG.debug("{}: ReadFully {} bytes from {}", new Object[]{this, position, length});
        this.seek(position);
        int pos = offset;
        for (int nBytes = Math.min((int)(this.status.getLen() - position), length); nBytes > 0; nBytes -= n) {
            n = this.read(buffer, pos, nBytes);
            if (n == 0) {
                throw new IOException("Read fully unexpected EOF");
            }
            pos += n;
        }
    }

    @Override
    protected long doSeek(long pos) throws IOException {
        throw new IOException("doSeek not implemented for read-ahead stream");
    }

    @Override
    public void seek(long pos) {
        LOG.debug("{}: Seek to {}", (Object)this, (Object)pos);
        this.filePos = pos;
        if (this.filePos < this.dataPos) {
            this.dataPos = -1L;
        } else if (this.dataPos != -1L && this.filePos > this.dataPos + (long)this.dataMax) {
            this.dataPos = -1L;
        } else {
            this.dataCurOffset = (int)(this.filePos - this.dataPos);
        }
    }

    @Override
    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    @Override
    public void close() {
        LOG.debug("{}: Closing", (Object)this);
        this.clearBuffer();
    }

    private void fillBuffer() throws IOException {
        LOG.debug("{}: Filling buffer at {} length {}", new Object[]{this, this.filePos, this.status.getLen()});
        long start = this.filePos;
        long end = Math.min(this.filePos + (long)this.ociReadAheadBlockSize, this.status.getLen());
        if (end == start) {
            return;
        }
        int len = (int)(end - start);
        LOG.debug("{}: Filling requesting {} bytes from {} to {} (size {})", new Object[]{this, len, start, end, this.status.getLen()});
        Range range = new Range(Long.valueOf(start), Long.valueOf(end));
        GetObjectRequest request = ((GetObjectRequest.Builder)this.requestBuilder.get()).range(range).build();
        String key = request.getObjectName();
        if (len == 8) {
            ParquetFooterInfo fi;
            LOG.debug("{}: Detected footer read", (Object)this);
            try {
                fi = (ParquetFooterInfo)this.parquetCache.get((Object)key, () -> {
                    long metaStart;
                    LOG.debug("Loading parquet cache for {}", (Object)key);
                    GetObjectResponse response = this.objectStorage.getObject(request);
                    ParquetFooterInfo ret = new ParquetFooterInfo();
                    try (InputStream is = response.getInputStream();){
                        ret.footer = new byte[8];
                        if (is.read(ret.footer) != 8) {
                            throw new IOException("Not a parquet file");
                        }
                    }
                    ret.metadataLen = Byte.toUnsignedInt(ret.footer[3]) << 24 | Byte.toUnsignedInt(ret.footer[2]) << 16 | Byte.toUnsignedInt(ret.footer[1]) << 8 | Byte.toUnsignedInt(ret.footer[0]) << 0;
                    long metaEnd = this.status.getLen() - 8L;
                    ret.metadataStart = metaStart = metaEnd - (long)ret.metadataLen;
                    Range mdRange = new Range(Long.valueOf(metaStart), Long.valueOf(metaEnd));
                    GetObjectRequest mdRequest = ((GetObjectRequest.Builder)this.requestBuilder.get()).range(mdRange).build();
                    GetObjectResponse mdResponse = this.objectStorage.getObject(mdRequest);
                    ret.metadata = new byte[ret.metadataLen];
                    try (InputStream is = mdResponse.getInputStream();){
                        BmcReadAheadFSInputStream.readAllBytes(is, ret.metadata);
                    }
                    return ret;
                });
            }
            catch (ExecutionException ex) {
                throw new IOException("Error getting file", ex);
            }
            this.dataPos = start;
            this.dataMax = len;
            this.dataCurOffset = 0;
            this.data = fi.footer;
            return;
        }
        ParquetFooterInfo fi = (ParquetFooterInfo)this.parquetCache.getIfPresent((Object)key);
        if (fi != null && start == fi.metadataStart) {
            LOG.debug("{}: Detected metadata read", (Object)this);
            this.dataPos = start;
            this.dataMax = fi.metadataLen;
            this.dataCurOffset = 0;
            this.data = fi.metadata;
            return;
        }
        if (fi == null) {
            LOG.debug("{}: Not using parquet semantics", (Object)this);
        }
        GetObjectResponse response = this.objectStorage.getObject(request);
        this.data = new byte[len];
        try (InputStream is = response.getInputStream();){
            BmcReadAheadFSInputStream.readAllBytes(is, this.data);
        }
        this.dataPos = this.filePos;
        this.dataMax = len;
        this.dataCurOffset = 0;
        LOG.debug("{}: After filling, dataPos {}, filePos {}, dataMax {}", new Object[]{this, this.dataPos, this.filePos, this.dataMax});
    }

    public String toString() {
        if (this.reqString == null) {
            this.reqString = "ReadAhead Stream for " + ((GetObjectRequest.Builder)this.requestBuilder.get()).build().getObjectName();
        }
        return this.reqString;
    }

    static void readAllBytes(InputStream is, byte[] b) throws IOException {
        int i;
        int offset = 0;
        for (int n = b.length; n > 0; n -= i) {
            i = is.read(b, offset, n);
            if (i <= 0) {
                throw new IOException("Unexpected EOF");
            }
            offset += i;
        }
    }

    static RemovalListener<String, ParquetFooterInfo> getParquetCacheRemovalListener() {
        return rn -> LOG.debug("Removed entry {}, cause {}", rn.getKey(), (Object)rn.getCause());
    }

    public static class ParquetFooterInfo {
        public byte[] footer;
        public byte[] metadata;
        public int metadataLen;
        public long metadataStart;
    }
}

