/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.transforms.PartitionSpecVisitor;

public class Partitioning {
    private Partitioning() {
    }

    public static boolean hasBucketField(PartitionSpec spec) {
        List bucketList = PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)new PartitionSpecVisitor<Boolean>(){

            public Boolean identity(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean bucket(int fieldId, String sourceName, int sourceId, int width) {
                return true;
            }

            public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
                return false;
            }

            public Boolean year(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean month(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean day(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean hour(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
                return false;
            }
        });
        return bucketList.stream().anyMatch(Boolean::booleanValue);
    }

    public static SortOrder sortOrderFor(PartitionSpec spec) {
        if (spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        SortOrder.Builder builder = SortOrder.builderFor((Schema)spec.schema());
        SpecToOrderVisitor converter = new SpecToOrderVisitor(builder);
        PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)converter);
        String bucketColumn = converter.bucketColumn();
        if (bucketColumn != null) {
            builder.asc(bucketColumn);
        }
        return builder.build();
    }

    private static class SpecToOrderVisitor
    implements PartitionSpecVisitor<Void> {
        private final SortOrder.Builder builder;
        private String bucketColumn = null;
        private int highestNumBuckets = 0;

        private SpecToOrderVisitor(SortOrder.Builder builder) {
            this.builder = builder;
        }

        String bucketColumn() {
            return this.bucketColumn;
        }

        public Void identity(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(sourceName);
            return null;
        }

        public Void bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            if (numBuckets > this.highestNumBuckets) {
                this.highestNumBuckets = numBuckets;
                this.bucketColumn = sourceName;
            }
            this.builder.asc((Term)Expressions.bucket((String)sourceName, (int)numBuckets));
            return null;
        }

        public Void truncate(int fieldId, String sourceName, int sourceId, int width) {
            this.builder.asc((Term)Expressions.truncate((String)sourceName, (int)width));
            return null;
        }

        public Void year(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.year((String)sourceName));
            return null;
        }

        public Void month(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.month((String)sourceName));
            return null;
        }

        public Void day(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.day((String)sourceName));
            return null;
        }

        public Void hour(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.hour((String)sourceName));
            return null;
        }

        public Void alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }
    }
}

