
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/*
 * This class is automatically generated from NumericTypes.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the NumericFunctionsTemplates.java template.
 */
@SuppressWarnings("unused")

public class IsNumericFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(IsNumericFunctions.class);


@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class BigIntIsNumeric implements DrillSimpleFunc{

  @Param BigIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableBigIntIsNumeric implements DrillSimpleFunc{

  @Param NullableBigIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class IntIsNumeric implements DrillSimpleFunc{

  @Param IntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableIntIsNumeric implements DrillSimpleFunc{

  @Param NullableIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class SmallIntIsNumeric implements DrillSimpleFunc{

  @Param SmallIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableSmallIntIsNumeric implements DrillSimpleFunc{

  @Param NullableSmallIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class TinyIntIsNumeric implements DrillSimpleFunc{

  @Param TinyIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableTinyIntIsNumeric implements DrillSimpleFunc{

  @Param NullableTinyIntHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class UInt1IsNumeric implements DrillSimpleFunc{

  @Param UInt1Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableUInt1IsNumeric implements DrillSimpleFunc{

  @Param NullableUInt1Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class UInt2IsNumeric implements DrillSimpleFunc{

  @Param UInt2Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableUInt2IsNumeric implements DrillSimpleFunc{

  @Param NullableUInt2Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class UInt4IsNumeric implements DrillSimpleFunc{

  @Param UInt4Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableUInt4IsNumeric implements DrillSimpleFunc{

  @Param NullableUInt4Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class UInt8IsNumeric implements DrillSimpleFunc{

  @Param UInt8Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableUInt8IsNumeric implements DrillSimpleFunc{

  @Param NullableUInt8Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class Float4IsNumeric implements DrillSimpleFunc{

  @Param Float4Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableFloat4IsNumeric implements DrillSimpleFunc{

  @Param NullableFloat4Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class Float8IsNumeric implements DrillSimpleFunc{

  @Param Float8Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableFloat8IsNumeric implements DrillSimpleFunc{

  @Param NullableFloat8Holder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class VarDecimalIsNumeric implements DrillSimpleFunc{

  @Param VarDecimalHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableVarDecimalIsNumeric implements DrillSimpleFunc{

  @Param NullableVarDecimalHolder in;
  @Output IntHolder out;

 public void setup() {
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    out.value = 1;

  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class VarCharIsNumeric implements DrillSimpleFunc{

  @Param VarCharHolder in;
  @Output IntHolder out;
  @Workspace java.util.regex.Pattern pattern;
  @Workspace java.util.regex.Matcher matcher;

 public void setup() {
   pattern = java.util.regex.Pattern.compile("[-+]?\\d+(\\.\\d+)?");
   matcher = pattern.matcher("");
 }

 public void eval() {

    String s = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.toStringFromUTF8(in.start, in.end, in.buffer);
    out.value = matcher.reset(s).matches() ? 1 : 0;



  }
}



@FunctionTemplate(name = "isnumeric", scope = FunctionTemplate.FunctionScope.SIMPLE)
public static class NullableVarCharIsNumeric implements DrillSimpleFunc{

  @Param NullableVarCharHolder in;
  @Output IntHolder out;
  @Workspace java.util.regex.Pattern pattern;
  @Workspace java.util.regex.Matcher matcher;

 public void setup() {
   pattern = java.util.regex.Pattern.compile("[-+]?\\d+(\\.\\d+)?");
   matcher = pattern.matcher("");
 }

 public void eval() {

    if(in.isSet==0){
      out.value = 0;
      return;
    }
    String s = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.toStringFromUTF8(in.start, in.end, in.buffer);
    out.value = matcher.reset(s).matches() ? 1 : 0;



  }
}


}
