/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.RegionAccessWrapper;
import org.apache.hadoop.hbase.regionserver.RegionConnectionFactory;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.HBaseShims;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTableConfig;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.SnapshotFilterImpl;
import org.apache.omid.transaction.TableAccessWrapper;
import org.apache.omid.transaction.TransactionFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmidSnapshotFilter
extends BaseRegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(OmidSnapshotFilter.class);
    private HBaseCommitTableConfig commitTableConf = null;
    private RegionCoprocessorEnvironment env = null;
    private Queue<SnapshotFilterImpl> snapshotFilterQueue = new ConcurrentLinkedQueue<SnapshotFilterImpl>();
    private Map<Object, SnapshotFilterImpl> snapshotFilterMap = new ConcurrentHashMap<Object, SnapshotFilterImpl>();
    private CommitTable.Client inMemoryCommitTable = null;
    private CommitTable.Client commitTableClient;
    private Connection connection;

    public OmidSnapshotFilter(CommitTable.Client commitTableClient) {
        LOG.info("Compactor coprocessor initialized");
        this.inMemoryCommitTable = commitTableClient;
    }

    public OmidSnapshotFilter() {
        LOG.info("Compactor coprocessor initialized via empty constructor");
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        LOG.info("Starting snapshot filter coprocessor");
        this.env = (RegionCoprocessorEnvironment)env;
        this.commitTableConf = new HBaseCommitTableConfig();
        String commitTableName = env.getConfiguration().get("omid.committable.tablename");
        if (commitTableName != null) {
            this.commitTableConf.setTableName(commitTableName);
        }
        this.connection = RegionConnectionFactory.getConnection(RegionConnectionFactory.ConnectionType.READ_CONNECTION, (RegionCoprocessorEnvironment)env);
        this.commitTableClient = new HBaseCommitTable(this.connection, this.commitTableConf).getClient();
        LOG.info("Snapshot filter started");
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        LOG.info("stopping Snapshot filter");
        LOG.info("Snapshot filter stopped");
    }

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) {
        SnapshotFilterImpl snapshotFilter = this.snapshotFilterMap.get(get);
        if (snapshotFilter != null) {
            this.snapshotFilterQueue.add(snapshotFilter);
        }
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        if (get.getAttribute("__OMID_CLIENT_GET__") == null) {
            return;
        }
        boolean isLowLatency = Bytes.toBoolean((byte[])get.getAttribute("__OMID_LL__"));
        HBaseTransaction hbaseTransaction = this.getHBaseTransaction(get.getAttribute("__OMID_TRANSACTION__"), isLowLatency);
        SnapshotFilterImpl snapshotFilter = this.getSnapshotFilter(e);
        this.snapshotFilterMap.put(get, snapshotFilter);
        get.setMaxVersions();
        Filter newFilter = TransactionFilters.getVisibilityFilter(get.getFilter(), snapshotFilter, hbaseTransaction);
        get.setFilter(newFilter);
    }

    private SnapshotFilterImpl getSnapshotFilter(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        SnapshotFilterImpl snapshotFilter = this.snapshotFilterQueue.poll();
        if (snapshotFilter == null) {
            RegionAccessWrapper regionAccessWrapper = new RegionAccessWrapper(HBaseShims.getRegionCoprocessorRegion((RegionCoprocessorEnvironment)((RegionCoprocessorEnvironment)e.getEnvironment())));
            snapshotFilter = new SnapshotFilterImpl((TableAccessWrapper)regionAccessWrapper, this.initAndGetCommitTableClient());
        }
        return snapshotFilter;
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        this.preScannerOpen(e, scan);
        return s;
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
        byte[] byteTransaction = scan.getAttribute("__OMID_TRANSACTION__");
        if (byteTransaction == null) {
            return;
        }
        boolean isLowLatency = Bytes.toBoolean((byte[])scan.getAttribute("__OMID_LL__"));
        HBaseTransaction hbaseTransaction = this.getHBaseTransaction(byteTransaction, isLowLatency);
        SnapshotFilterImpl snapshotFilter = this.getSnapshotFilter(e);
        scan.setMaxVersions();
        Filter newFilter = TransactionFilters.getVisibilityFilter(scan.getFilter(), snapshotFilter, hbaseTransaction);
        scan.setFilter(newFilter);
    }

    private HBaseTransaction getHBaseTransaction(byte[] byteTransaction, boolean isLowLatency) throws InvalidProtocolBufferException {
        TSOProto.Transaction transaction = TSOProto.Transaction.parseFrom((byte[])byteTransaction);
        long id = transaction.getTimestamp();
        long readTs = transaction.getReadTimestamp();
        long epoch = transaction.getEpoch();
        AbstractTransaction.VisibilityLevel visibilityLevel = AbstractTransaction.VisibilityLevel.fromInteger((int)transaction.getVisibilityLevel());
        return new HBaseTransaction(id, readTs, visibilityLevel, epoch, new HashSet(), new HashSet(), null, isLowLatency);
    }

    private CommitTable.Client initAndGetCommitTableClient() throws IOException {
        if (this.inMemoryCommitTable != null) {
            return this.inMemoryCommitTable;
        }
        return this.commitTableClient;
    }
}

