/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationHandlerUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.CompositeAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.JWTUtils;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.SsoConfigurationUtil;
import org.apache.hadoop.security.authentication.util.ZKSignerSecretProvider;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AuthenticationFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String CONFIG_PREFIX = "config.prefix";
    public static final String AUTH_TYPE = "type";
    public static final String SIGNATURE_SECRET = "signature.secret";
    public static final String SIGNATURE_SECRET_FILE = "signature.secret.file";
    public static final String AUTH_TOKEN_MAX_INACTIVE_INTERVAL = "token.max-inactive-interval";
    public static final String AUTH_TOKEN_VALIDITY = "token.validity";
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_PATH = "cookie.path";
    public static final String COOKIE_PERSISTENT = "cookie.persistent";
    public static final String SIGNER_SECRET_PROVIDER = "signer.secret.provider";
    public static final String SIGNER_SECRET_PROVIDER_ATTRIBUTE = "signer.secret.provider.object";
    public static final String SSO_LOGIN_COOKIE = "isSsoLogin";
    public static final String ACTION_PARAM = "action";
    private Properties config;
    private Signer signer;
    private SignerSecretProvider secretProvider;
    private AuthenticationHandler authHandler;
    private long maxInactiveInterval;
    private long validity;
    private String cookieDomain;
    private String cookiePath;
    private boolean isCookiePersistent;
    private boolean destroySecretProvider;
    protected String configPrefix;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.configPrefix = filterConfig.getInitParameter(CONFIG_PREFIX);
        this.configPrefix = this.configPrefix != null ? this.configPrefix + "." : "";
        this.config = this.getConfiguration(this.configPrefix, filterConfig);
        String authHandlerName = this.config.getProperty(AUTH_TYPE, null);
        if (authHandlerName == null) {
            throw new ServletException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authHandlerClassName = AuthenticationHandlerUtil.getAuthenticationHandlerClassName(authHandlerName);
        this.maxInactiveInterval = Long.parseLong(this.config.getProperty(AUTH_TOKEN_MAX_INACTIVE_INTERVAL, "-1"));
        if (this.maxInactiveInterval > 0L) {
            this.maxInactiveInterval *= 1000L;
        }
        this.validity = Long.parseLong(this.config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        this.initializeSecretProvider(filterConfig);
        this.initializeAuthHandler(authHandlerClassName, filterConfig);
        String domainName = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String fqdn = localHost.getCanonicalHostName();
            if (fqdn != null && !fqdn.isEmpty() && fqdn.contains(".")) {
                domainName = fqdn.substring(fqdn.indexOf("."));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.cookieDomain = this.config.getProperty(COOKIE_DOMAIN, domainName);
        this.cookiePath = this.config.getProperty(COOKIE_PATH, "/");
        this.isCookiePersistent = Boolean.parseBoolean(this.config.getProperty(COOKIE_PERSISTENT, "false"));
    }

    protected void initializeAuthHandler(String authHandlerClassName, FilterConfig filterConfig) throws ServletException {
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(authHandlerClassName);
            this.authHandler = (AuthenticationHandler)klass.newInstance();
            this.authHandler.init(this.config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void initializeSecretProvider(FilterConfig filterConfig) throws ServletException {
        this.secretProvider = (SignerSecretProvider)filterConfig.getServletContext().getAttribute(SIGNER_SECRET_PROVIDER_ATTRIBUTE);
        if (this.secretProvider == null) {
            try {
                this.secretProvider = AuthenticationFilter.constructSecretProvider(filterConfig.getServletContext(), this.config, false);
                this.destroySecretProvider = true;
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        this.signer = new Signer(this.secretProvider);
    }

    public static SignerSecretProvider constructSecretProvider(ServletContext ctx, Properties config, boolean disallowFallbackToRandomSecretProvider) throws Exception {
        SignerSecretProvider provider;
        String name = config.getProperty(SIGNER_SECRET_PROVIDER, "file");
        long validity = Long.parseLong(config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        if (!disallowFallbackToRandomSecretProvider && "file".equals(name) && config.getProperty(SIGNATURE_SECRET_FILE) == null) {
            name = "random";
        }
        if ("file".equals(name)) {
            provider = new FileSignerSecretProvider();
            try {
                provider.init(config, ctx, validity);
            }
            catch (Exception e) {
                if (!disallowFallbackToRandomSecretProvider) {
                    LOG.warn("Unable to initialize FileSignerSecretProvider, falling back to use random secrets. Reason: " + e.getMessage());
                    provider = new RandomSignerSecretProvider();
                    provider.init(config, ctx, validity);
                }
                throw e;
            }
        } else if ("random".equals(name)) {
            provider = new RandomSignerSecretProvider();
            provider.init(config, ctx, validity);
        } else if ("zookeeper".equals(name)) {
            provider = new ZKSignerSecretProvider();
            provider.init(config, ctx, validity);
        } else {
            provider = (SignerSecretProvider)Thread.currentThread().getContextClassLoader().loadClass(name).newInstance();
            provider.init(config, ctx, validity);
        }
        return provider;
    }

    protected Properties getConfiguration() {
        return this.config;
    }

    protected AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    protected boolean isRandomSecret() {
        return this.secretProvider.getClass() == RandomSignerSecretProvider.class;
    }

    protected boolean isCustomSignerSecretProvider() {
        Class<?> clazz = this.secretProvider.getClass();
        return clazz != FileSignerSecretProvider.class && clazz != RandomSignerSecretProvider.class && clazz != ZKSignerSecretProvider.class;
    }

    protected long getMaxInactiveInterval() {
        return this.maxInactiveInterval / 1000L;
    }

    protected long getValidity() {
        return this.validity / 1000L;
    }

    protected String getCookieDomain() {
        return this.cookieDomain;
    }

    protected String getCookiePath() {
        return this.cookiePath;
    }

    protected boolean isCookiePersistent() {
        return this.isCookiePersistent;
    }

    public void destroy() {
        if (this.authHandler != null) {
            this.authHandler.destroy();
            this.authHandler = null;
        }
        if (this.secretProvider != null && this.destroySecretProvider) {
            this.secretProvider.destroy();
            this.secretProvider = null;
        }
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    protected String getRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    protected AuthenticationToken getToken(HttpServletRequest request) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        Cookie[] cookies = request.getCookies();
        boolean isJWTBasedToken = false;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals(this.getCookieTokenName())) {
                    tokenStr = cookie.getValue();
                    if (tokenStr.isEmpty()) {
                        throw new AuthenticationException("Unauthorized access");
                    }
                    try {
                        tokenStr = this.signer.verifyAndExtract(tokenStr);
                    }
                    catch (SignerException ex) {
                        throw new AuthenticationException(ex);
                    }
                }
                if (!cookie.getName().equals(SSO_LOGIN_COOKIE) || !cookie.getValue().equals("1")) continue;
                isJWTBasedToken = true;
            }
        }
        if (tokenStr != null) {
            token = AuthenticationToken.parse(tokenStr);
            boolean match = this.verifyTokenType(this.getAuthenticationHandler(), token);
            if (!match) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
            if (isJWTBasedToken) {
                token.setJWTBasedToken(true);
            }
        }
        return token;
    }

    protected boolean verifyTokenType(AuthenticationHandler handler, AuthenticationToken token) {
        if (!(handler instanceof CompositeAuthenticationHandler)) {
            return handler.getType().equals(token.getType());
        }
        boolean match = false;
        Collection<String> tokenTypes = ((CompositeAuthenticationHandler)handler).getTokenTypes();
        for (String tokenType : tokenTypes) {
            if (!tokenType.equals(token.getType())) continue;
            match = true;
            break;
        }
        return match;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean unauthorizedResponse = true;
        int errCode = 401;
        AuthenticationException authenticationEx = null;
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isHttps = "https".equals(httpRequest.getScheme());
        if (this.checkSsoEnableRequest((HttpServletRequest)httpRequest)) {
            if (SsoConfigurationUtil.getInstance().getClientIssuer().isEmpty()) {
                httpResponse.setStatus(403);
            } else {
                httpResponse.setStatus(200);
            }
            return;
        }
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got token {} from httpRequest {}", (Object)token, (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                }
            }
            catch (AuthenticationException ex) {
                LOG.warn("AuthenticationToken ignored: " + ex.getMessage());
                authenticationEx = ex;
                token = null;
            }
            if (this.authHandler.managementOperation(token, (HttpServletRequest)httpRequest, httpResponse)) {
                if (token == null) {
                    if (this.checkRedirectToLogin((HttpServletRequest)httpRequest)) {
                        httpResponse.addHeader("Location", this.getLoginURL((HttpServletRequest)httpRequest));
                        httpResponse.setStatus(307);
                        return;
                    }
                    if (httpRequest.getParameter(ACTION_PARAM) != null && httpRequest.getParameter(ACTION_PARAM).equalsIgnoreCase("initSso")) {
                        HashMap<String, String> ssoMap = new HashMap<String, String>();
                        ssoMap.put("loginURL", this.constructLoginURL((HttpServletRequest)httpRequest));
                        JSONObject ssoJson = new JSONObject(ssoMap);
                        httpResponse.setContentType("application/json");
                        httpResponse.getWriter().write(ssoJson.toJSONString());
                        httpResponse.setStatus(200);
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] triggering authentication. handler: {}", (Object)this.getRequestURL((HttpServletRequest)httpRequest), this.authHandler.getClass());
                    }
                    if ((token = this.authHandler.authenticate((HttpServletRequest)httpRequest, httpResponse)) != null && token != AuthenticationToken.ANONYMOUS) {
                        if (token.getMaxInactives() > 0L) {
                            token.setMaxInactives(System.currentTimeMillis() + this.getMaxInactiveInterval() * 1000L);
                        }
                        if (token.getExpires() != 0L) {
                            token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                        }
                    }
                    newToken = true;
                }
                if (token != null) {
                    if (request.getParameter(ACTION_PARAM) != null && request.getParameter(ACTION_PARAM).equals("logout")) {
                        Cookie ssoCookie = null;
                        if (token.isJWTBasedToken()) {
                            ssoCookie = new Cookie(SSO_LOGIN_COOKIE, "");
                            ssoCookie.setMaxAge(0);
                            ssoCookie.setPath(this.getCookiePath());
                        }
                        Cookie cleanAuthCookie = new Cookie(this.getCookieTokenName(), "");
                        cleanAuthCookie.setMaxAge(0);
                        cleanAuthCookie.setPath(this.getCookiePath());
                        String domain = this.getCookieDomain();
                        if (domain != null && httpRequest.getRequestURL().toString().contains(domain)) {
                            if (domain.startsWith(".")) {
                                domain = domain.substring(1);
                            }
                            if (ssoCookie != null) {
                                ssoCookie.setDomain(domain);
                            }
                            cleanAuthCookie.setDomain(domain);
                        }
                        if (ssoCookie != null) {
                            httpResponse.addCookie(ssoCookie);
                        }
                        httpResponse.addCookie(cleanAuthCookie);
                        if (token.isJWTBasedToken()) {
                            httpResponse.addHeader("Location", this.getLogoutUrl());
                            httpResponse.setStatus(200);
                        } else {
                            httpResponse.addHeader("Location", this.getLoginURL((HttpServletRequest)httpRequest));
                            httpResponse.setStatus(307);
                        }
                        return;
                    }
                    unauthorizedResponse = false;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                    }
                    final AuthenticationToken authToken = token;
                    httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                        public String getAuthType() {
                            return authToken.getType();
                        }

                        public String getRemoteUser() {
                            return authToken.getUserName();
                        }

                        public Principal getUserPrincipal() {
                            return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                        }
                    };
                    if (!newToken && !this.isCookiePersistent() && this.getMaxInactiveInterval() > 0L) {
                        token.setMaxInactives(System.currentTimeMillis() + this.getMaxInactiveInterval() * 1000L);
                        token.setExpires(token.getExpires());
                        newToken = true;
                    }
                    if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                        String signedToken = this.signer.sign(token.toString());
                        AuthenticationFilter.createAuthCookie(this.getCookieTokenName(), httpResponse, httpRequest, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), this.isCookiePersistent(), isHttps, token.getJWTExpires());
                        if (token.isJWTBasedToken()) {
                            this.createSSOLoginCookie(httpResponse, (HttpServletRequest)httpRequest, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), isHttps, token.getJWTExpires());
                        }
                    }
                    this.doFilter(filterChain, (HttpServletRequest)httpRequest, httpResponse);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("managementOperation returned false for request {}. token: {}", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token);
                }
                unauthorizedResponse = false;
            }
        }
        catch (AuthenticationException ex) {
            errCode = 403;
            authenticationEx = ex;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authentication exception: " + ex.getMessage(), (Throwable)ex);
            }
            LOG.warn("Authentication exception: " + ex.getMessage());
        }
        if (unauthorizedResponse && !httpResponse.isCommitted()) {
            AuthenticationFilter.createAuthCookie(this.getCookieTokenName(), httpResponse, httpRequest, "", this.getCookieDomain(), this.getCookiePath(), 0L, this.isCookiePersistent(), isHttps, -1L);
            if (errCode == 401 && !httpResponse.containsHeader("WWW-Authenticate") && !httpResponse.containsHeader("WWW-Authenticate".toLowerCase())) {
                errCode = 403;
            }
            String reason = authenticationEx == null ? "Authentication required" : authenticationEx.getMessage();
            httpResponse.setStatus(errCode, reason);
            httpResponse.sendError(errCode, reason);
        }
    }

    private boolean checkSsoEnableRequest(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("User-Agent").startsWith("Mozilla/5.0") && httpRequest.getParameter(ACTION_PARAM) != null && httpRequest.getParameter(ACTION_PARAM).equalsIgnoreCase("ssoEnable");
    }

    private boolean checkRedirectToLogin(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("Authorization") == null && httpRequest.getHeader("User-Agent").startsWith("Mozilla/5.0") && !httpRequest.getRequestURI().replace("/", "").equals("login") && httpRequest.getParameter(ACTION_PARAM) == null;
    }

    private void createSSOLoginCookie(HttpServletResponse res, HttpServletRequest req, String cookieDomain, String cookiePath, long expires, boolean isHttps, long jwtExpires) {
        Cookie ssoLoginCookie = new Cookie(SSO_LOGIN_COOKIE, "1");
        if (cookieDomain != null && (req == null || req.getRequestURL().toString().contains(cookieDomain))) {
            if (cookieDomain.startsWith(".")) {
                cookieDomain = cookieDomain.substring(1);
            }
            ssoLoginCookie.setDomain(cookieDomain);
        }
        if (cookiePath != null) {
            ssoLoginCookie.setPath(cookiePath);
        }
        if (expires >= 0L || jwtExpires >= 0L) {
            long exp = Math.min(expires, jwtExpires);
            int maxAge = (int)(exp - System.currentTimeMillis()) / 1000;
            ssoLoginCookie.setMaxAge(maxAge);
        }
        if (isHttps) {
            ssoLoginCookie.setSecure(true);
        }
        ssoLoginCookie.setHttpOnly(true);
        res.addCookie(ssoLoginCookie);
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static void createAuthCookie(String name, HttpServletResponse resp, HttpServletRequest req, String token, String domain, String path, long expires, boolean isCookiePersistent, boolean isSecure, long jwtExp) {
        StringBuilder sb = new StringBuilder(name).append("=");
        if (token != null && token.length() > 0) {
            sb.append("\"").append(token).append("\"");
        }
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null && (req == null || req.getRequestURL().toString().contains(domain))) {
            if (domain.startsWith(".")) {
                domain = domain.substring(1);
            }
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L && isCookiePersistent || jwtExp >= 0L) {
            Date date = jwtExp < expires && jwtExp >= 0L ? new Date(jwtExp) : new Date(expires);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(date));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        resp.addHeader("Set-Cookie", sb.toString());
    }

    @VisibleForTesting
    String constructLoginURL(HttpServletRequest request) {
        String delimiter = "&";
        return this.getAuthUrl() + "?response_type=code" + delimiter + "client_id=" + SsoConfigurationUtil.getInstance().getClientId() + delimiter + "scope=openid" + delimiter + "redirect_uri=" + JWTUtils.constructURLWithHostname(request.getRequestURL().toString()) + "?" + ACTION_PARAM + "=processCode";
    }

    public String getAuthUrl() {
        return SsoConfigurationUtil.getInstance().getClientIssuer() + "/protocol/openid-connect/auth";
    }

    public String getLogoutUrl() {
        return SsoConfigurationUtil.getInstance().getClientIssuer() + "/protocol/openid-connect/logout";
    }

    private String getLoginURL(HttpServletRequest httpRequest) {
        String redirect;
        try {
            URI origin = new URI(httpRequest.getRequestURL().toString());
            redirect = origin.getScheme() + "://" + origin.getHost() + ":" + origin.getPort() + "/login";
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return redirect;
    }

    public String getCookieTokenName() {
        return "hadoop.auth";
    }
}

