/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.AttributedStyles;
import sqlline.BuiltInTableOutputFormatStyles;
import sqlline.OutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;
import sqlline.TableOutputFormatStyle;

class TableOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;

    TableOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    @Override
    public int print(Rows rows) {
        int index = 0;
        AttributedString header = null;
        AttributedString bottomHeader = null;
        AttributedString headerCols = null;
        int width = this.getCalculatedWidth();
        boolean showTypes = this.sqlLine.getOpts().getShowTypes();
        TableOutputFormatStyle style = BuiltInTableOutputFormatStyles.BY_NAME.get(this.sqlLine.getOpts().getTableStyle());
        String bLine = style.getBodyLine() + "";
        String hLine = style.getHeaderLine() + "";
        rows.normalizeWidths(this.sqlLine.getOpts().getMaxColumnWidth());
        while (rows.hasNext()) {
            boolean isHeader = index == 0 || index == 1 && showTypes;
            Rows.Row row = (Rows.Row)rows.next();
            AttributedString attributedString = this.getOutputString(rows, row, style, isHeader);
            attributedString = attributedString.substring(0, Math.min(attributedString.length(), width));
            if (index <= 1 || index <= 2 && showTypes) {
                StringBuilder top = this.buildHeaderLine(row, style, index == 0, false);
                StringBuilder bottom = this.buildHeaderLine(row, style, false, true);
                headerCols = isHeader ? attributedString : headerCols;
                header = this.buildHeader(headerCols, top);
                bottomHeader = this.buildHeader(headerCols, bottom);
            }
            if (this.sqlLine.getOpts().getShowHeader()) {
                int headerInterval = this.sqlLine.getOpts().getHeaderInterval();
                if (index <= 1 || index <= 2 && showTypes || headerInterval > 0 && index % headerInterval == 0) {
                    if (index == 0) {
                        this.printRow(header, style.getHeaderTopLeft() + hLine, hLine + style.getHeaderTopRight());
                        this.printRow(headerCols, style.getHeaderSeparator() + " ", " " + style.getHeaderSeparator());
                    } else if (index == 1 && showTypes) {
                        this.printRow(headerCols, style.getHeaderSeparator() + " ", " " + style.getHeaderSeparator());
                    } else {
                        this.printRow(header, style.getHeaderBodyCrossLeft() + hLine, hLine + style.getHeaderBodyCrossRight());
                    }
                }
            }
            if (!isHeader) {
                this.printRow(attributedString, style.getBodySeparator() + " ", " " + style.getBodySeparator());
            }
            ++index;
        }
        if (bottomHeader != null && this.sqlLine.getOpts().getShowHeader()) {
            this.printRow(bottomHeader, style.getBodyBottomLeft() + bLine, bLine + style.getBodyBottomRight());
        }
        return index - 1;
    }

    private int getCalculatedWidth() {
        int maxWidth = this.sqlLine.getOpts().getMaxWidth();
        int width = (maxWidth == 0 && this.sqlLine.getLineReader() != null ? this.sqlLine.getLineReader().getTerminal().getWidth() : maxWidth) - 4;
        return Math.max(width, 0);
    }

    void printRow(AttributedString attributedString, String left, String right) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        this.sqlLine.output(builder.append((CharSequence)left, AttributedStyles.GREEN).append(attributedString).append((CharSequence)right, AttributedStyles.GREEN).toAttributedString());
    }

    private StringBuilder buildHeaderLine(Rows.Row row, TableOutputFormatStyle style, boolean top, boolean lastLine) {
        StringBuilder header = new StringBuilder();
        String bLine = style.getBodyLine() + "";
        String hLine = style.getHeaderLine() + "";
        for (int j = 0; j < row.sizes.length; ++j) {
            for (int k = 0; k < row.sizes[j]; ++k) {
                header.append(lastLine ? bLine : hLine);
            }
            header.append(lastLine ? bLine : hLine);
            if (lastLine) {
                header.append(style.getBodyCrossUp());
            } else {
                header.append(top ? style.getHeaderCrossDown() : style.getHeaderBodyCross());
            }
            header.append(lastLine ? bLine : hLine);
        }
        return header;
    }

    private AttributedString buildHeader(AttributedString headerCols, StringBuilder hTop) {
        AttributedString topHeader = new AttributedStringBuilder().append((CharSequence)hTop.toString(), AttributedStyles.GREEN).toAttributedString().subSequence(0, Math.min(hTop.length(), headerCols.length()));
        return topHeader;
    }

    public AttributedString getOutputString(Rows rows, Rows.Row row, TableOutputFormatStyle style, boolean header) {
        return this.getOutputString(rows, row, " " + (header ? style.getHeaderSeparator() : style.getBodySeparator()) + ' ');
    }

    private AttributedString getOutputString(Rows rows, Rows.Row row, String delim) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        boolean isStyled = this.sqlLine.getOpts().getColor();
        for (int i = 0; i < row.values.length; ++i) {
            String v;
            if (builder.length() > 0) {
                builder.append((CharSequence)delim, isStyled ? AttributedStyles.GREEN : AttributedStyle.DEFAULT);
            }
            if (row.isMeta) {
                v = SqlLine.center(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    builder.append((CharSequence)v, AttributedStyles.CYAN);
                    continue;
                }
                builder.append((CharSequence)v, AttributedStyle.BOLD);
                continue;
            }
            v = SqlLine.rpad(row.values[i], row.sizes[i]);
            if (rows.isPrimaryKey(i)) {
                builder.append((CharSequence)v, AttributedStyles.CYAN);
                continue;
            }
            builder.append((CharSequence)v);
        }
        if (row.deleted) {
            return new AttributedStringBuilder().append((CharSequence)builder.toString(), AttributedStyles.RED).toAttributedString();
        }
        if (row.updated) {
            return new AttributedStringBuilder().append((CharSequence)builder.toString(), AttributedStyles.BLUE).toAttributedString();
        }
        if (row.inserted) {
            return new AttributedStringBuilder().append((CharSequence)builder.toString(), AttributedStyles.GREEN).toAttributedString();
        }
        return builder.toAttributedString();
    }
}

