/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sqlline.SqlLine;

class Reflector {
    private final SqlLine sqlLine;

    Reflector(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public Object invoke(Object on, String method, Object ... args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, method, Arrays.asList(args));
    }

    public Object invoke(Object on, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, on == null ? null : on.getClass(), method, args);
    }

    public Object invoke(Object on, Class defClass, String methodName, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = defClass != null ? defClass : on.getClass();
        List candidateMethods = Stream.of(c.getMethods()).filter(m -> m.getName().equalsIgnoreCase(methodName)).filter(m -> Modifier.isPublic(m.getModifiers())).collect(Collectors.toList());
        if (candidateMethods.isEmpty()) {
            throw new IllegalArgumentException(this.sqlLine.loc("no-method", methodName, c.getName()));
        }
        String arguments = "";
        for (Method method : candidateMethods) {
            if (method.getParameterCount() != args.size()) {
                StringJoiner methodTypes = new StringJoiner(", ");
                for (Class<?> type : method.getParameterTypes()) {
                    methodTypes.add(type.getTypeName());
                }
                arguments = methodTypes.toString();
                continue;
            }
            Class[] ptypes = method.getParameterTypes();
            Object[] converted = Reflector.convert(args, ptypes);
            if (converted == null) continue;
            return method.invoke(on, converted);
        }
        throw new IllegalArgumentException(this.sqlLine.loc("method-requires-arguments", methodName, arguments));
    }

    public static Object[] convert(List objects, Class[] toTypes) throws ClassNotFoundException {
        Object[] converted = new Object[objects.size()];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Reflector.convert(objects.get(i), toTypes[i]);
        }
        return converted;
    }

    public static Object convert(Object ob, Class toType) throws ClassNotFoundException {
        if (ob == null || ob.toString().equals("null")) {
            return null;
        }
        if (toType == ob.getClass()) {
            return ob;
        }
        if (toType == String.class) {
            return ob.toString();
        }
        if (toType == Byte.class || toType == Byte.TYPE) {
            return Byte.valueOf(ob.toString());
        }
        if (toType == Character.class || toType == Character.TYPE) {
            return Character.valueOf(ob.toString().charAt(0));
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return Short.valueOf(ob.toString());
        }
        if (toType == Integer.class || toType == Integer.TYPE) {
            return Integer.valueOf(ob.toString());
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return Long.valueOf(ob.toString());
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return Double.valueOf(ob.toString());
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return Float.valueOf(ob.toString());
        }
        if (toType == Boolean.class || toType == Boolean.TYPE) {
            return ob.toString().equals("true") || ob.toString().equals("true") || ob.toString().equals("1") || ob.toString().equals("on") || ob.toString().equals("yes");
        }
        if (toType == Class.class) {
            return Class.forName(ob.toString());
        }
        return null;
    }
}

