/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sqlline.Dialect;
import sqlline.SqlCompleter;

public enum BuiltInDialect implements Dialect
{
    DEFAULT("SQLLineDefaultDialect", '\"', '\"', "", "--"),
    POSTGRESQL("PostgreSQL", '\"', '\"', "", new String[]{"--"}, BuiltInDialect.postgresPgSqlBlocksBoundaries()),
    ORACLE("Oracle", '\"', '\"', "", new String[]{"--"}, BuiltInDialect.oraclePLSqlBlocksBoundaries()),
    H2("H2", '\"', '\"', "", "--", "//"),
    MYSQL("MySQL", '`', '`', "#@", "-- ", "--\t", "--\n", "#"),
    PHOENIX("Phoenix", '\"', '\"', "", "--", "//");

    private final String databaseName;
    private final Set<String> oneLineComments;
    private final Set<String> keywords;
    private final boolean storesUpperCaseIdentifier;
    private final boolean storesLowerCaseIdentifier;
    private final char openQuote;
    private final char closeQuote;
    private final String extraNameCharacters;
    private final Dialect.CodeBlocks codeBlocks;

    private BuiltInDialect(String databaseName, char openQuote, char closeQuote, String extraNameCharacters, String ... comments) {
        this(databaseName, openQuote, closeQuote, extraNameCharacters, comments, (Dialect.CodeBlocks)null);
    }

    private BuiltInDialect(String databaseName, char openQuote, char closeQuote, String extraNameCharacters, String[] comments, Dialect.CodeBlocks codeBlocks) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.oneLineComments = Collections.unmodifiableSet(Stream.of(comments).collect(Collectors.toSet()));
        this.storesUpperCaseIdentifier = false;
        this.storesLowerCaseIdentifier = false;
        this.extraNameCharacters = extraNameCharacters;
        this.keywords = Collections.emptySet();
        this.codeBlocks = codeBlocks;
    }

    @Override
    public boolean containsKeyword(String keyword) {
        return this.keywords.contains(keyword) || DEFAULT_KEYWORD_SET.contains(keyword);
    }

    @Override
    public Set<String> getOneLineComments() {
        return this.oneLineComments;
    }

    @Override
    public char getOpenQuote() {
        return this.openQuote;
    }

    @Override
    public char getCloseQuote() {
        return this.closeQuote;
    }

    @Override
    public boolean isLower() {
        return this.storesLowerCaseIdentifier;
    }

    @Override
    public boolean isUpper() {
        return this.storesUpperCaseIdentifier;
    }

    @Override
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Override
    public Dialect.CodeBlocks getCodeBlocks() {
        return this.codeBlocks;
    }

    static Set<String> initDefaultKeywordSet() {
        try {
            TreeSet<String> defaultKeywordSet = new TreeSet<String>();
            String keywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream("sql-keywords.properties"), StandardCharsets.UTF_8)).readLine();
            keywords = keywords + "," + keywords.toLowerCase(Locale.ROOT);
            StringTokenizer tok = new StringTokenizer(keywords, ",");
            while (tok.hasMoreTokens()) {
                defaultKeywordSet.add(tok.nextToken());
            }
            return Collections.unmodifiableSet(defaultKeywordSet);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    static BuiltInDialect valueOf(String databaseName, boolean ignoreCase) {
        if (databaseName == null) {
            return DEFAULT;
        }
        for (BuiltInDialect dialect : BuiltInDialect.values()) {
            if (dialect == DEFAULT || databaseName.length() < dialect.databaseName.length() || !databaseName.regionMatches(ignoreCase, 0, dialect.databaseName, 0, dialect.databaseName.length())) continue;
            return dialect;
        }
        return DEFAULT;
    }

    private static Dialect.CodeBlocks postgresPgSqlBlocksBoundaries() {
        final Pattern postgresqlStartBlock = Pattern.compile("^\\$[a-zA-Z]*\\$$");
        final Pattern postgresqlEndBlockSecondPart = Pattern.compile("^\\s*;*$");
        return new Dialect.CodeBlocks(){

            @Override
            public Predicate<String> isBlockStarted() {
                return currentWord -> postgresqlStartBlock.matcher((CharSequence)currentWord).find();
            }

            @Override
            public BiPredicate<String, String> isBlockEnded() {
                return (prevWord, currentWord) -> prevWord.equals(currentWord) || currentWord.startsWith((String)prevWord) && postgresqlEndBlockSecondPart.matcher(currentWord.substring(prevWord.length())).find();
            }
        };
    }

    private static Dialect.CodeBlocks oraclePLSqlBlocksBoundaries() {
        final Pattern oracleOptionalStartBlock = Pattern.compile("^declare$", 2);
        final Pattern oracleStartBlock = Pattern.compile("^begin$", 2);
        final Pattern endBlock = Pattern.compile("^end\\s*;$", 2);
        return new Dialect.CodeBlocks(){

            @Override
            public Predicate<String> isBlockStarting() {
                return oracleOptionalStartBlock.asPredicate();
            }

            @Override
            public Predicate<String> isBlockStarted() {
                return currentWord -> oracleStartBlock.matcher((CharSequence)currentWord).find();
            }

            @Override
            public BiPredicate<String, String> isBlockEnded() {
                return (s, s2) -> endBlock.matcher((CharSequence)s2).find();
            }
        };
    }
}

