/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;

public abstract class BaseMetadata
implements Metadata {
    public static final long UNDEFINED_TIME = -1L;
    protected final TableInfo tableInfo;
    protected final MetadataInfo metadataInfo;
    protected final TupleMetadata schema;
    protected final Map<SchemaPath, ColumnStatistics<?>> columnsStatistics;
    protected final Map<String, StatisticsHolder<?>> metadataStatistics;
    protected final long lastModifiedTime;

    protected <T extends BaseMetadataBuilder<T>> BaseMetadata(BaseMetadataBuilder<T> builder) {
        this.tableInfo = builder.tableInfo;
        this.metadataInfo = builder.metadataInfo;
        this.schema = builder.schema;
        this.columnsStatistics = builder.columnsStatistics;
        this.metadataStatistics = builder.metadataStatistics.stream().collect(Collectors.toMap(statistic -> statistic.getStatisticsKind().getName(), Function.identity(), (a, b) -> a.getStatisticsKind().isExact() ? a : b));
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    @Override
    public Map<SchemaPath, ColumnStatistics<?>> getColumnsStatistics() {
        return this.columnsStatistics;
    }

    @Override
    public ColumnStatistics<?> getColumnStatistics(SchemaPath columnName) {
        return this.columnsStatistics.get(columnName);
    }

    @Override
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @Override
    public <V> V getStatistic(StatisticsKind<V> statisticsKind) {
        StatisticsHolder<?> statisticsHolder = this.metadataStatistics.get(statisticsKind.getName());
        return statisticsHolder != null ? (V)statisticsHolder.getStatisticsValue() : null;
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind<?> statisticsKind) {
        StatisticsHolder<?> statisticsHolder = this.metadataStatistics.get(statisticsKind.getName());
        return statisticsHolder != null && statisticsHolder.getStatisticsKind().isExact();
    }

    @Override
    public <V> V getStatisticsForColumn(SchemaPath columnName, StatisticsKind<V> statisticsKind) {
        return this.columnsStatistics.get(columnName).get(statisticsKind);
    }

    @Override
    public ColumnMetadata getColumn(SchemaPath name) {
        return SchemaPathUtils.getColumnMetadata(name, this.schema);
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public MetadataInfo getMetadataInfo() {
        return this.metadataInfo;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseMetadata)) {
            return false;
        }
        BaseMetadata that = (BaseMetadata)o;
        return this.lastModifiedTime == that.lastModifiedTime && Objects.equals(this.tableInfo, that.tableInfo) && Objects.equals(this.metadataInfo, that.metadataInfo) && Objects.equals(this.columnsStatistics, that.columnsStatistics) && Objects.equals(this.metadataStatistics, that.metadataStatistics) && (this.schema == that.schema || this.schema != null && this.schema.isEquivalent(that.schema));
    }

    public int hashCode() {
        return Objects.hash(this.tableInfo, this.metadataInfo, this.schema, this.columnsStatistics, this.metadataStatistics, this.lastModifiedTime);
    }

    @Override
    public TableMetadataUnit toMetadataUnit() {
        TableMetadataUnit.Builder builder = TableMetadataUnit.builder();
        this.tableInfo.toMetadataUnitBuilder(builder);
        this.metadataInfo.toMetadataUnitBuilder(builder);
        if (this.schema != null) {
            builder.schema(this.schema.jsonString());
        }
        builder.columnsStatistics(this.columnsStatistics.entrySet().stream().collect(Collectors.toMap(entry -> ((SchemaPath)entry.getKey()).toString(), entry -> ((ColumnStatistics)entry.getValue()).jsonString(), (o, n) -> n)));
        builder.metadataStatistics(this.metadataStatistics.values().stream().map(StatisticsHolder::jsonString).collect(Collectors.toList()));
        builder.lastModifiedTime(this.lastModifiedTime);
        this.toMetadataUnitBuilder(builder);
        return builder.build();
    }

    protected abstract void toMetadataUnitBuilder(TableMetadataUnit.Builder var1);

    protected abstract BaseMetadataBuilder<?> toBuilder();

    public static abstract class BaseMetadataBuilder<T extends BaseMetadataBuilder<T>> {
        protected TableInfo tableInfo;
        protected MetadataInfo metadataInfo;
        protected TupleMetadata schema;
        protected Map<SchemaPath, ColumnStatistics<?>> columnsStatistics;
        protected Collection<StatisticsHolder<?>> metadataStatistics;
        protected long lastModifiedTime = -1L;

        public T tableInfo(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
            return this.self();
        }

        public T metadataInfo(MetadataInfo metadataInfo) {
            this.metadataInfo = metadataInfo;
            return this.self();
        }

        public T schema(TupleMetadata schema) {
            this.schema = schema;
            return this.self();
        }

        public T columnsStatistics(Map<SchemaPath, ColumnStatistics<?>> columnsStatistics) {
            this.columnsStatistics = columnsStatistics;
            return this.self();
        }

        public T metadataStatistics(Collection<StatisticsHolder<?>> metadataStatistics) {
            this.metadataStatistics = metadataStatistics;
            return this.self();
        }

        public T lastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this.self();
        }

        public T metadataUnit(TableMetadataUnit unit) {
            this.tableInfo(TableInfo.builder().metadataUnit(unit).build());
            this.metadataInfo(MetadataInfo.builder().metadataUnit(unit).build());
            this.schema(TupleMetadata.of((String)unit.schema()));
            if (unit.columnsStatistics() != null) {
                this.columnsStatistics(unit.columnsStatistics().entrySet().stream().collect(Collectors.toMap(entry -> SchemaPath.parseFromString((String)((String)entry.getKey())), entry -> ColumnStatistics.of((String)entry.getValue()), (o, n) -> n)));
            }
            if (unit.metadataStatistics() != null) {
                this.metadataStatistics(unit.metadataStatistics().stream().map(StatisticsHolder::of).collect(Collectors.toList()));
            }
            if (unit.lastModifiedTime() != null) {
                this.lastModifiedTime(unit.lastModifiedTime());
            }
            return this.metadataUnitInternal(unit);
        }

        protected void checkRequiredValues() {
            Objects.requireNonNull(this.tableInfo, "tableInfo was not set");
            Objects.requireNonNull(this.metadataInfo, "metadataInfo was not set");
            Objects.requireNonNull(this.columnsStatistics, "columnsStatistics were not set");
            Objects.requireNonNull(this.metadataStatistics, "metadataStatistics were not set");
        }

        public abstract BaseMetadata build();

        protected abstract T self();

        protected abstract T metadataUnitInternal(TableMetadataUnit var1);
    }
}

