/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.DoubleExpressionPredicate;
import org.apache.drill.metastore.expressions.IsPredicate;
import org.apache.drill.metastore.expressions.ListPredicate;
import org.apache.drill.metastore.expressions.SimplePredicate;
import org.apache.drill.metastore.expressions.SingleExpressionPredicate;

public interface FilterExpression {
    public Operator operator();

    public <T> T accept(Visitor<T> var1);

    public static <T> FilterExpression equal(MetastoreColumn column, T value) {
        return new SimplePredicate.Equal<T>(column, value);
    }

    public static <T> FilterExpression notEqual(MetastoreColumn column, T value) {
        return new SimplePredicate.NotEqual<T>(column, value);
    }

    public static <T> FilterExpression lessThan(MetastoreColumn column, T value) {
        return new SimplePredicate.LessThan<T>(column, value);
    }

    public static <T> FilterExpression lessThanOrEqual(MetastoreColumn column, T value) {
        return new SimplePredicate.LessThanOrEqual<T>(column, value);
    }

    public static <T> FilterExpression greaterThan(MetastoreColumn column, T value) {
        return new SimplePredicate.GreaterThan<T>(column, value);
    }

    public static <T> FilterExpression greaterThanOrEqual(MetastoreColumn column, T value) {
        return new SimplePredicate.GreaterThanOrEqual<T>(column, value);
    }

    public static <T> FilterExpression in(MetastoreColumn column, List<T> values) {
        return new ListPredicate.In<T>(column, values);
    }

    @SafeVarargs
    public static <T> FilterExpression in(MetastoreColumn column, T ... values) {
        return FilterExpression.in(column, Arrays.asList(values));
    }

    public static <T> FilterExpression notIn(MetastoreColumn column, List<T> values) {
        return new ListPredicate.NotIn<T>(column, values);
    }

    @SafeVarargs
    public static <T> FilterExpression notIn(MetastoreColumn column, T ... values) {
        return FilterExpression.notIn(column, Arrays.asList(values));
    }

    public static FilterExpression isNull(MetastoreColumn column) {
        return new IsPredicate.IsNull(column);
    }

    public static FilterExpression isNotNull(MetastoreColumn column) {
        return new IsPredicate.IsNotNull(column);
    }

    public static FilterExpression not(FilterExpression expression) {
        return new SingleExpressionPredicate.Not(expression);
    }

    public static FilterExpression and(FilterExpression right, FilterExpression left) {
        return new DoubleExpressionPredicate.And(right, left);
    }

    public static FilterExpression and(FilterExpression right, FilterExpression left, FilterExpression ... expressions) {
        return Stream.of(expressions).reduce(FilterExpression.and(right, left), FilterExpression::and);
    }

    public static FilterExpression or(FilterExpression right, FilterExpression left) {
        return new DoubleExpressionPredicate.Or(right, left);
    }

    public static interface Visitor<T> {
        public T visit(SimplePredicate.Equal<?> var1);

        public T visit(SimplePredicate.NotEqual<?> var1);

        public T visit(SimplePredicate.LessThan<?> var1);

        public T visit(SimplePredicate.LessThanOrEqual<?> var1);

        public T visit(SimplePredicate.GreaterThan<?> var1);

        public T visit(SimplePredicate.GreaterThanOrEqual<?> var1);

        public T visit(ListPredicate.In<?> var1);

        public T visit(ListPredicate.NotIn<?> var1);

        public T visit(IsPredicate.IsNull var1);

        public T visit(IsPredicate.IsNotNull var1);

        public T visit(SingleExpressionPredicate.Not var1);

        public T visit(DoubleExpressionPredicate.And var1);

        public T visit(DoubleExpressionPredicate.Or var1);

        default public T visit(FilterExpression expression) {
            throw new UnsupportedOperationException("Unsupported filter expression: " + expression);
        }
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        IN,
        NOT_IN,
        IS_NULL,
        IS_NOT_NULL,
        NOT,
        AND,
        OR;

    }
}

