/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.internal.storage.LineCloseableIterator;
import io.delta.storage.CloseableIterator;
import io.delta.storage.LogStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005a4Q!\u0003\u0006\u0002\u0002UA\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0005\b\u0005\tS\u0001\u0011\t\u0011)A\u0005;!)!\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)1\n\u0001C!\u0019\")!\f\u0001C!7\")a\f\u0001C\t?\")Q\u000f\u0001C\tm\nA\u0002*\u00193p_B4\u0015\u000e\\3TsN$X-\u001c'pON#xN]3\u000b\u0005-a\u0011aB:u_J\fw-\u001a\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\t!b\u001d;b]\u0012\fGn\u001c8f\u0015\t\t\"#A\u0003eK2$\u0018MC\u0001\u0014\u0003\tIwn\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001a\u001b\u0005A\"BA\u0006\u0011\u0013\tQ\u0002D\u0001\u0005M_\u001e\u001cFo\u001c:f\u00039Ig.\u001b;IC\u0012|w\u000e]\"p]\u001a,\u0012!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nAaY8oM*\u0011!eI\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0005\u0003Q}\u0011QbQ8oM&<WO]1uS>t\u0017aD5oSRD\u0015\rZ8pa\u000e{gN\u001a\u0011\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t!\u0002C\u0003\u001c\u0007\u0001\u0007Q$\u0001\u0003sK\u0006$GcA\u0019B\u0013B\u0019qC\r\u001b\n\u0005MB\"!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB\u0011QG\u0010\b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u000b\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uR\u0004\"\u0002\"\u0005\u0001\u0004\u0019\u0015\u0001\u00029bi\"\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u0011\u0002\u0005\u0019\u001c\u0018B\u0001%F\u0005\u0011\u0001\u0016\r\u001e5\t\u000b)#\u0001\u0019A\u000f\u0002\u0015!\fGm\\8q\u0007>tg-\u0001\u0005mSN$hI]8n)\ri\u0005,\u0017\t\u0004\u001dN+V\"A(\u000b\u0005A\u000b\u0016\u0001B;uS2T\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\nA\u0011\n^3sCR|'\u000f\u0005\u0002E-&\u0011q+\u0012\u0002\u000b\r&dWm\u0015;biV\u001c\b\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"\u0002&\u0006\u0001\u0004i\u0012\u0001\b:fg>dg/\u001a)bi\"|e\u000e\u00155zg&\u001c\u0017\r\\*u_J\fw-\u001a\u000b\u0004\u0007rk\u0006\"\u0002\"\u0007\u0001\u0004\u0019\u0005\"\u0002&\u0007\u0001\u0004i\u0012aD<sSR,w+\u001b;i%\u0016t\u0017-\\3\u0015\u000b\u0001$Wm\u001c;\u0011\u0005\u0005\u0014W\"\u0001\u001e\n\u0005\rT$\u0001B+oSRDQAQ\u0004A\u0002\rCQAZ\u0004A\u0002\u001d\fq!Y2uS>t7\u000fE\u0002i[Rr!![6\u000f\u0005]R\u0017\"A\u001e\n\u00051T\u0014a\u00029bG.\fw-Z\u0005\u0003):T!\u0001\u001c\u001e\t\u000bA<\u0001\u0019A9\u0002\u0013=4XM]<sSR,\u0007CA1s\u0013\t\u0019(HA\u0004C_>dW-\u00198\t\u000b);\u0001\u0019A\u000f\u0002\u001d\r\u0014X-\u0019;f)\u0016l\u0007\u000fU1uQR\u00111i\u001e\u0005\u0006\u0005\"\u0001\ra\u0011")
public abstract class HadoopFileSystemLogStore
extends LogStore {
    private final Configuration initHadoopConf;

    public Configuration initHadoopConf() {
        return this.initHadoopConf;
    }

    public CloseableIterator<String> read(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        FSDataInputStream stream = fs.open(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        return new LineCloseableIterator(reader);
    }

    public java.util.Iterator<FileStatus> listFrom(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        FileStatus[] files = fs.listStatus(path.getParent());
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(x$1.getPath().getName()), path.getName())))), (Function1 & Serializable)x$2 -> x$2.getPath().getName(), (Ordering)Ordering.String$.MODULE$)))).asJava();
    }

    public Path resolvePathOnPhysicalStorage(Path path, Configuration hadoopConf) {
        return path.getFileSystem(hadoopConf).makeQualified(path);
    }

    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        block15: {
            FileSystem fs = path.getFileSystem(hadoopConf);
            if (!fs.exists(path.getParent())) {
                throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
            }
            if (overwrite) {
                try (FSDataOutputStream stream = fs.create(path, true);){
                    actions.map((Function1 & Serializable)x$3 -> new StringBuilder(1).append((String)x$3).append("\n").toString()).map((Function1 & Serializable)x$4 -> x$4.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable)x$1 -> {
                        stream.write(x$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (fs.exists(path)) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
            Path tempPath = this.createTempPath(path);
            boolean streamClosed = false;
            boolean renameDone = false;
            FSDataOutputStream stream = fs.create(tempPath);
            try {
                actions.map((Function1 & Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                streamClosed = true;
                try {
                    if (fs.rename(tempPath, path)) {
                        renameDone = true;
                        break block15;
                    }
                    if (fs.exists(path)) {
                        throw new java.nio.file.FileAlreadyExistsException(path.toString());
                    }
                    throw new IllegalStateException(new StringBuilder(18).append("Cannot rename ").append(tempPath).append(" to ").append(path).toString());
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            finally {
                if (!streamClosed) {
                    stream.close();
                }
                if (!renameDone) {
                    fs.delete(tempPath, false);
                }
            }
        }
    }

    public Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
    }

    public HadoopFileSystemLogStore(Configuration initHadoopConf) {
        this.initHadoopConf = initHadoopConf;
        super(initHadoopConf);
    }
}

