/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.exception;

import io.delta.standalone.exceptions.ConcurrentAppendException;
import io.delta.standalone.exceptions.ConcurrentDeleteDeleteException;
import io.delta.standalone.exceptions.ConcurrentDeleteReadException;
import io.delta.standalone.exceptions.ConcurrentTransactionException;
import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.exceptions.MetadataChangedException;
import io.delta.standalone.exceptions.ProtocolChangedException;
import io.delta.standalone.internal.actions.CommitInfo;
import io.delta.standalone.internal.util.JsonUtils$;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.StructType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DeltaErrors$ {
    public static final DeltaErrors$ MODULE$ = new DeltaErrors$();
    private static final String EmptyCheckpointErrorMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |Attempted to write an empty checkpoint without any actions. This checkpoint will not be\n       |useful in recomputing the state of the table. However this might cause other checkpoints to\n       |get deleted based on retention settings.\n     "));

    public RuntimeException illegalExpressionValueType(String exprName, String expectedType, String ... realTypes) {
        return this.illegalExpressionValueType(exprName, expectedType, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])realTypes));
    }

    public String EmptyCheckpointErrorMessage() {
        return EmptyCheckpointErrorMessage;
    }

    public Throwable deltaVersionsNotContiguousException(Seq<Object> deltaVersions) {
        return new IllegalStateException(new StringBuilder(31).append("Versions (").append(deltaVersions).append(") are not contiguous.").toString());
    }

    public Throwable actionNotFoundException(String action, long version) {
        return new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(166).append("\n         |The ").append(action).append(" of your Delta table couldn't be recovered while Reconstructing\n         |version: ").append(Long.toString(version)).append(". Did you manually delete files in the _delta_log directory?\n       ").toString())));
    }

    public Throwable emptyDirectoryException(String directory) {
        return new FileNotFoundException(new StringBuilder(33).append("No file found in the directory: ").append(directory).append(".").toString());
    }

    public Throwable logFileNotFoundException(Path path, long version) {
        return new FileNotFoundException(new StringBuilder(0).append(new StringBuilder(49).append(path).append(": Unable to reconstruct state at version ").append(version).append(" as the ").toString()).append("transaction log has been truncated due to manual deletion or the log retention policy ").toString());
    }

    public Throwable missingPartFilesException(long version, Exception e) {
        return new IllegalStateException(new StringBuilder(56).append("Couldn't find all part files of the checkpoint version: ").append(version).toString(), e);
    }

    public DeltaStandaloneException noReproducibleHistoryFound(Path logPath) {
        return new DeltaStandaloneException(new StringBuilder(33).append("No reproducible commits found at ").append(logPath).toString());
    }

    public Throwable timestampEarlierThanTableFirstCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(152).append("The provided timestamp (").append(userTimestamp).append(") is before the earliest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp greater than or equal to ").append(commitTs).append(".\n       ").toString())));
    }

    public Throwable timestampLaterThanTableLastCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(146).append("The provided timestamp (").append(userTimestamp).append(") is after the latest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp less than or equal to ").append(commitTs).append(".\n       ").toString())));
    }

    public DeltaStandaloneException noHistoryFound(Path logPath) {
        return new DeltaStandaloneException(new StringBuilder(20).append("No commits found at ").append(logPath).toString());
    }

    public Throwable versionNotExistException(long userVersion, long earliest, long latest) {
        return new DeltaStandaloneException(new StringBuilder(0).append(new StringBuilder(44).append("Cannot time travel Delta table to version ").append(userVersion).append(". ").toString()).append(new StringBuilder(25).append("Available versions: [").append(earliest).append(", ").append(latest).append("].").toString()).toString());
    }

    public Throwable nullValueFoundForPrimitiveTypes(String fieldName) {
        return new NullPointerException(new StringBuilder(55).append("Read a null value for field ").append(fieldName).append(" which is a primitive type.").toString());
    }

    public Throwable nullValueFoundForNonNullSchemaField(String fieldName, StructType schema) {
        return new NullPointerException(new StringBuilder(0).append(new StringBuilder(51).append("Read a null value for field ").append(fieldName).append(", yet schema indicates ").toString()).append(new StringBuilder(39).append("that this field can't be null. Schema: ").append(schema.getTreeString()).toString()).toString());
    }

    public Throwable fieldTypeMismatch(String fieldName, DataType actualType, String desiredType) {
        return new ClassCastException(new StringBuilder(0).append(new StringBuilder(29).append("The data type of field ").append(fieldName).append(" is ").append(actualType.getTypeName()).append(". ").toString()).append(new StringBuilder(18).append("Cannot cast it to ").append(desiredType).toString()).toString());
    }

    public Throwable failOnDataLossException(long expectedVersion, long seenVersion) {
        return new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(468).append("The stream from your Delta table was expecting process data from version ").append(expectedVersion).append(",\n         |but the earliest available version in the _delta_log directory is ").append(seenVersion).append(". The files\n         |in the transaction log may have been deleted due to log cleanup.\n         |\n         |If you would like to ignore the missed data and continue your stream from where it left\n         |off, you can set the .option(\"failOnDataLoss\", \"false\") as part\n         |of your readStream statement.\n       ").toString())));
    }

    public Throwable metadataAbsentException() {
        return new IllegalStateException("Couldn't find Metadata while committing the first version of the Delta table.");
    }

    public Throwable addFilePartitioningMismatchException(Seq<String> addFilePartitions, Seq<String> metadataPartitions) {
        return new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(145).append("\n         |The AddFile contains partitioning schema different from the table's partitioning schema\n         |expected: ").append(this.formatColumnList(metadataPartitions)).append("\n         |actual: ").append(this.formatColumnList(addFilePartitions)).append("\n      ").toString())));
    }

    public Throwable modifyAppendOnlyTableException() {
        return new UnsupportedOperationException(new StringBuilder(76).append("This table is configured to only allow appends. If you would like to permit ").append("updates or deletes, use 'ALTER TABLE <table_name> SET TBLPROPERTIES ").append("(appendOnly=false)'.").toString());
    }

    public DeltaStandaloneException invalidColumnName(String name) {
        return new DeltaStandaloneException(Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(118).append("Attribute name \"").append(name).append("\" contains invalid character(s) among \" ,;{}()\\n\\t=\".\n         |Please use alias to rename it.\n       ").toString())).split("\n")).mkString(" ").trim());
    }

    public DeltaStandaloneException invalidPartitionColumn(RuntimeException e) {
        return new DeltaStandaloneException("Found partition columns having invalid character(s) among \" ,;{}()\\n\\t=\". Please change the name to your partition columns. This check can be turned off by setting spark.conf.set(\"spark.databricks.delta.partitionColumnValidity.enabled\", false) however this is not recommended as other features of Delta may not work properly.", e);
    }

    public Throwable incorrectLogStoreImplementationException(Throwable cause) {
        return new IOException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n     |The error typically occurs when the default LogStore implementation, that\n     |is, HDFSLogStore, is used to write into a Delta table on a non-HDFS storage system.\n     |In order to get the transactional ACID guarantees on table updates, you have to use the\n     |correct implementation of LogStore that is appropriate for your storage system.\n     |See https://docs.delta.io/latest/delta-storage.html for details.\n      ")), cause);
    }

    public String concurrentModificationExceptionMsg(String baseMessage, Option<CommitInfo> commit2) {
        return new StringBuilder(0).append(baseMessage).append(commit2.map((Function1 & Serializable)ci -> new StringBuilder(21).append("\nConflicting commit: ").append(JsonUtils$.MODULE$.toJson(ci, ManifestFactory$.MODULE$.classType(CommitInfo.class))).toString()).getOrElse((Function0 & Serializable)() -> "")).append("\nRefer to https://docs.delta.io/latest/concurrency-control.html for more details.").toString();
    }

    public MetadataChangedException metadataChangedException(Option<CommitInfo> conflictingCommit) {
        String message = this.concurrentModificationExceptionMsg("The metadata of the Delta table has been changed by a concurrent update. Please try the operation again.", conflictingCommit);
        return new MetadataChangedException(message);
    }

    public ProtocolChangedException protocolChangedException(Option<CommitInfo> conflictingCommit) {
        String additionalInfo = (String)conflictingCommit.map((Function1 & Serializable)v -> BoxesRunTime.equals((Object)v.version().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1), (Object)BoxesRunTime.boxToInteger((int)0)) ? "This happens when multiple writers are writing to an empty directory. Creating the table ahead of time will avoid this conflict. " : "").getOrElse((Function0 & Serializable)() -> "");
        String message = this.concurrentModificationExceptionMsg(new StringBuilder(112).append("The protocol version of the Delta table has been changed by a concurrent update. ").append(additionalInfo).append("Please try the operation again.").toString(), conflictingCommit);
        return new ProtocolChangedException(message);
    }

    public ConcurrentAppendException concurrentAppendException(Option<CommitInfo> conflictingCommit, String partition) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder(0).append(new StringBuilder(45).append("Files were added to ").append(partition).append(" by a concurrent update. ").toString()).append("Please try the operation again.").toString(), conflictingCommit);
        return new ConcurrentAppendException(message);
    }

    public ConcurrentDeleteReadException concurrentDeleteReadException(Option<CommitInfo> conflictingCommit, String file) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder(70).append("This transaction attempted to read one or more files that were deleted").append(new StringBuilder(71).append(" (for example ").append(file).append(") by a concurrent update. Please try the operation again.").toString()).toString(), conflictingCommit);
        return new ConcurrentDeleteReadException(message);
    }

    public ConcurrentDeleteDeleteException concurrentDeleteDeleteException(Option<CommitInfo> conflictingCommit, String file) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder(73).append("This transaction attempted to delete one or more files that were deleted ").append(new StringBuilder(70).append("(for example ").append(file).append(") by a concurrent update. Please try the operation again.").toString()).toString(), conflictingCommit);
        return new ConcurrentDeleteDeleteException(message);
    }

    public ConcurrentTransactionException concurrentTransactionException(Option<CommitInfo> conflictingCommit) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder(93).append("This error occurs when multiple streaming queries are using the same checkpoint to write ").append("into this table. Did you run multiple instances of the same streaming query").append(" at the same time?").toString(), conflictingCommit);
        return new ConcurrentTransactionException(message);
    }

    public Throwable maxCommitRetriesExceededException(int attemptNumber, long attemptVersion, long initAttemptVersion, int numActions, long totalCommitAttemptTime) {
        return new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(385).append("This commit has failed as it has been tried ").append(attemptNumber).append(" times but did not succeed.\n         |This can be caused by the Delta table being committed continuously by many concurrent\n         |commits.\n         |\n         |Commit started at version: ").append(initAttemptVersion).append("\n         |Commit failed at version: ").append(attemptVersion).append("\n         |Number of actions attempted to commit: ").append(numActions).append("\n         |Total time spent attempting this commit: ").append(totalCommitAttemptTime).append(" ms\n       ").toString())));
    }

    public DeltaStandaloneException nestedNotNullConstraint(String parent, DataType nested, String nestType) {
        return new DeltaStandaloneException(new StringBuilder(0).append(new StringBuilder(44).append("The ").append(nestType).append(" type of the field ").append(parent).append(" contains a NOT NULL ").toString()).append("constraint. Delta does not support NOT NULL constraints nested within arrays or maps. ").append(new StringBuilder(14).append("Parsed ").append(nestType).append(" type:\n").append(nested.toPrettyJson()).toString()).toString());
    }

    public Throwable checkpointNonExistTable(Path path) {
        return new IllegalStateException(new StringBuilder(0).append(new StringBuilder(55).append("Cannot checkpoint a non-exist table ").append(path).append(". Did you manually ").toString()).append("delete files in the _delta_log directory?").toString());
    }

    public Throwable cannotModifyTableProperty(String prop) {
        throw new UnsupportedOperationException(new StringBuilder(62).append("The Delta table configuration ").append(prop).append(" cannot be specified by the user").toString());
    }

    public Throwable unknownConfigurationKeyException(String confKey) {
        return new DeltaStandaloneException(new StringBuilder(37).append("Unknown configuration was specified: ").append(confKey).toString());
    }

    public Throwable schemaChangedException(StructType oldSchema, StructType newSchema) {
        String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(97).append("Detected incompatible schema change:\n        |old schema: ").append(oldSchema.getTreeString()).append("\n        |\n        |new schema: ").append(newSchema.getTreeString()).append("\n      ").toString()));
        return new IllegalStateException(msg);
    }

    public RuntimeException illegalExpressionValueType(String exprName, String expectedType, Seq<String> realTypes) {
        return new IllegalArgumentException(new StringBuilder(38).append(exprName).append(" expression requires ").append(expectedType).append(" type. But found ").append(realTypes.mkString(", ")).toString());
    }

    public Throwable logStoreConfConflicts(Seq<String> classConf, Seq<String> schemeConf) {
        String schemeConfStr = schemeConf.mkString(", ");
        String classConfStr = classConf.mkString(", ");
        return new IllegalArgumentException(new StringBuilder(67).append(new StringBuilder(13).append("(`").append(classConfStr).append("`) and (`").append(schemeConfStr).append("`)").toString()).append(" cannot be set at the same time. Please set only one group of them.").toString());
    }

    public Throwable inconsistentLogStoreConfs(Seq<Tuple2<String, String>> setKeys) {
        String setKeyStr = ((IterableOnceOps)setKeys.map((Function1 & Serializable)x$1 -> x$1.productIterator().mkString(" = "))).mkString(", ");
        return new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(79).append("(").append(setKeyStr).append(") cannot be set to different values. Please only set one of them, or set them ").toString()).append("to the same value.").toString());
    }

    public Throwable partitionColumnsNotFoundException(Seq<String> partCols, StructType schema) {
        return new DeltaStandaloneException(new StringBuilder(0).append(new StringBuilder(34).append("Partition column(s) ").append(partCols.mkString(",")).append(" not found in ").toString()).append(new StringBuilder(8).append("schema:\n").append(schema.getTreeString()).toString()).toString());
    }

    public Throwable nonPartitionColumnAbsentException() {
        return new DeltaStandaloneException("Data written into Delta needs to contain at least one non-partitioned column");
    }

    private String formatColumn(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    private String formatColumnList(Seq<String> colNames) {
        return ((IterableOnceOps)colNames.map((Function1 & Serializable)colName -> MODULE$.formatColumn((String)colName))).mkString("[", ", ", "]");
    }

    private DeltaErrors$() {
    }
}

