/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.Action;
import io.delta.standalone.actions.JobInfo;
import io.delta.standalone.actions.NotebookInfo;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitInfo
implements Action {
    @Nonnull
    private final Optional<Long> version;
    @Nullable
    private final Timestamp timestamp;
    @Nonnull
    private final Optional<String> userId;
    @Nonnull
    private final Optional<String> userName;
    @Nullable
    private final String operation;
    @Nullable
    private final Map<String, String> operationParameters;
    @Nonnull
    private final Optional<JobInfo> jobInfo;
    @Nonnull
    private final Optional<NotebookInfo> notebookInfo;
    @Nonnull
    private final Optional<String> clusterId;
    @Nonnull
    private final Optional<Long> readVersion;
    @Nonnull
    private final Optional<String> isolationLevel;
    @Nonnull
    private final Optional<Boolean> isBlindAppend;
    @Nonnull
    private final Optional<Map<String, String>> operationMetrics;
    @Nonnull
    private final Optional<String> userMetadata;
    @Nonnull
    private final Optional<String> engineInfo;

    public CommitInfo(@Nonnull Optional<Long> optional, @Nullable Timestamp timestamp, @Nonnull Optional<String> optional2, @Nonnull Optional<String> optional3, @Nullable String string, @Nullable Map<String, String> map, @Nonnull Optional<JobInfo> optional4, @Nonnull Optional<NotebookInfo> optional5, @Nonnull Optional<String> optional6, @Nonnull Optional<Long> optional7, @Nonnull Optional<String> optional8, @Nonnull Optional<Boolean> optional9, @Nonnull Optional<Map<String, String>> optional10, @Nonnull Optional<String> optional11) {
        this.version = optional;
        this.timestamp = timestamp;
        this.userId = optional2;
        this.userName = optional3;
        this.operation = string;
        this.operationParameters = map;
        this.jobInfo = optional4;
        this.notebookInfo = optional5;
        this.clusterId = optional6;
        this.readVersion = optional7;
        this.isolationLevel = optional8;
        this.isBlindAppend = optional9;
        this.operationMetrics = optional10;
        this.userMetadata = optional11;
        this.engineInfo = Optional.empty();
    }

    public CommitInfo(@Nonnull Optional<Long> optional, @Nullable Timestamp timestamp, @Nonnull Optional<String> optional2, @Nonnull Optional<String> optional3, @Nullable String string, @Nullable Map<String, String> map, @Nonnull Optional<JobInfo> optional4, @Nonnull Optional<NotebookInfo> optional5, @Nonnull Optional<String> optional6, @Nonnull Optional<Long> optional7, @Nonnull Optional<String> optional8, @Nonnull Optional<Boolean> optional9, @Nonnull Optional<Map<String, String>> optional10, @Nonnull Optional<String> optional11, @Nonnull Optional<String> optional12) {
        this.version = optional;
        this.timestamp = timestamp;
        this.userId = optional2;
        this.userName = optional3;
        this.operation = string;
        this.operationParameters = map;
        this.jobInfo = optional4;
        this.notebookInfo = optional5;
        this.clusterId = optional6;
        this.readVersion = optional7;
        this.isolationLevel = optional8;
        this.isBlindAppend = optional9;
        this.operationMetrics = optional10;
        this.userMetadata = optional11;
        this.engineInfo = optional12;
    }

    @Nonnull
    public Optional<Long> getVersion() {
        return this.version;
    }

    @Nullable
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public Optional<String> getUserId() {
        return this.userId;
    }

    @Nonnull
    public Optional<String> getUserName() {
        return this.userName;
    }

    @Nullable
    public String getOperation() {
        return this.operation;
    }

    @Nullable
    public Map<String, String> getOperationParameters() {
        if (this.operationParameters != null) {
            return Collections.unmodifiableMap(this.operationParameters);
        }
        return null;
    }

    @Nonnull
    public Optional<JobInfo> getJobInfo() {
        return this.jobInfo;
    }

    @Nonnull
    public Optional<NotebookInfo> getNotebookInfo() {
        return this.notebookInfo;
    }

    @Nonnull
    public Optional<String> getClusterId() {
        return this.clusterId;
    }

    @Nonnull
    public Optional<Long> getReadVersion() {
        return this.readVersion;
    }

    @Nonnull
    public Optional<String> getIsolationLevel() {
        return this.isolationLevel;
    }

    @Nonnull
    public Optional<Boolean> getIsBlindAppend() {
        return this.isBlindAppend;
    }

    @Nonnull
    public Optional<Map<String, String>> getOperationMetrics() {
        return this.operationMetrics.map(Collections::unmodifiableMap);
    }

    @Nonnull
    public Optional<String> getUserMetadata() {
        return this.userMetadata;
    }

    @Nonnull
    public Optional<String> getEngineInfo() {
        return this.engineInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CommitInfo commitInfo = (CommitInfo)object;
        return Objects.equals(this.version, commitInfo.version) && Objects.equals(this.timestamp, commitInfo.timestamp) && Objects.equals(this.userId, commitInfo.userId) && Objects.equals(this.userName, commitInfo.userName) && Objects.equals(this.operation, commitInfo.operation) && Objects.equals(this.operationParameters, commitInfo.operationParameters) && Objects.equals(this.jobInfo, commitInfo.jobInfo) && Objects.equals(this.notebookInfo, commitInfo.notebookInfo) && Objects.equals(this.clusterId, commitInfo.clusterId) && Objects.equals(this.readVersion, commitInfo.readVersion) && Objects.equals(this.isolationLevel, commitInfo.isolationLevel) && Objects.equals(this.isBlindAppend, commitInfo.isBlindAppend) && Objects.equals(this.operationMetrics, commitInfo.operationMetrics) && Objects.equals(this.userMetadata, commitInfo.userMetadata) && Objects.equals(this.engineInfo, commitInfo.engineInfo);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.jobInfo, this.notebookInfo, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend, this.operationMetrics, this.userMetadata, this.engineInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nonnull
        private Optional<Long> version = Optional.empty();
        @Nullable
        private Timestamp timestamp;
        @Nonnull
        private Optional<String> userId = Optional.empty();
        @Nonnull
        private Optional<String> userName = Optional.empty();
        @Nullable
        private String operation;
        @Nullable
        private Map<String, String> operationParameters;
        @Nonnull
        private Optional<JobInfo> jobInfo = Optional.empty();
        @Nonnull
        private Optional<NotebookInfo> notebookInfo = Optional.empty();
        @Nonnull
        private Optional<String> clusterId = Optional.empty();
        @Nonnull
        private Optional<Long> readVersion = Optional.empty();
        @Nonnull
        private Optional<String> isolationLevel = Optional.empty();
        @Nonnull
        private Optional<Boolean> isBlindAppend = Optional.empty();
        @Nonnull
        private Optional<Map<String, String>> operationMetrics = Optional.empty();
        @Nonnull
        private Optional<String> userMetadata = Optional.empty();
        @Nonnull
        private Optional<String> engineInfo = Optional.empty();

        public Builder version(Long l) {
            this.version = Optional.of(l);
            return this;
        }

        public Builder timestamp(@Nullable Timestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder userId(@Nullable String string) {
            this.userId = Optional.of(string);
            return this;
        }

        public Builder userName(String string) {
            this.userName = Optional.of(string);
            return this;
        }

        public Builder operation(String string) {
            this.operation = string;
            return this;
        }

        public Builder operationParameters(@Nullable Map<String, String> map) {
            this.operationParameters = map;
            return this;
        }

        public Builder jobInfo(JobInfo jobInfo) {
            this.jobInfo = Optional.of(jobInfo);
            return this;
        }

        public Builder notebookInfo(NotebookInfo notebookInfo) {
            this.notebookInfo = Optional.of(notebookInfo);
            return this;
        }

        public Builder clusterId(String string) {
            this.clusterId = Optional.of(string);
            return this;
        }

        public Builder readVersion(Long l) {
            this.readVersion = Optional.of(l);
            return this;
        }

        public Builder isolationLevel(String string) {
            this.isolationLevel = Optional.of(string);
            return this;
        }

        public Builder isBlindAppend(Boolean bl) {
            this.isBlindAppend = Optional.of(bl);
            return this;
        }

        public Builder operationMetrics(Map<String, String> map) {
            this.operationMetrics = Optional.of(map);
            return this;
        }

        public Builder userMetadata(String string) {
            this.userMetadata = Optional.of(string);
            return this;
        }

        public Builder engineInfo(String string) {
            this.engineInfo = Optional.of(string);
            return this;
        }

        public CommitInfo build() {
            CommitInfo commitInfo = new CommitInfo(this.version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.jobInfo, this.notebookInfo, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend, this.operationMetrics, this.userMetadata, this.engineInfo);
            return commitInfo;
        }
    }
}

