/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.plan;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.elasticsearch.CalciteUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchColumnConverterFactoryProvider;
import org.apache.drill.exec.store.elasticsearch.plan.ElasticPlanTransformer;
import org.apache.drill.exec.store.enumerable.ColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.plan.EnumerablePrelContext;

public class ElasticSearchEnumerablePrelContext
implements EnumerablePrelContext {
    private final String planPrefix;

    public ElasticSearchEnumerablePrelContext(String planPrefix) {
        this.planPrefix = planPrefix;
    }

    public String generateCode(RelOptCluster cluster, RelNode elasticNode) {
        RelNode enumerableRel = CalciteUtils.getElasticsearchToEnumerableConverterRule().convert(elasticNode);
        ClassDeclaration classDeclaration = new EnumerableRelImplementor(cluster.getRexBuilder(), Collections.emptyMap()).implementRoot((EnumerableRel)enumerableRel, EnumerableRel.Prefer.ARRAY);
        return Expressions.toString(Collections.singletonList(classDeclaration), (String)"\n", (boolean)false);
    }

    public RelNode transformNode(RelNode input) {
        return input.accept(SubsetRemover.INSTANCE).accept((RelShuttle)new ElasticPlanTransformer());
    }

    public Map<String, Integer> getFieldsMap(RelNode transformedNode) {
        return transformedNode.getRowType().getFieldList().stream().collect(Collectors.toMap(relDataTypeField -> relDataTypeField.getName().equals("_MAP") ? "**" : relDataTypeField.getName(), RelDataTypeField::getIndex));
    }

    public String getPlanPrefix() {
        return this.planPrefix;
    }

    public String getTablePath(RelNode input) {
        return null;
    }

    public ColumnConverterFactoryProvider factoryProvider() {
        return ElasticsearchColumnConverterFactoryProvider.INSTANCE;
    }
}

