/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorSymmetricDifferenceLocal;
import com.datastax.oss.driver.shaded.esri.core.geometry.ProgressTracker;
import com.datastax.oss.driver.shaded.esri.core.geometry.SpatialReference;

class OperatorSymmetricDifferenceCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    ProgressTracker m_progress_tracker;
    SpatialReference m_spatial_reference;
    Geometry m_rightGeom;
    int m_index;
    boolean m_bEmpty;

    OperatorSymmetricDifferenceCursor(GeometryCursor inputGeoms, GeometryCursor rightGeom, SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_bEmpty = rightGeom == null;
        this.m_index = -1;
        this.m_inputGeoms = inputGeoms;
        this.m_spatial_reference = sr;
        this.m_rightGeom = rightGeom.next();
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        if (this.m_bEmpty) {
            return null;
        }
        Geometry leftGeom = this.m_inputGeoms.next();
        if (leftGeom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return OperatorSymmetricDifferenceLocal.symmetricDifference(leftGeom, this.m_rightGeom, this.m_spatial_reference, this.m_progress_tracker);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

