/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.NumberUtils;

class ECoordinate {
    private double m_value;
    private double m_eps;

    ECoordinate() {
    }

    double epsCoordinate() {
        return NumberUtils.doubleEps();
    }

    void scaleError(double f) {
        this.m_eps *= f;
    }

    void setError(double e) {
        this.m_eps = e;
    }

    void set(double v, double e) {
        this.m_value = v;
        this.m_eps = e;
    }

    void set(double v) {
        this.m_value = v;
        this.m_eps = 0.0;
    }

    void set(ECoordinate v) {
        this.m_value = v.m_value;
        this.m_eps = v.m_eps;
    }

    double value() {
        return this.m_value;
    }

    double eps() {
        return this.m_eps;
    }

    void resetError() {
        this.m_eps = 0.0;
    }

    void add(ECoordinate v) {
        double r = this.m_value + v.m_value;
        double e = this.m_eps + v.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
        this.m_eps = e;
    }

    void add(double v) {
        double r = this.m_value + v;
        double e = this.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
        this.m_eps = e;
    }

    void sub(ECoordinate v) {
        double r = this.m_value - v.m_value;
        double e = this.m_eps + v.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
        this.m_eps = e;
    }

    void sub(double v) {
        double r = this.m_value - v;
        double e = this.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
        this.m_eps = e;
    }

    void add(ECoordinate v_1, ECoordinate v_2) {
        this.m_value = v_1.m_value + v_2.m_value;
        this.m_eps = v_1.m_eps + v_2.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void add(double v_1, double v_2) {
        this.m_value = v_1 + v_2;
        this.m_eps = this.epsCoordinate() * Math.abs(this.m_value);
    }

    void add(ECoordinate v_1, double v_2) {
        this.m_value = v_1.m_value + v_2;
        this.m_eps = v_1.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void add(double v_1, ECoordinate v_2) {
        this.m_value = v_1 + v_2.m_value;
        this.m_eps = v_2.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void sub(ECoordinate v_1, ECoordinate v_2) {
        this.m_value = v_1.m_value - v_2.m_value;
        this.m_eps = v_1.m_eps + v_2.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void sub(double v_1, double v_2) {
        this.m_value = v_1 - v_2;
        this.m_eps = this.epsCoordinate() * Math.abs(this.m_value);
    }

    void sub(ECoordinate v_1, double v_2) {
        this.m_value = v_1.m_value - v_2;
        this.m_eps = v_1.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void sub(double v_1, ECoordinate v_2) {
        this.m_value = v_1 - v_2.m_value;
        this.m_eps = v_2.m_eps + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void mul(ECoordinate v) {
        double r = this.m_value * v.m_value;
        this.m_eps = this.m_eps * Math.abs(v.m_value) + v.m_eps * Math.abs(this.m_value) + this.m_eps * v.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
    }

    void mul(double v) {
        double r = this.m_value * v;
        this.m_eps = this.m_eps * Math.abs(v) + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
    }

    void mul(ECoordinate v_1, ECoordinate v_2) {
        double r = Math.abs(v_1.m_value) * Math.abs(v_2.m_value);
        this.m_eps = v_1.m_eps * Math.abs(v_2.m_value) + v_2.m_eps * Math.abs(v_1.m_value) + v_1.m_eps * v_2.m_eps + this.epsCoordinate() * Math.abs(r);
        this.m_value = r;
    }

    void mul(double v_1, double v_2) {
        this.m_value = v_1 * v_2;
        this.m_eps = this.epsCoordinate() * Math.abs(this.m_value);
    }

    void mul(ECoordinate v_1, double v_2) {
        this.set(v_1);
        this.mul(v_2);
    }

    void mul(double v_1, ECoordinate v_2) {
        this.set(v_2);
        this.mul(v_1);
    }

    void div(ECoordinate divis) {
        double fabsdivis = Math.abs(divis.m_value);
        double r = this.m_value / divis.m_value;
        double e = (this.m_eps + Math.abs(r) * divis.m_eps) / fabsdivis;
        if (divis.m_eps > 0.01 * fabsdivis) {
            double rr = divis.m_eps / fabsdivis;
            e *= 1.0 + (1.0 + rr) * rr;
        }
        this.m_value = r;
        this.m_eps = e + this.epsCoordinate() * Math.abs(r);
    }

    void div(double v) {
        double fabsdivis = Math.abs(v);
        this.m_value /= v;
        this.m_eps = this.m_eps / fabsdivis + this.epsCoordinate() * Math.abs(this.m_value);
    }

    void div(ECoordinate v_1, ECoordinate v_2) {
        this.set(v_1);
        this.div(v_2);
    }

    void div(double v_1, double v_2) {
        this.m_value = v_1 / v_2;
        this.m_eps = this.epsCoordinate() * Math.abs(this.m_value);
    }

    void div(ECoordinate v_1, double v_2) {
        this.set(v_1);
        this.div(v_2);
    }

    void div(double v_1, ECoordinate v_2) {
        this.set(v_1);
        this.div(v_2);
    }

    void sqrt() {
        double dr;
        double r;
        if (this.m_value >= 0.0) {
            r = Math.sqrt(this.m_value);
            dr = this.m_value > 10.0 * this.m_eps ? 0.5 * this.m_eps / r : (this.m_value > this.m_eps ? r - Math.sqrt(this.m_value - this.m_eps) : Math.max(r, Math.sqrt(this.m_value + this.m_eps) - r));
            dr += this.epsCoordinate() * Math.abs(r);
        } else if (this.m_value < -this.m_eps) {
            r = Double.NaN;
            dr = Double.NaN;
        } else {
            r = 0.0;
            dr = Math.sqrt(this.m_eps);
        }
        this.m_value = r;
        this.m_eps = dr;
    }

    void sqr() {
        double r = this.m_value * this.m_value;
        this.m_eps = 2.0 * this.m_eps * this.m_value + this.m_eps * this.m_eps + this.epsCoordinate() * r;
        this.m_value = r;
    }

    void sin(ECoordinate angle) {
        double sinv = Math.sin(angle.m_value);
        double cosv = Math.cos(angle.m_value);
        this.m_value = sinv;
        double absv = Math.abs(sinv);
        this.m_eps = (Math.abs(cosv) + absv * 0.5 * angle.m_eps) * angle.m_eps + this.epsCoordinate() * absv;
    }

    void cos(ECoordinate angle) {
        double cosv;
        double sinv = Math.sin(angle.m_value);
        this.m_value = cosv = Math.cos(angle.m_value);
        double absv = Math.abs(cosv);
        this.m_eps = (Math.abs(sinv) + absv * 0.5 * angle.m_eps) * angle.m_eps + this.epsCoordinate() * absv;
    }

    void log(ECoordinate v) {
        double d = v.m_eps / v.m_value;
        this.m_value = Math.log(v.m_value);
        this.m_eps = d * (1.0 + 0.5 * d) + this.epsCoordinate() * Math.abs(this.m_value);
    }

    boolean eq(ECoordinate v) {
        return Math.abs(this.m_value - v.m_value) <= this.m_eps + v.m_eps;
    }

    boolean ne(ECoordinate v) {
        return !this.eq(v);
    }

    boolean GT(ECoordinate v) {
        return this.m_value - v.m_value > this.m_eps + v.m_eps;
    }

    boolean lt(ECoordinate v) {
        return v.m_value - this.m_value > this.m_eps + v.m_eps;
    }

    boolean ge(ECoordinate v) {
        return !this.lt(v);
    }

    boolean le(ECoordinate v) {
        return !this.GT(v);
    }

    boolean tolEq(ECoordinate v, double tolerance) {
        return Math.abs(this.m_value - v.m_value) <= tolerance || this.eq(v);
    }

    boolean tol_ne(ECoordinate v, double tolerance) {
        return !this.tolEq(v, tolerance);
    }

    boolean tolGT(ECoordinate v, double tolerance) {
        return this.m_value - v.m_value > tolerance && this.GT(v);
    }

    boolean tollt(ECoordinate v, double tolerance) {
        return v.m_value - this.m_value > tolerance && this.lt(v);
    }

    boolean tolge(ECoordinate v, double tolerance) {
        return !this.tollt(v, tolerance);
    }

    boolean tolle(ECoordinate v, double tolerance) {
        return !this.tolGT(v, tolerance);
    }

    boolean isZero() {
        return Math.abs(this.m_value) <= this.m_eps;
    }

    boolean isFuzzyZero() {
        return this.isZero() && this.m_eps != 0.0;
    }

    boolean tolIsZero(double tolerance) {
        return Math.abs(this.m_value) <= Math.max(this.m_eps, tolerance);
    }

    void setPi() {
        this.set(Math.PI, this.epsCoordinate());
    }

    void setE() {
        this.set(Math.E, this.epsCoordinate());
    }
}

