/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.HeartbeatHandler;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.InboundTrafficMeter;
import com.datastax.oss.driver.internal.core.channel.OutboundTrafficMeter;
import com.datastax.oss.driver.internal.core.channel.ProtocolInitHandler;
import com.datastax.oss.driver.internal.core.channel.StreamIdGenerator;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverConfig;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.protocol.FrameDecoder;
import com.datastax.oss.driver.internal.core.protocol.FrameEncoder;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.netty.bootstrap.Bootstrap;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.channel.ChannelFuture;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandler;
import com.datastax.oss.driver.shaded.netty.channel.ChannelInitializer;
import com.datastax.oss.driver.shaded.netty.channel.ChannelOption;
import com.datastax.oss.driver.shaded.netty.channel.ChannelPipeline;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelFactory.class);
    private static final String DATASTAX_CLOUD_PRODUCT_TYPE = "DATASTAX_APOLLO";
    private static final AtomicBoolean LOGGED_ORPHAN_WARNING = new AtomicBoolean();
    private static final String UNKNOWN_PRODUCT_TYPE = "UNKNOWN";
    public static final String SSL_HANDLER_NAME = "ssl";
    public static final String INBOUND_TRAFFIC_METER_NAME = "inboundTrafficMeter";
    public static final String OUTBOUND_TRAFFIC_METER_NAME = "outboundTrafficMeter";
    public static final String FRAME_TO_BYTES_ENCODER_NAME = "frameToBytesEncoder";
    public static final String FRAME_TO_SEGMENT_ENCODER_NAME = "frameToSegmentEncoder";
    public static final String SEGMENT_TO_BYTES_ENCODER_NAME = "segmentToBytesEncoder";
    public static final String BYTES_TO_FRAME_DECODER_NAME = "bytesToFrameDecoder";
    public static final String BYTES_TO_SEGMENT_DECODER_NAME = "bytesToSegmentDecoder";
    public static final String SEGMENT_TO_FRAME_DECODER_NAME = "segmentToFrameDecoder";
    public static final String HEARTBEAT_HANDLER_NAME = "heartbeat";
    public static final String INFLIGHT_HANDLER_NAME = "inflight";
    public static final String INIT_HANDLER_NAME = "init";
    private final String logPrefix;
    protected final InternalDriverContext context;
    @VisibleForTesting
    volatile ProtocolVersion protocolVersion;
    private volatile String clusterName;
    @VisibleForTesting
    volatile String productType;

    public ChannelFactory(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        DriverExecutionProfile defaultConfig = context.getConfig().getDefaultProfile();
        if (defaultConfig.isDefined(DefaultDriverOption.PROTOCOL_VERSION)) {
            String versionName = defaultConfig.getString(DefaultDriverOption.PROTOCOL_VERSION);
            this.protocolVersion = context.getProtocolVersionRegistry().fromName(versionName);
        }
    }

    public ProtocolVersion getProtocolVersion() {
        ProtocolVersion result = this.protocolVersion;
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"Protocol version not known yet, this should only be called after init");
        return result;
    }

    public void setProtocolVersion(ProtocolVersion newVersion) {
        this.protocolVersion = newVersion;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public CompletionStage<DriverChannel> connect(Node node, DriverChannelOptions options) {
        NodeMetricUpdater nodeMetricUpdater = node instanceof DefaultNode ? ((DefaultNode)node).getMetricUpdater() : NoopNodeMetricUpdater.INSTANCE;
        return this.connect(node.getEndPoint(), options, nodeMetricUpdater);
    }

    @VisibleForTesting
    CompletionStage<DriverChannel> connect(EndPoint endPoint, DriverChannelOptions options, NodeMetricUpdater nodeMetricUpdater) {
        boolean isNegotiating;
        ProtocolVersion currentVersion;
        CompletableFuture<DriverChannel> resultFuture = new CompletableFuture<DriverChannel>();
        CopyOnWriteArrayList<ProtocolVersion> attemptedVersions = new CopyOnWriteArrayList<ProtocolVersion>();
        if (this.protocolVersion != null) {
            currentVersion = this.protocolVersion;
            isNegotiating = false;
        } else {
            currentVersion = this.context.getProtocolVersionRegistry().highestNonBeta();
            isNegotiating = true;
        }
        this.connect(endPoint, options, nodeMetricUpdater, currentVersion, isNegotiating, attemptedVersions, resultFuture);
        return resultFuture;
    }

    private void connect(EndPoint endPoint, DriverChannelOptions options, NodeMetricUpdater nodeMetricUpdater, ProtocolVersion currentVersion, boolean isNegotiating, List<ProtocolVersion> attemptedVersions, CompletableFuture<DriverChannel> resultFuture) {
        NettyOptions nettyOptions = this.context.getNettyOptions();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(nettyOptions.ioEventLoopGroup())).channel(nettyOptions.channelClass())).option(ChannelOption.ALLOCATOR, nettyOptions.allocator())).handler(this.initializer(endPoint, currentVersion, options, nodeMetricUpdater, resultFuture));
        nettyOptions.afterBootstrapInitialized(bootstrap);
        ChannelFuture connectFuture = bootstrap.connect(endPoint.resolve());
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)cf -> {
            if (connectFuture.isSuccess()) {
                Channel channel = connectFuture.channel();
                DriverChannel driverChannel = new DriverChannel(endPoint, channel, this.context.getWriteCoalescer(), currentVersion);
                if (isNegotiating) {
                    this.protocolVersion = currentVersion;
                }
                if (this.clusterName == null) {
                    this.clusterName = driverChannel.getClusterName();
                }
                Map<String, List<String>> supportedOptions = driverChannel.getOptions();
                if (this.productType == null && supportedOptions != null) {
                    String productType;
                    List<String> productTypes = supportedOptions.get("PRODUCT_TYPE");
                    this.productType = productType = productTypes != null && !productTypes.isEmpty() ? productTypes.get(0) : UNKNOWN_PRODUCT_TYPE;
                    DriverConfig driverConfig = this.context.getConfig();
                    if (driverConfig instanceof TypesafeDriverConfig && productType.equals(DATASTAX_CLOUD_PRODUCT_TYPE)) {
                        ((TypesafeDriverConfig)driverConfig).overrideDefaults((Map<DriverOption, Object>)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)ConsistencyLevel.LOCAL_QUORUM.name()));
                    }
                }
                resultFuture.complete(driverChannel);
            } else {
                Throwable error = connectFuture.cause();
                if (error instanceof UnsupportedProtocolVersionException && isNegotiating) {
                    attemptedVersions.add(currentVersion);
                    Optional<ProtocolVersion> downgraded = this.context.getProtocolVersionRegistry().downgrade(currentVersion);
                    if (downgraded.isPresent()) {
                        LOG.debug("[{}] Failed to connect with protocol {}, retrying with {}", new Object[]{this.logPrefix, currentVersion, downgraded.get()});
                        this.connect(endPoint, options, nodeMetricUpdater, downgraded.get(), true, attemptedVersions, resultFuture);
                    } else {
                        resultFuture.completeExceptionally(UnsupportedProtocolVersionException.forNegotiation(endPoint, attemptedVersions));
                    }
                } else {
                    resultFuture.completeExceptionally(error);
                }
            }
        }));
    }

    @VisibleForTesting
    ChannelInitializer<Channel> initializer(EndPoint endPoint, ProtocolVersion protocolVersion, DriverChannelOptions options, NodeMetricUpdater nodeMetricUpdater, CompletableFuture<DriverChannel> resultFuture) {
        return new ChannelFactoryInitializer(endPoint, protocolVersion, options, nodeMetricUpdater, resultFuture);
    }

    class ChannelFactoryInitializer
    extends ChannelInitializer<Channel> {
        private final EndPoint endPoint;
        private final ProtocolVersion protocolVersion;
        private final DriverChannelOptions options;
        private final NodeMetricUpdater nodeMetricUpdater;
        private final CompletableFuture<DriverChannel> resultFuture;

        ChannelFactoryInitializer(EndPoint endPoint, ProtocolVersion protocolVersion, DriverChannelOptions options, NodeMetricUpdater nodeMetricUpdater, CompletableFuture<DriverChannel> resultFuture) {
            this.endPoint = endPoint;
            this.protocolVersion = protocolVersion;
            this.options = options;
            this.nodeMetricUpdater = nodeMetricUpdater;
            this.resultFuture = resultFuture;
        }

        @Override
        protected void initChannel(Channel channel) {
            try {
                DriverExecutionProfile defaultConfig = ChannelFactory.this.context.getConfig().getDefaultProfile();
                long setKeyspaceTimeoutMillis = defaultConfig.getDuration(DefaultDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT).toMillis();
                int maxFrameLength = (int)defaultConfig.getBytes(DefaultDriverOption.PROTOCOL_MAX_FRAME_LENGTH);
                int maxRequestsPerConnection = defaultConfig.getInt(DefaultDriverOption.CONNECTION_MAX_REQUESTS);
                int maxOrphanRequests = defaultConfig.getInt(DefaultDriverOption.CONNECTION_MAX_ORPHAN_REQUESTS);
                if (maxOrphanRequests >= maxRequestsPerConnection) {
                    if (LOGGED_ORPHAN_WARNING.compareAndSet(false, true)) {
                        LOG.warn("[{}] Invalid value for {}: {}. It must be lower than {}. Defaulting to {} (1/4 of max-requests) instead.", new Object[]{ChannelFactory.this.logPrefix, DefaultDriverOption.CONNECTION_MAX_ORPHAN_REQUESTS.getPath(), maxOrphanRequests, DefaultDriverOption.CONNECTION_MAX_REQUESTS.getPath(), maxRequestsPerConnection / 4});
                    }
                    maxOrphanRequests = maxRequestsPerConnection / 4;
                }
                InFlightHandler inFlightHandler = new InFlightHandler(this.protocolVersion, new StreamIdGenerator(maxRequestsPerConnection), maxOrphanRequests, setKeyspaceTimeoutMillis, channel.newPromise(), this.options.eventCallback, this.options.ownerLogPrefix);
                HeartbeatHandler heartbeatHandler = new HeartbeatHandler(defaultConfig);
                ProtocolInitHandler initHandler = new ProtocolInitHandler(ChannelFactory.this.context, this.protocolVersion, ChannelFactory.this.clusterName, this.endPoint, this.options, heartbeatHandler, true);
                ChannelPipeline pipeline = channel.pipeline();
                ChannelFactory.this.context.getSslHandlerFactory().map(f -> f.newSslHandler(channel, this.endPoint)).map(h -> pipeline.addLast(ChannelFactory.SSL_HANDLER_NAME, (ChannelHandler)h));
                SessionMetricUpdater sessionMetricUpdater = ChannelFactory.this.context.getMetricsFactory().getSessionUpdater();
                if (this.nodeMetricUpdater.isEnabled(DefaultNodeMetric.BYTES_RECEIVED, null) || sessionMetricUpdater.isEnabled(DefaultSessionMetric.BYTES_RECEIVED, null)) {
                    pipeline.addLast(ChannelFactory.INBOUND_TRAFFIC_METER_NAME, (ChannelHandler)new InboundTrafficMeter(this.nodeMetricUpdater, sessionMetricUpdater));
                }
                if (this.nodeMetricUpdater.isEnabled(DefaultNodeMetric.BYTES_SENT, null) || sessionMetricUpdater.isEnabled(DefaultSessionMetric.BYTES_SENT, null)) {
                    pipeline.addLast(ChannelFactory.OUTBOUND_TRAFFIC_METER_NAME, (ChannelHandler)new OutboundTrafficMeter(this.nodeMetricUpdater, sessionMetricUpdater));
                }
                pipeline.addLast(ChannelFactory.FRAME_TO_BYTES_ENCODER_NAME, (ChannelHandler)new FrameEncoder(ChannelFactory.this.context.getFrameCodec(), maxFrameLength)).addLast(ChannelFactory.BYTES_TO_FRAME_DECODER_NAME, (ChannelHandler)new FrameDecoder(ChannelFactory.this.context.getFrameCodec(), maxFrameLength)).addLast(ChannelFactory.INFLIGHT_HANDLER_NAME, (ChannelHandler)inFlightHandler).addLast(ChannelFactory.INIT_HANDLER_NAME, (ChannelHandler)initHandler);
                ChannelFactory.this.context.getNettyOptions().afterChannelInitialized(channel);
            }
            catch (Throwable t) {
                this.resultFuture.completeExceptionally(t);
                throw t;
            }
        }
    }
}

