/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.links;

import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.exceptions.HdfBrokenLinkException;
import io.jhdf.links.AbstractLink;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class SoftLink
extends AbstractLink {
    private final String target;

    public SoftLink(String target, String name, Group parent) {
        super(name, parent);
        this.target = target;
        this.targetNode = new LinkTargetLazyInitializer();
    }

    @Override
    public Node getTarget() {
        try {
            return (Node)this.targetNode.get();
        }
        catch (Exception e) {
            throw new HdfBrokenLinkException("Could not resolve link target '" + this.target + "' from link '" + this.getPath() + "'", e);
        }
    }

    @Override
    public String getTargetPath() {
        return this.target;
    }

    public String toString() {
        return "SoftLink [name=" + this.name + ", target=" + this.target + "]";
    }

    private class LinkTargetLazyInitializer
    extends LazyInitializer<Node> {
        private LinkTargetLazyInitializer() {
        }

        protected Node initialize() {
            return SoftLink.this.parent.getHdfFile().getByPath(SoftLink.this.target);
        }
    }
}

