/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1Data;
import io.jhdf.btree.BTreeV1Group;
import io.jhdf.exceptions.HdfException;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BTreeV1 {
    private static final Logger logger = LoggerFactory.getLogger(BTreeV1.class);
    private static final byte[] BTREE_NODE_V1_SIGNATURE = "TREE".getBytes(StandardCharsets.US_ASCII);
    private static final int HEADER_BYTES = 6;
    private final long address;
    protected final int entriesUsed;
    private final long leftSiblingAddress;
    private final long rightSiblingAddress;

    public static BTreeV1Group createGroupBTree(HdfBackingStorage hdfBackingStorage, long address) {
        ByteBuffer header = BTreeV1.readHeaderAndValidateSignature(hdfBackingStorage, address);
        byte nodeType = header.get();
        if (nodeType != 0) {
            throw new HdfException("B tree type is not group. Type is: " + nodeType);
        }
        byte nodeLevel = header.get();
        if (nodeLevel > 0) {
            return new BTreeV1Group.BTreeV1GroupNonLeafNode(hdfBackingStorage, address);
        }
        return new BTreeV1Group.BTreeV1GroupLeafNode(hdfBackingStorage, address);
    }

    public static BTreeV1Data createDataBTree(HdfBackingStorage hdfBackingStorage, long address, int dataDimensions) {
        ByteBuffer header = BTreeV1.readHeaderAndValidateSignature(hdfBackingStorage, address);
        byte nodeType = header.get();
        if (nodeType != 1) {
            throw new HdfException("B tree type is not data. Type is: " + nodeType);
        }
        byte nodeLevel = header.get();
        if (nodeLevel > 0) {
            return new BTreeV1Data.BTreeV1DataNonLeafNode(hdfBackingStorage, address, dataDimensions);
        }
        return new BTreeV1Data.BTreeV1DataLeafNode(hdfBackingStorage, address, dataDimensions);
    }

    public static ByteBuffer readHeaderAndValidateSignature(HdfBackingStorage fc, long address) {
        ByteBuffer header = fc.readBufferFromAddress(address, 6);
        byte[] formatSignatureByte = new byte[4];
        header.get(formatSignatureByte, 0, formatSignatureByte.length);
        if (!Arrays.equals(BTREE_NODE_V1_SIGNATURE, formatSignatureByte)) {
            throw new HdfException("B tree V1 node signature not matched");
        }
        return header;
    }

    BTreeV1(HdfBackingStorage hdfBackingStorage, long address) {
        this.address = address;
        int headerSize = 8 * hdfBackingStorage.getSizeOfOffsets();
        ByteBuffer header = hdfBackingStorage.readBufferFromAddress(address + 6L, headerSize);
        this.entriesUsed = Utils.readBytesAsUnsignedInt(header, 2);
        logger.trace("Entries = {}", (Object)this.entriesUsed);
        this.leftSiblingAddress = Utils.readBytesAsUnsignedLong(header, hdfBackingStorage.getSizeOfOffsets());
        logger.trace("left address = {}", (Object)this.leftSiblingAddress);
        this.rightSiblingAddress = Utils.readBytesAsUnsignedLong(header, hdfBackingStorage.getSizeOfOffsets());
        logger.trace("right address = {}", (Object)this.rightSiblingAddress);
    }

    public int getEntriesUsed() {
        return this.entriesUsed;
    }

    public long getLeftSiblingAddress() {
        return this.leftSiblingAddress;
    }

    public long getRightSiblingAddress() {
        return this.rightSiblingAddress;
    }

    public long getAddress() {
        return this.address;
    }

    public abstract List<Long> getChildAddresses();
}

