/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AbstractNode;
import io.jhdf.CommittedDatatype;
import io.jhdf.FractalHeap;
import io.jhdf.GroupSymbolTableNode;
import io.jhdf.HdfFile;
import io.jhdf.LocalHeap;
import io.jhdf.ObjectHeader;
import io.jhdf.SymbolTableEntry;
import io.jhdf.Utils;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Link;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.btree.BTreeV1;
import io.jhdf.btree.BTreeV1Group;
import io.jhdf.btree.BTreeV2;
import io.jhdf.btree.record.LinkNameForIndexedGroupRecord;
import io.jhdf.dataset.DatasetLoader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfInvalidPathException;
import io.jhdf.links.ExternalLink;
import io.jhdf.links.SoftLink;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.LinkInfoMessage;
import io.jhdf.object.message.LinkMessage;
import io.jhdf.object.message.SymbolTableMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupImpl
extends AbstractNode
implements Group {
    private static final Logger logger = LoggerFactory.getLogger(GroupImpl.class);
    private final LazyInitializer<Map<String, Node>> children;

    private GroupImpl(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent) {
        super(hdfBackingStorage, address, name, parent);
        logger.trace("Creating group '{}'...", (Object)name);
        this.children = new ChildrenLazyInitializer(hdfBackingStorage, this);
        logger.debug("Created group '{}'", (Object)this.getPath());
    }

    private GroupImpl(HdfBackingStorage hdfBackingStorage, long objectHeaderAddress, HdfFile parent) {
        super(hdfBackingStorage, objectHeaderAddress, "", parent);
        logger.trace("Creating root group...");
        this.children = new ChildrenLazyInitializer(hdfBackingStorage, parent);
        logger.debug("Created root group of file '{}'", (Object)parent.getName());
    }

    static Group createGroup(HdfBackingStorage hdfBackingStorage, long objectHeaderAddress, String name, Group parent) {
        return new GroupImpl(hdfBackingStorage, objectHeaderAddress, name, parent);
    }

    static Group createRootGroup(HdfBackingStorage hdfBackingStorage, long objectHeaderAddress, HdfFile file) {
        return new GroupImpl(hdfBackingStorage, objectHeaderAddress, file);
    }

    @Override
    public Map<String, Node> getChildren() {
        try {
            return (Map)this.children.get();
        }
        catch (Exception e) {
            throw new HdfException("Failed to load children for group '" + this.getPath() + "' at address '" + this.getAddress() + "'", e);
        }
    }

    public String toString() {
        return "Group [name=" + this.name + ", path=" + this.getPath() + ", address=" + Utils.toHex(this.getAddress()) + "]";
    }

    @Override
    public String getPath() {
        return super.getPath() + "/";
    }

    @Override
    public NodeType getType() {
        return NodeType.GROUP;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getChildren().values().iterator();
    }

    @Override
    public Node getChild(String name) {
        try {
            return (Node)((Map)this.children.get()).get(name);
        }
        catch (Exception e) {
            throw new HdfException("Failed to load children of group '" + this.getPath() + "' at address '" + this.getAddress() + "'", e);
        }
    }

    @Override
    public Node getByPath(String path) {
        String[] pathElements = path.split("/", 2);
        Node child = this.getChild(pathElements[0]);
        if (child instanceof Link) {
            child = ((Link)child).getTarget();
        }
        if (pathElements.length == 1 && child != null) {
            return child;
        }
        if (child instanceof Group) {
            return ((Group)child).getByPath(pathElements[1]);
        }
        throw new HdfInvalidPathException(this.getPath() + path, this.getFile());
    }

    @Override
    public Dataset getDatasetByPath(String path) {
        Node node = this.getByPath(path);
        if (node instanceof Link) {
            node = ((Link)node).getTarget();
        }
        if (node instanceof Dataset) {
            return (Dataset)node;
        }
        throw new HdfInvalidPathException(this.getPath() + path, this.getFile());
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        ObjectHeader oh = this.getHeader();
        if (oh.hasMessageOfType(LinkInfoMessage.class)) {
            return oh.getMessageOfType(LinkInfoMessage.class).isLinkCreationOrderTracked();
        }
        return false;
    }

    private final class ChildrenLazyInitializer
    extends LazyInitializer<Map<String, Node>> {
        private final HdfBackingStorage hdfBackingStorage;
        private final Group parent;

        private ChildrenLazyInitializer(HdfBackingStorage hdfBackingStorage, Group parent) {
            this.hdfBackingStorage = hdfBackingStorage;
            this.parent = parent;
        }

        protected Map<String, Node> initialize() throws ConcurrentException {
            logger.info("Lazy loading children of '{}'", (Object)GroupImpl.this.getPath());
            if (((ObjectHeader)GroupImpl.this.header.get()).hasMessageOfType(SymbolTableMessage.class)) {
                return this.createOldStyleGroup((ObjectHeader)GroupImpl.this.header.get());
            }
            return this.createNewStyleGroup((ObjectHeader)GroupImpl.this.header.get());
        }

        private Map<String, Node> createNewStyleGroup(ObjectHeader oh) {
            List<LinkMessage> links;
            logger.debug("Loading 'new' style group");
            LinkInfoMessage linkInfoMessage = oh.getMessageOfType(LinkInfoMessage.class);
            if (linkInfoMessage.getBTreeNameIndexAddress() == -1L) {
                links = oh.getMessagesOfType(LinkMessage.class);
                logger.debug("Loaded group links from object header");
            } else {
                BTreeV2 bTreeNode = new BTreeV2(this.hdfBackingStorage, linkInfoMessage.getBTreeNameIndexAddress());
                FractalHeap fractalHeap = new FractalHeap(this.hdfBackingStorage, linkInfoMessage.getFractalHeapAddress());
                List records = bTreeNode.getRecords();
                links = new ArrayList<LinkMessage>(records.size());
                for (LinkNameForIndexedGroupRecord linkName : records) {
                    ByteBuffer id = linkName.getId();
                    ByteBuffer bb = fractalHeap.getId(id);
                    links.add(LinkMessage.fromBuffer(bb, this.hdfBackingStorage.getSuperblock()));
                }
                logger.debug("Loaded group links from fractal heap");
            }
            LinkedHashMap<String, Node> lazyChildren = new LinkedHashMap<String, Node>(links.size());
            for (LinkMessage link : links) {
                String linkName = link.getLinkName();
                switch (link.getLinkType()) {
                    case HARD: {
                        long hardLinkAddress = link.getHardLinkAddress();
                        Node node = this.createNode(linkName, hardLinkAddress);
                        lazyChildren.put(linkName, node);
                        break;
                    }
                    case SOFT: {
                        lazyChildren.put(linkName, new SoftLink(link.getSoftLink(), linkName, this.parent));
                        break;
                    }
                    case EXTERNAL: {
                        lazyChildren.put(linkName, new ExternalLink(link.getExternalFile(), link.getExternalPath(), linkName, this.parent));
                    }
                }
            }
            return lazyChildren;
        }

        private Map<String, Node> createOldStyleGroup(ObjectHeader oh) {
            logger.debug("Loading 'old' style group");
            SymbolTableMessage stm = oh.getMessageOfType(SymbolTableMessage.class);
            BTreeV1Group rootBTreeNode = BTreeV1.createGroupBTree(this.hdfBackingStorage, stm.getBTreeAddress());
            LocalHeap rootNameHeap = new LocalHeap(this.hdfBackingStorage, stm.getLocalHeapAddress());
            ByteBuffer nameBuffer = rootNameHeap.getDataBuffer();
            List<Long> childAddresses = rootBTreeNode.getChildAddresses();
            LinkedHashMap<String, Node> lazyChildren = new LinkedHashMap<String, Node>(childAddresses.size());
            for (long child : childAddresses) {
                GroupSymbolTableNode groupSTE = new GroupSymbolTableNode(this.hdfBackingStorage, child);
                for (SymbolTableEntry ste : groupSTE.getSymbolTableEntries()) {
                    Node node;
                    String childName = this.readName(nameBuffer, ste.getLinkNameOffset());
                    switch (ste.getCacheType()) {
                        case 0: {
                            node = this.createNode(childName, ste.getObjectHeaderAddress());
                            break;
                        }
                        case 1: {
                            logger.trace("Creating group '{}'", (Object)childName);
                            node = GroupImpl.createGroup(this.hdfBackingStorage, ste.getObjectHeaderAddress(), childName, this.parent);
                            break;
                        }
                        case 2: {
                            logger.trace("Creating soft link '{}'", (Object)childName);
                            String target = this.readName(nameBuffer, ste.getLinkValueOffset());
                            node = new SoftLink(target, childName, this.parent);
                            break;
                        }
                        default: {
                            throw new HdfException("Unrecognized symbol table entry cache type. Type was: " + ste.getCacheType());
                        }
                    }
                    lazyChildren.put(childName, node);
                }
            }
            return lazyChildren;
        }

        private Node createNode(String name, long address) {
            Node node;
            ObjectHeader linkHeader = ObjectHeader.readObjectHeader(this.hdfBackingStorage, address);
            if (linkHeader.hasMessageOfType(DataSpaceMessage.class)) {
                logger.trace("Creating dataset [{}]", (Object)name);
                node = DatasetLoader.createDataset(this.hdfBackingStorage, linkHeader, name, this.parent);
            } else if (linkHeader.hasMessageOfType(DataTypeMessage.class)) {
                logger.trace("Creating committed data type [{}]", (Object)name);
                node = new CommittedDatatype(this.hdfBackingStorage, address, name, this.parent);
            } else {
                logger.trace("Creating group [{}]", (Object)name);
                node = GroupImpl.createGroup(this.hdfBackingStorage, address, name, this.parent);
            }
            return node;
        }

        private String readName(ByteBuffer bb, int linkNameOffset) {
            bb.position(linkNameOffset);
            return Utils.readUntilNull(bb);
        }
    }
}

