/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.api.Attribute;
import io.jhdf.api.Node;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeImpl
implements Attribute {
    private static final Logger logger = LoggerFactory.getLogger(AttributeImpl.class);
    private final HdfBackingStorage hdfBackingStorage;
    private final Node node;
    private final String name;
    private final AttributeMessage message;

    public AttributeImpl(HdfBackingStorage hdfBackingStorage, Node node, AttributeMessage message) {
        this.hdfBackingStorage = hdfBackingStorage;
        this.node = node;
        this.name = message.getName();
        this.message = message;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.message.getDataSpace().getTotalLength();
    }

    @Override
    public long getSizeInBytes() {
        return this.getSize() * (long)this.message.getDataType().getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.message.getDataSpace().getDimensions();
    }

    @Override
    public Object getData() {
        logger.debug("Getting data for attribute '{}' of '{}'...", (Object)this.name, (Object)this.node.getPath());
        if (this.isEmpty()) {
            return null;
        }
        DataType type = this.message.getDataType();
        ByteBuffer bb = this.message.getDataBuffer();
        return DatasetReader.readDataset(type, bb, this.getDimensions(), this.hdfBackingStorage);
    }

    @Override
    public boolean isEmpty() {
        return this.message.getDataBuffer() == null;
    }

    @Override
    public boolean isScalar() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getDimensions().length == 0;
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> type = this.message.getDataType().getJavaType();
        if (this.isScalar() && type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.message.getDataBuffer();
    }
}

