/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.AdminConsoleAppPermission;
import com.dropbox.core.v2.teamlog.AdminConsoleAppPolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class AppPermissionsChangedDetails {
    protected final String appName;
    protected final AdminConsoleAppPermission permission;
    protected final AdminConsoleAppPolicy previousValue;
    protected final AdminConsoleAppPolicy newValue;

    public AppPermissionsChangedDetails(AdminConsoleAppPolicy previousValue, AdminConsoleAppPolicy newValue, String appName, AdminConsoleAppPermission permission) {
        this.appName = appName;
        this.permission = permission;
        if (previousValue == null) {
            throw new IllegalArgumentException("Required value for 'previousValue' is null");
        }
        this.previousValue = previousValue;
        if (newValue == null) {
            throw new IllegalArgumentException("Required value for 'newValue' is null");
        }
        this.newValue = newValue;
    }

    public AppPermissionsChangedDetails(AdminConsoleAppPolicy previousValue, AdminConsoleAppPolicy newValue) {
        this(previousValue, newValue, null, null);
    }

    public AdminConsoleAppPolicy getPreviousValue() {
        return this.previousValue;
    }

    public AdminConsoleAppPolicy getNewValue() {
        return this.newValue;
    }

    public String getAppName() {
        return this.appName;
    }

    public AdminConsoleAppPermission getPermission() {
        return this.permission;
    }

    public static Builder newBuilder(AdminConsoleAppPolicy previousValue, AdminConsoleAppPolicy newValue) {
        return new Builder(previousValue, newValue);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.appName, this.permission, this.previousValue, this.newValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AppPermissionsChangedDetails other = (AppPermissionsChangedDetails)obj;
            return !(this.previousValue != other.previousValue && !this.previousValue.equals((Object)other.previousValue) || this.newValue != other.newValue && !this.newValue.equals((Object)other.newValue) || this.appName != other.appName && (this.appName == null || !this.appName.equals(other.appName)) || this.permission != other.permission && (this.permission == null || !this.permission.equals((Object)other.permission)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AppPermissionsChangedDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AppPermissionsChangedDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("previous_value");
            AdminConsoleAppPolicy.Serializer.INSTANCE.serialize(value.previousValue, g);
            g.writeFieldName("new_value");
            AdminConsoleAppPolicy.Serializer.INSTANCE.serialize(value.newValue, g);
            if (value.appName != null) {
                g.writeFieldName("app_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.appName, g);
            }
            if (value.permission != null) {
                g.writeFieldName("permission");
                StoneSerializers.nullable(AdminConsoleAppPermission.Serializer.INSTANCE).serialize(value.permission, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AppPermissionsChangedDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AdminConsoleAppPermission f_permission;
            String f_appName;
            AdminConsoleAppPolicy f_newValue;
            AdminConsoleAppPolicy f_previousValue;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_previousValue = null;
                f_newValue = null;
                f_appName = null;
                f_permission = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("previous_value".equals(field)) {
                        f_previousValue = AdminConsoleAppPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("new_value".equals(field)) {
                        f_newValue = AdminConsoleAppPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("app_name".equals(field)) {
                        f_appName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("permission".equals(field)) {
                        f_permission = StoneSerializers.nullable(AdminConsoleAppPermission.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_previousValue == null) {
                    throw new JsonParseException(p, "Required field \"previous_value\" missing.");
                }
                if (f_newValue == null) {
                    throw new JsonParseException(p, "Required field \"new_value\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AppPermissionsChangedDetails value = new AppPermissionsChangedDetails(f_previousValue, f_newValue, f_appName, f_permission);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final AdminConsoleAppPolicy previousValue;
        protected final AdminConsoleAppPolicy newValue;
        protected String appName;
        protected AdminConsoleAppPermission permission;

        protected Builder(AdminConsoleAppPolicy previousValue, AdminConsoleAppPolicy newValue) {
            if (previousValue == null) {
                throw new IllegalArgumentException("Required value for 'previousValue' is null");
            }
            this.previousValue = previousValue;
            if (newValue == null) {
                throw new IllegalArgumentException("Required value for 'newValue' is null");
            }
            this.newValue = newValue;
            this.appName = null;
            this.permission = null;
        }

        public Builder withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder withPermission(AdminConsoleAppPermission permission) {
            this.permission = permission;
            return this;
        }

        public AppPermissionsChangedDetails build() {
            return new AppPermissionsChangedDetails(this.previousValue, this.newValue, this.appName, this.permission);
        }
    }
}

