/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.FileCategory;
import com.dropbox.core.v2.files.FileStatus;
import com.dropbox.core.v2.files.SearchOrderBy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SearchOptions {
    protected final String path;
    protected final long maxResults;
    protected final SearchOrderBy orderBy;
    protected final FileStatus fileStatus;
    protected final boolean filenameOnly;
    protected final List<String> fileExtensions;
    protected final List<FileCategory> fileCategories;
    protected final String accountId;

    public SearchOptions(String path, long maxResults, SearchOrderBy orderBy, FileStatus fileStatus, boolean filenameOnly, List<String> fileExtensions, List<FileCategory> fileCategories, String accountId) {
        if (path != null && !Pattern.matches("(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (maxResults < 1L) {
            throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
        }
        if (maxResults > 1000L) {
            throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
        }
        this.maxResults = maxResults;
        this.orderBy = orderBy;
        if (fileStatus == null) {
            throw new IllegalArgumentException("Required value for 'fileStatus' is null");
        }
        this.fileStatus = fileStatus;
        this.filenameOnly = filenameOnly;
        if (fileExtensions != null) {
            for (String string : fileExtensions) {
                if (string != null) continue;
                throw new IllegalArgumentException("An item in list 'fileExtensions' is null");
            }
        }
        this.fileExtensions = fileExtensions;
        if (fileCategories != null) {
            for (FileCategory fileCategory : fileCategories) {
                if (fileCategory != null) continue;
                throw new IllegalArgumentException("An item in list 'fileCategories' is null");
            }
        }
        this.fileCategories = fileCategories;
        if (accountId != null) {
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
        }
        this.accountId = accountId;
    }

    public SearchOptions() {
        this(null, 100L, null, FileStatus.ACTIVE, false, null, null, null);
    }

    public String getPath() {
        return this.path;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public SearchOrderBy getOrderBy() {
        return this.orderBy;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public boolean getFilenameOnly() {
        return this.filenameOnly;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public List<FileCategory> getFileCategories() {
        return this.fileCategories;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.maxResults, this.orderBy, this.fileStatus, this.filenameOnly, this.fileExtensions, this.fileCategories, this.accountId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchOptions other = (SearchOptions)obj;
            return (this.path == other.path || this.path != null && this.path.equals(other.path)) && this.maxResults == other.maxResults && (this.orderBy == other.orderBy || this.orderBy != null && this.orderBy.equals((Object)other.orderBy)) && (this.fileStatus == other.fileStatus || this.fileStatus.equals((Object)other.fileStatus)) && this.filenameOnly == other.filenameOnly && (this.fileExtensions == other.fileExtensions || this.fileExtensions != null && this.fileExtensions.equals(other.fileExtensions)) && (this.fileCategories == other.fileCategories || this.fileCategories != null && this.fileCategories.equals(other.fileCategories)) && (this.accountId == other.accountId || this.accountId != null && this.accountId.equals(other.accountId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchOptions> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchOptions value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.path != null) {
                g.writeFieldName("path");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.path, g);
            }
            g.writeFieldName("max_results");
            StoneSerializers.uInt64().serialize((Long)value.maxResults, g);
            if (value.orderBy != null) {
                g.writeFieldName("order_by");
                StoneSerializers.nullable(SearchOrderBy.Serializer.INSTANCE).serialize(value.orderBy, g);
            }
            g.writeFieldName("file_status");
            FileStatus.Serializer.INSTANCE.serialize(value.fileStatus, g);
            g.writeFieldName("filename_only");
            StoneSerializers.boolean_().serialize((Boolean)value.filenameOnly, g);
            if (value.fileExtensions != null) {
                g.writeFieldName("file_extensions");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.fileExtensions, g);
            }
            if (value.fileCategories != null) {
                g.writeFieldName("file_categories");
                StoneSerializers.nullable(StoneSerializers.list(FileCategory.Serializer.INSTANCE)).serialize(value.fileCategories, g);
            }
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SearchOptions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_accountId;
            List<FileCategory> f_fileCategories;
            List<String> f_fileExtensions;
            Boolean f_filenameOnly;
            FileStatus f_fileStatus;
            SearchOrderBy f_orderBy;
            Long f_maxResults;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_maxResults = 100L;
                f_orderBy = null;
                f_fileStatus = FileStatus.ACTIVE;
                f_filenameOnly = false;
                f_fileExtensions = null;
                f_fileCategories = null;
                f_accountId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("max_results".equals(field)) {
                        f_maxResults = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("order_by".equals(field)) {
                        f_orderBy = StoneSerializers.nullable(SearchOrderBy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("file_status".equals(field)) {
                        f_fileStatus = FileStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("filename_only".equals(field)) {
                        f_filenameOnly = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("file_extensions".equals(field)) {
                        f_fileExtensions = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    if ("file_categories".equals(field)) {
                        f_fileCategories = StoneSerializers.nullable(StoneSerializers.list(FileCategory.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchOptions value = new SearchOptions(f_path, f_maxResults, f_orderBy, f_fileStatus, f_filenameOnly, f_fileExtensions, f_fileCategories, f_accountId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String path = null;
        protected long maxResults = 100L;
        protected SearchOrderBy orderBy = null;
        protected FileStatus fileStatus = FileStatus.ACTIVE;
        protected boolean filenameOnly = false;
        protected List<String> fileExtensions = null;
        protected List<FileCategory> fileCategories = null;
        protected String accountId = null;

        protected Builder() {
        }

        public Builder withPath(String path) {
            if (path != null && !Pattern.matches("(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            return this;
        }

        public Builder withMaxResults(Long maxResults) {
            if (maxResults < 1L) {
                throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
            }
            if (maxResults > 1000L) {
                throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
            }
            this.maxResults = maxResults != null ? maxResults : 100L;
            return this;
        }

        public Builder withOrderBy(SearchOrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder withFileStatus(FileStatus fileStatus) {
            this.fileStatus = fileStatus != null ? fileStatus : FileStatus.ACTIVE;
            return this;
        }

        public Builder withFilenameOnly(Boolean filenameOnly) {
            this.filenameOnly = filenameOnly != null ? filenameOnly : false;
            return this;
        }

        public Builder withFileExtensions(List<String> fileExtensions) {
            if (fileExtensions != null) {
                for (String x : fileExtensions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'fileExtensions' is null");
                }
            }
            this.fileExtensions = fileExtensions;
            return this;
        }

        public Builder withFileCategories(List<FileCategory> fileCategories) {
            if (fileCategories != null) {
                for (FileCategory x : fileCategories) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'fileCategories' is null");
                }
            }
            this.fileCategories = fileCategories;
            return this;
        }

        public Builder withAccountId(String accountId) {
            if (accountId != null) {
                if (accountId.length() < 40) {
                    throw new IllegalArgumentException("String 'accountId' is shorter than 40");
                }
                if (accountId.length() > 40) {
                    throw new IllegalArgumentException("String 'accountId' is longer than 40");
                }
            }
            this.accountId = accountId;
            return this;
        }

        public SearchOptions build() {
            return new SearchOptions(this.path, this.maxResults, this.orderBy, this.fileStatus, this.filenameOnly, this.fileExtensions, this.fileCategories, this.accountId);
        }
    }
}

