/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;

@Deprecated
public class MetaMigrationConvertingToPB {
    private static final Log LOG = LogFactory.getLog(MetaMigrationConvertingToPB.class);

    static void migrateSplitIfNecessary(Result r, Put p, byte[] which) throws IOException {
        byte[] hriSplitBytes = MetaMigrationConvertingToPB.getBytes(r, which);
        if (!MetaMigrationConvertingToPB.isMigrated(hriSplitBytes)) {
            HRegionInfo hri = MetaMigrationConvertingToPB.parseFrom(hriSplitBytes);
            p.addImmutable(HConstants.CATALOG_FAMILY, which, hri.toByteArray());
        }
    }

    static HRegionInfo parseFrom(byte[] hriBytes) throws IOException {
        try {
            return HRegionInfo.parseFrom((byte[])hriBytes);
        }
        catch (DeserializationException ex) {
            throw new IOException(ex);
        }
    }

    static byte[] getBytes(Result r, byte[] qualifier) {
        byte[] hriBytes = r.getValue(HConstants.CATALOG_FAMILY, qualifier);
        if (hriBytes == null || hriBytes.length <= 0) {
            return null;
        }
        return hriBytes;
    }

    static boolean isMigrated(byte[] hriBytes) {
        if (hriBytes == null || hriBytes.length <= 0) {
            return true;
        }
        return ProtobufUtil.isPBMagicPrefix((byte[])hriBytes);
    }

    public static long updateMetaIfNecessary(MasterServices services) throws IOException {
        if (MetaMigrationConvertingToPB.isMetaTableUpdated((HConnection)services.getConnection())) {
            LOG.info((Object)"META already up-to date with PB serialization");
            return 0L;
        }
        LOG.info((Object)"META has Writable serializations, migrating hbase:meta to PB serialization");
        try {
            long rows = MetaMigrationConvertingToPB.updateMeta(services);
            LOG.info((Object)("META updated with PB serialization. Total rows updated: " + rows));
            return rows;
        }
        catch (IOException e) {
            LOG.warn((Object)"Update hbase:meta with PB serialization failed.Master startup aborted.");
            throw e;
        }
    }

    static long updateMeta(MasterServices masterServices) throws IOException {
        LOG.info((Object)"Starting update of META");
        ConvertToPBMetaVisitor v = new ConvertToPBMetaVisitor(masterServices);
        MetaTableAccessor.fullScan((Connection)masterServices.getConnection(), (MetaTableAccessor.Visitor)v);
        LOG.info((Object)("Finished update of META. Total rows updated:" + v.numMigratedRows));
        return v.numMigratedRows;
    }

    static boolean isMetaTableUpdated(HConnection hConnection) throws IOException {
        List results = MetaTableAccessor.fullScanOfMeta((Connection)hConnection);
        if (results == null || results.isEmpty()) {
            LOG.info((Object)"hbase:meta doesn't have any entries to update.");
            return true;
        }
        for (Result r : results) {
            byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            if (MetaMigrationConvertingToPB.isMigrated(value)) continue;
            return false;
        }
        return true;
    }

    private static class ConvertToPBMetaVisitor
    implements MetaTableAccessor.Visitor {
        private final MasterServices services;
        private long numMigratedRows;

        public ConvertToPBMetaVisitor(MasterServices services) {
            this.services = services;
            this.numMigratedRows = 0L;
        }

        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            byte[] hriBytes = MetaMigrationConvertingToPB.getBytes(r, HConstants.REGIONINFO_QUALIFIER);
            if (MetaMigrationConvertingToPB.isMigrated(hriBytes)) {
                return true;
            }
            HRegionInfo hri = MetaMigrationConvertingToPB.parseFrom(hriBytes);
            Put p = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)hri);
            MetaMigrationConvertingToPB.migrateSplitIfNecessary(r, p, HConstants.SPLITA_QUALIFIER);
            MetaMigrationConvertingToPB.migrateSplitIfNecessary(r, p, HConstants.SPLITB_QUALIFIER);
            MetaTableAccessor.putToMetaTable((Connection)this.services.getConnection(), (Put)p);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Migrated " + Bytes.toString((byte[])p.getRow())));
            }
            ++this.numMigratedRows;
            return true;
        }
    }
}

