/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.PluginRulesProvider;
import org.apache.drill.exec.store.PluginRulesProviderImpl;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginRulesSupplier;
import org.apache.drill.exec.store.drill.plugin.DrillGroupScan;
import org.apache.drill.exec.store.drill.plugin.DrillScanSpec;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePluginConfig;
import org.apache.drill.exec.store.drill.plugin.plan.DrillPluginImplementor;
import org.apache.drill.exec.store.drill.plugin.schema.DrillSchemaFactory;
import org.apache.drill.exec.store.plan.rel.PluginRel;

public class DrillStoragePlugin
extends AbstractStoragePlugin {
    private final DrillStoragePluginConfig drillConfig;
    private final DrillSchemaFactory schemaFactory;
    private final StoragePluginRulesSupplier storagePluginRulesSupplier;
    private final Map<String, DrillClient> userClients;

    public DrillStoragePlugin(DrillStoragePluginConfig drillConfig, DrillbitContext context, String name) {
        super(context, name);
        this.drillConfig = drillConfig;
        this.schemaFactory = new DrillSchemaFactory(this, name);
        this.storagePluginRulesSupplier = DrillStoragePlugin.storagePluginRulesSupplier(name);
        assert (drillConfig.getConnection().startsWith("jdbc:drill:"));
        this.userClients = new ConcurrentHashMap<String, DrillClient>();
    }

    private static StoragePluginRulesSupplier storagePluginRulesSupplier(String name) {
        Convention.Impl convention = new Convention.Impl("DRILL." + name, PluginRel.class);
        return StoragePluginRulesSupplier.builder().rulesProvider((PluginRulesProvider)new PluginRulesProviderImpl((Convention)convention, DrillPluginImplementor::new)).supportsProjectPushdown(true).supportsSortPushdown(true).supportsAggregatePushdown(true).supportsFilterPushdown(true).supportsLimitPushdown(true).supportsUnionPushdown(true).supportsJoinPushdown(true).convention((Convention)convention).build();
    }

    public DrillStoragePluginConfig getConfig() {
        return this.drillConfig;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public boolean supportsRead() {
        return true;
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        DrillScanSpec scanSpec = (DrillScanSpec)selection.getListWith((TypeReference)new TypeReference<DrillScanSpec>(){});
        return new DrillGroupScan(userName, this.drillConfig, scanSpec);
    }

    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: 
            case LOGICAL: {
                return this.storagePluginRulesSupplier.getOptimizerRules();
            }
        }
        return Collections.emptySet();
    }

    public Convention convention() {
        return this.storagePluginRulesSupplier.convention();
    }

    public DrillClient getClient(String userName) {
        this.userClients.computeIfAbsent(userName, this::createClient);
        return this.userClients.computeIfPresent(userName, (name, value) -> {
            if (!value.connectionIsActive()) {
                AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{value});
                return this.createClient((String)name);
            }
            return value;
        });
    }

    private DrillClient createClient(String userName) {
        return this.drillConfig.getDrillClient(userName, null);
    }

    public void close() {
        AutoCloseables.closeSilently((AutoCloseable[])this.userClients.values().toArray(new AutoCloseable[0]));
    }
}

