/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import com.google.common.base.Stopwatch;
import java.sql.SQLTimeoutException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.rpc.user.BlockingResultsListener;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.store.drill.plugin.DrillSubScan;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRecordReader
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(DrillRecordReader.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(DrillRecordReader.class);
    private final DrillClient drillClient;
    private final RecordBatchLoader batchLoader;
    private final FragmentContext context;
    private final BlockingResultsListener resultsListener;
    private final UserBitShared.QueryId id;
    private BatchSchema schema;
    private boolean first = true;
    private final OperatorContext oContext;

    public DrillRecordReader(ExecutorFragmentContext context, DrillSubScan config) throws OutOfMemoryException, ExecutionSetupException {
        this.context = context;
        this.oContext = context.newOperatorContext((PhysicalOperator)config);
        this.batchLoader = new RecordBatchLoader(this.oContext.getAllocator());
        String userName = Optional.ofNullable(config.getUserName()).orElse(ImpersonationUtil.getProcessUserName());
        this.drillClient = config.getPluginConfig().getDrillClient(userName, this.oContext.getAllocator());
        long queryTimeout = this.drillClient.getConfig().getLong("drill.jdbc.query_timeout");
        int batchQueueThrottlingThreshold = this.drillClient.getConfig().getInt("drill.jdbc.batch_queue_throttling_threshold");
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.resultsListener = new BlockingResultsListener(() -> stopwatch, () -> queryTimeout, batchQueueThrottlingThreshold);
        this.drillClient.runQuery(UserBitShared.QueryType.SQL, config.getQuery(), (UserResultsListener)this.resultsListener);
        this.id = this.resultsListener.getQueryId();
        try {
            this.resultsListener.awaitFirstMessage();
        }
        catch (InterruptedException | SQLTimeoutException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public FragmentContext getContext() {
        return this.context;
    }

    public BatchSchema getSchema() {
        return this.schema;
    }

    public int getRecordCount() {
        return this.batchLoader.getRecordCount();
    }

    public void cancel() {
        this.drillClient.cancelQuery(this.id);
    }

    public Iterator<VectorWrapper<?>> iterator() {
        return this.batchLoader.iterator();
    }

    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.batchLoader.getValueVectorId(path);
    }

    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.batchLoader.getValueAccessorById(clazz, ids);
    }

    private QueryDataBatch getNextBatch() {
        try {
            injector.injectChecked(this.context.getExecutionControls(), "next-allocate", OutOfMemoryException.class);
            return this.resultsListener.getNext();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            throw UserException.dataReadError((Throwable)e).addContext("Failure when reading incoming batch").build(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordBatch.IterOutcome next() {
        this.batchLoader.resetRecordCount();
        this.oContext.getStats().startProcessing();
        try {
            QueryDataBatch batch;
            try {
                this.oContext.getStats().startWait();
                batch = this.getNextBatch();
                while (!(batch == null || batch.getHeader().getDef().getRecordCount() != 0 || this.first && batch.getHeader().getDef().getFieldCount() != 0)) {
                    batch = this.getNextBatch();
                }
            }
            finally {
                this.oContext.getStats().stopWait();
            }
            this.first = false;
            if (batch == null) {
                RecordBatch.IterOutcome lastOutcome = RecordBatch.IterOutcome.NONE;
                this.batchLoader.zero();
                this.context.getExecutorState().checkContinue();
                RecordBatch.IterOutcome iterOutcome = lastOutcome;
                return iterOutcome;
            }
            if (this.context.getAllocator().isOverLimit()) {
                this.context.requestMemory((RecordBatch)this);
                if (this.context.getAllocator().isOverLimit()) {
                    throw new OutOfMemoryException("Allocator over limit");
                }
            }
            UserBitShared.RecordBatchDef rbd = batch.getHeader().getDef();
            boolean schemaChanged = this.batchLoader.load(rbd, batch.getData());
            batch.release();
            if (schemaChanged) {
                this.schema = this.batchLoader.getSchema();
                this.oContext.getStats().batchReceived(0, (long)rbd.getRecordCount(), true);
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                return iterOutcome;
            }
            this.oContext.getStats().batchReceived(0, (long)rbd.getRecordCount(), false);
            RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK;
            return iterOutcome;
        }
        finally {
            this.oContext.getStats().stopProcessing();
        }
    }

    public WritableBatch getWritableBatch() {
        return this.batchLoader.getWritableBatch();
    }

    public void close() {
        logger.debug("Closing {}", (Object)this.getClass().getCanonicalName());
        this.batchLoader.clear();
        this.resultsListener.close();
        this.drillClient.close();
    }

    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format("You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    public VectorContainer getContainer() {
        return this.batchLoader.getContainer();
    }

    public void dump() {
        logger.error("DrillRecordReader[batchLoader={}, schema={}]", (Object)this.batchLoader, (Object)this.schema);
    }
}

