/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlDialect;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.sql.conversion.SqlConverter;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.drill.plugin.DrillScanSpec;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePluginConfig;
import org.apache.drill.exec.store.drill.plugin.DrillSubScan;

public class DrillGroupScan
extends AbstractGroupScan {
    private static final double ROWS = 1000000.0;
    private final DrillStoragePluginConfig pluginConfig;
    private final DrillScanSpec scanSpec;

    @JsonCreator
    public DrillGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="pluginConfig") DrillStoragePluginConfig pluginConfig, @JsonProperty(value="scanSpec") DrillScanSpec scanSpec) {
        super(userName);
        this.pluginConfig = pluginConfig;
        this.scanSpec = scanSpec;
    }

    public DrillGroupScan(DrillGroupScan that) {
        super((AbstractGroupScan)that);
        this.pluginConfig = that.pluginConfig;
        this.scanSpec = that.scanSpec;
    }

    @JsonProperty(value="pluginConfig")
    public DrillStoragePluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @JsonProperty(value="scanSpec")
    public DrillScanSpec getScanSpec() {
        return this.scanSpec;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
    }

    public SubScan getSpecificScan(int minorFragmentId) {
        return new DrillSubScan(this.userName, this.pluginConfig, this.scanSpec.getQuery());
    }

    @JsonIgnore
    public SqlDialect getDialect() {
        return new SqlDialect(SqlDialect.EMPTY_CONTEXT.withIdentifierQuoteString(this.pluginConfig.getIdentifierQuoteString()).withConformance(SqlConverter.DRILL_CONFORMANCE).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED));
    }

    public int getMaxParallelizationWidth() {
        return 1;
    }

    public String getDigest() {
        return this.toString();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        return new DrillGroupScan(this);
    }

    public GroupScan clone(List<SchemaPath> columns) {
        return new DrillGroupScan(this);
    }

    public ScanStats getScanStats() {
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)((long)Math.max(1000000.0, 1.0)), 1.0, 1.0);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("scanSpec", (Object)this.scanSpec).toString();
    }

    @JsonIgnore
    public List<SchemaPath> getColumns() {
        return super.getColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DrillGroupScan that = (DrillGroupScan)((Object)o);
        return new EqualsBuilder().append((Object)this.getPluginConfig(), (Object)that.getPluginConfig()).append((Object)this.getScanSpec(), (Object)that.getScanSpec()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getPluginConfig()).append((Object)this.getScanSpec()).toHashCode();
    }
}

