/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Iterator;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowwiseRowResultIterator;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class RowResultIterator
extends KuduRpcResponse
implements Iterator<RowResult>,
Iterable<RowResult> {
    protected final Schema schema;
    protected final int numRows;
    protected int currentRow = 0;

    protected RowResultIterator(long elapsedMillis, String tsUUID, Schema schema, int numRows, boolean reuseRowResult) {
        super(elapsedMillis, tsUUID);
        this.schema = schema;
        this.numRows = numRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public static RowResultIterator empty() {
        return RowwiseRowResultIterator.empty();
    }

    @Override
    public boolean hasNext() {
        return this.currentRow < this.numRows;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<RowResult> iterator() {
        return this;
    }
}

