/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra.schema;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.cassandra.CalciteUtils;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.StoragePlugin;

public class CassandraDynamicTable
extends DrillTable
implements TranslatableTable,
QueryableTable,
Wrapper {
    private final CassandraTable table;

    public CassandraDynamicTable(StoragePlugin plugin, String storageEngineName, DrillTableSelection selection, CassandraTable table) {
        super(storageEngineName, plugin, selection);
        this.table = table;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return CalciteUtils.tableScanCreator(cluster, cluster.traitSetOf((RelTrait)CassandraRel.CONVENTION), relOptTable, this.table, relOptTable.getRowType());
    }

    public <V> Queryable<V> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        final CassandraTable cassandraTable = this.table;
        return new CassandraTable.CassandraQueryable<V>(queryProvider, schema, cassandraTable, tableName){

            public Enumerable<Object> query(List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<String> predicates, List<String> order, Integer offset, Integer fetch) {
                return cassandraTable.query(CalciteUtils.getSession(this.schema), fields, selectFields, predicates, order, offset, fetch);
            }
        };
    }

    public Type getElementType() {
        return this.table.getElementType();
    }

    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance((Object)this)) {
            return aClass.cast((Object)this);
        }
        if (aClass.isInstance(this.table)) {
            return aClass.cast(this.table);
        }
        return null;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return this.table.getExpression(schema, tableName, clazz);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.table.getRowType(typeFactory);
    }
}

