/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra.plan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.cassandra.CassandraToEnumerableConverterRule;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.cassandra.CassandraColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.ColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.plan.EnumerablePrelContext;

public class CassandraEnumerablePrelContext
implements EnumerablePrelContext {
    private final String planPrefix;

    public CassandraEnumerablePrelContext(String planPrefix) {
        this.planPrefix = planPrefix;
    }

    public String generateCode(RelOptCluster cluster, RelNode relNode) {
        RelNode enumerableRel = CassandraToEnumerableConverterRule.DEFAULT_CONFIG.toRule(ConverterRule.class).convert(relNode);
        ClassDeclaration classDeclaration = new EnumerableRelImplementor(cluster.getRexBuilder(), Collections.emptyMap()).implementRoot((EnumerableRel)enumerableRel, EnumerableRel.Prefer.ARRAY);
        return Expressions.toString(Collections.singletonList(classDeclaration), (String)"\n", (boolean)false);
    }

    public RelNode transformNode(RelNode input) {
        return input.accept(SubsetRemover.INSTANCE);
    }

    public Map<String, Integer> getFieldsMap(RelNode transformedNode) {
        return transformedNode.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, RelDataTypeField::getIndex));
    }

    public String getPlanPrefix() {
        return this.planPrefix;
    }

    public String getTablePath(RelNode input) {
        TableScan scan = Objects.requireNonNull(DrillRelOptUtil.findScan((RelNode[])new RelNode[]{input}));
        List qualifiedName = scan.getTable().getQualifiedName();
        return String.join((CharSequence)".", qualifiedName.subList(0, qualifiedName.size() - 1));
    }

    public ColumnConverterFactoryProvider factoryProvider() {
        return CassandraColumnConverterFactoryProvider.INSTANCE;
    }
}

