/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

@JsonTypeName(value="cassandra")
public class CassandraStorageConfig
extends StoragePluginConfig {
    public static final String NAME = "cassandra";
    private final String host;
    private final int port;

    @JsonCreator
    public CassandraStorageConfig(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="authMode") String authMode, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null, StoragePluginConfig.AuthMode.parseOrDefault((String)authMode, (StoragePluginConfig.AuthMode)StoragePluginConfig.AuthMode.SHARED_USER));
        this.host = host;
        this.port = port;
    }

    private CassandraStorageConfig(CassandraStorageConfig that, CredentialsProvider credentialsProvider) {
        super(CassandraStorageConfig.getCredentialsProvider(credentialsProvider), credentialsProvider == null, that.authMode);
        this.host = that.host;
        this.port = that.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @JsonIgnore
    public Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).build();
    }

    public String getUsername() {
        return this.getUsernamePasswordCredentials().map(UsernamePasswordCredentials::getUsername).orElse(null);
    }

    public String getPassword() {
        return this.getUsernamePasswordCredentials().map(UsernamePasswordCredentials::getPassword).orElse(null);
    }

    @JsonIgnore
    public Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials(String username) {
        return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).setQueryUser(username).build();
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap(String username) {
        Optional<UsernamePasswordCredentials> credentials = this.getUsernamePasswordCredentials(username);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("host", this.host);
        result.put("port", this.port);
        if (credentials.isPresent()) {
            result.put("username", credentials.get().getUsername());
            result.put("password", credentials.get().getPassword());
        }
        return result;
    }

    public CassandraStorageConfig updateCredentialProvider(CredentialsProvider credentialsProvider) {
        return new CassandraStorageConfig(this, credentialsProvider);
    }

    private static CredentialsProvider getCredentialsProvider(CredentialsProvider credentialsProvider) {
        return credentialsProvider != null ? credentialsProvider : PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER;
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap() {
        Optional<UsernamePasswordCredentials> credentials = this.getUsernamePasswordCredentials();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("host", this.host);
        result.put("port", this.port);
        if (credentials.isPresent()) {
            result.put("username", credentials.get().getUsername());
            result.put("password", credentials.get().getPassword());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CassandraStorageConfig that = (CassandraStorageConfig)((Object)o);
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.credentialsProvider);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("host", this.host).field("port", this.port).field("credentialsProvider", (Object)this.credentialsProvider).toString();
    }
}

