/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.complex;

import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class HiveUnionWriter
implements HiveValueWriter {
    private final HiveValueWriter[] unionFieldWriters;
    private final UnionObjectInspector unionObjectInspector;

    public HiveUnionWriter(HiveValueWriter[] unionFieldWriters, UnionObjectInspector unionObjectInspector) {
        this.unionFieldWriters = unionFieldWriters;
        this.unionObjectInspector = unionObjectInspector;
    }

    @Override
    public void write(Object value) {
        byte tag = this.unionObjectInspector.getTag(value);
        Object field = this.unionObjectInspector.getField(value);
        if (field == null) {
            throw new UnsupportedOperationException("Null value is not supported in Hive union.");
        }
        this.unionFieldWriters[tag].write(field);
    }
}

