/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.io.IOException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClientWithAuthorization;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public final class DrillHiveMetaStoreClientFactory {
    private DrillHiveMetaStoreClientFactory() {
    }

    public static DrillHiveMetaStoreClient createClientWithAuthz(DrillHiveMetaStoreClient processUserMetaStoreClient, HiveConf hiveConf, String userName) {
        try {
            HiveConf hiveConfForClient;
            UserGroupInformation ugiForRpc;
            boolean delegationTokenGenerated = false;
            if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
                ugiForRpc = ImpersonationUtil.getProcessUserUGI();
            } else {
                ugiForRpc = ImpersonationUtil.createProxyUgi((String)userName);
                if (hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)) {
                    String delegationToken = processUserMetaStoreClient.getDelegationToken(userName, userName);
                    try {
                        DrillHiveMetaStoreClientFactory.setTokenStr(ugiForRpc, delegationToken, "DrillDelegationTokenForHiveMetaStoreServer");
                    }
                    catch (IOException e) {
                        throw new DrillRuntimeException("Couldn't setup delegation token in the UGI for Hive MetaStoreClient", (Throwable)e);
                    }
                    delegationTokenGenerated = true;
                }
            }
            if (delegationTokenGenerated) {
                hiveConfForClient = new HiveConf(hiveConf);
                hiveConfForClient.set("hive.metastore.token.signature", "DrillDelegationTokenForHiveMetaStoreServer");
            } else {
                hiveConfForClient = hiveConf;
            }
            return (DrillHiveMetaStoreClient)((Object)ugiForRpc.doAs(() -> new DrillHiveMetaStoreClientWithAuthorization(hiveConfForClient, ugiForRpc, userName)));
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure setting up HiveMetaStore client.", (Throwable)e);
        }
    }

    public static void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        Token<?> delegationToken = DrillHiveMetaStoreClientFactory.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    private static Token<?> createToken(String tokenStr, String tokenService) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }

    public static DrillHiveMetaStoreClient createCloseableClientWithCaching(HiveConf hiveConf) throws MetaException {
        return new DrillHiveMetaStoreClient(hiveConf);
    }
}

