/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HivePartitionHolder;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class HiveParquetTableMetadataProvider
extends BaseParquetMetadataProvider {
    private final HiveStoragePlugin hiveStoragePlugin;
    private final HivePartitionHolder hivePartitionHolder;

    private HiveParquetTableMetadataProvider(Builder builder) throws IOException {
        super((BaseParquetMetadataProvider.Builder)builder);
        this.hiveStoragePlugin = builder.hiveStoragePlugin;
        HivePartitionHolder hivePartitionHolder = this.hivePartitionHolder = builder.hivePartitionHolder != null ? builder.hivePartitionHolder : new HivePartitionHolder();
        if (builder.logicalInputSplits != null) {
            for (HiveMetadataProvider.LogicalInputSplit logicalInputSplit : builder.logicalInputSplits) {
                Iterator<InputSplit> iterator = logicalInputSplit.getInputSplits().iterator();
                assert (iterator.hasNext());
                InputSplit split = iterator.next();
                assert (split instanceof FileSplit);
                FileSplit fileSplit = (FileSplit)split;
                Path finalPath = fileSplit.getPath();
                Path pathString = Path.getPathWithoutSchemeAndAuthority((Path)finalPath);
                this.entries.add(new ReadEntryWithPath(pathString));
                Partition partition = logicalInputSplit.getPartition();
                if (partition == null) continue;
                this.hivePartitionHolder.add(pathString, partition.getValues());
            }
        }
        this.init((BaseParquetMetadataProvider)builder.metadataProviderManager().getTableMetadataProvider());
    }

    public HivePartitionHolder getHivePartitionHolder() {
        return this.hivePartitionHolder;
    }

    protected void initInternal() throws IOException {
        LinkedHashMap<FileStatus, FileSystem> fileStatusConfMap = new LinkedHashMap<FileStatus, FileSystem>();
        for (ReadEntryWithPath entry : this.entries) {
            Path path = entry.getPath();
            JobConf conf = new ProjectionPusher().pushProjectionsAndFilters(new JobConf((Configuration)this.hiveStoragePlugin.getHiveConf()), path.getParent());
            FileSystem fs = path.getFileSystem((Configuration)conf);
            fileStatusConfMap.put(fs.getFileStatus(Path.getPathWithoutSchemeAndAuthority((Path)path)), fs);
        }
        this.parquetTableMetadata = Metadata.getParquetTableMetadata(fileStatusConfMap, (ParquetReaderConfig)this.readerConfig);
    }

    public static class Builder
    extends BaseParquetMetadataProvider.Builder<Builder> {
        private HiveStoragePlugin hiveStoragePlugin;
        private HivePartitionHolder hivePartitionHolder;
        private List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits;

        public Builder(MetadataProviderManager source) {
            super(source);
        }

        protected Builder withHiveStoragePlugin(HiveStoragePlugin hiveStoragePlugin) {
            this.hiveStoragePlugin = hiveStoragePlugin;
            return this.self();
        }

        protected Builder withHivePartitionHolder(HivePartitionHolder hivePartitionHolder) {
            this.hivePartitionHolder = hivePartitionHolder;
            return this.self();
        }

        protected Builder withLogicalInputSplits(List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits) {
            this.logicalInputSplits = logicalInputSplits;
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        public HiveParquetTableMetadataProvider build() throws IOException {
            return new HiveParquetTableMetadataProvider(this);
        }
    }
}

