/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.logical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.planner.index.MapRDBStatistics;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.types.HiveToRelDataTypeConverter;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.mapr.db.MapRDBFormatPlugin;
import org.apache.drill.exec.store.mapr.db.MapRDBFormatPluginConfig;
import org.apache.drill.exec.store.mapr.db.json.JsonScanSpec;
import org.apache.drill.exec.store.mapr.db.json.JsonTableGroupScan;
import org.apache.hadoop.hive.maprdb.json.input.HiveMapRDBJsonInputFormat;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan.class);
    public static final ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan INSTANCE = new ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan();
    private static final String MAPRDB_PFX = "maprdb.";
    private static final String MAPRDB_TABLE_NAME = "maprdb.table.name";
    private static final String ID_KEY = "_id";
    private static final String MAPRDB_COLUMN_ID = "maprdb.column.id";

    private ConvertHiveMapRDBJsonScanToDrillMapRDBJsonScan() {
        super(RelOptHelper.any(DrillScanRel.class), "ConvertHiveScanToHiveDrillNativeScan:MapR-DB");
    }

    public boolean matches(RelOptRuleCall call) {
        return HiveUtilities.nativeReadersRuleMatches(call, HiveMapRDBJsonInputFormat.class);
    }

    public void onMatch(RelOptRuleCall call) {
        try {
            DrillScanRel hiveScanRel = (DrillScanRel)call.rel(0);
            PlannerSettings settings = PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner());
            HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
            HiveReadEntry hiveReadEntry = hiveScan.getHiveReadEntry();
            HiveMetadataProvider hiveMetadataProvider = new HiveMetadataProvider(hiveScan.getUserName(), hiveReadEntry, hiveScan.getHiveConf());
            if (hiveMetadataProvider.getInputSplits(hiveReadEntry).isEmpty()) {
                return;
            }
            if (hiveScan.getHiveReadEntry().getTable().isSetPartitionKeys()) {
                logger.warn("Hive MapR-DB JSON Handler doesn't support table partitioning. Consider recreating table without partitions");
            }
            DrillScanRel nativeScanRel = this.createNativeScanRel(hiveScanRel, settings);
            call.transformTo((RelNode)nativeScanRel);
            call.getPlanner().prune((RelNode)hiveScanRel);
        }
        catch (Exception e) {
            logger.warn("Failed to convert HiveScan to JsonScanSpec. Fallback to HiveMapR-DB connector.", (Throwable)e);
        }
    }

    private DrillScanRel createNativeScanRel(DrillScanRel hiveScanRel, PlannerSettings settings) throws IOException {
        RelDataTypeFactory typeFactory = hiveScanRel.getCluster().getTypeFactory();
        HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
        HiveReadEntry hiveReadEntry = hiveScan.getHiveReadEntry();
        Map<String, String> parameters = hiveReadEntry.getHiveTableWrapper().getParameters();
        JsonScanSpec scanSpec = new JsonScanSpec(parameters.get(MAPRDB_TABLE_NAME), null, null);
        List hiveScanCols = hiveScanRel.getColumns().stream().map(colNameSchemaPath -> this.replaceOverriddenSchemaPath(parameters, (SchemaPath)colNameSchemaPath)).collect(Collectors.toList());
        HiveToRelDataTypeConverter dataTypeConverter = new HiveToRelDataTypeConverter(typeFactory);
        TupleSchema schema = new TupleSchema();
        hiveReadEntry.getTable().getColumnListsCache().getTableSchemaColumns().forEach(arg_0 -> this.lambda$createNativeScanRel$1((TupleMetadata)schema, parameters, dataTypeConverter, arg_0));
        MapRDBFormatPluginConfig formatConfig = new MapRDBFormatPluginConfig();
        formatConfig.readTimestampWithZoneOffset = settings.getOptions().getBoolean("store.hive.maprdb_json.read_timestamp_with_timezone_offset");
        formatConfig.allTextMode = settings.getOptions().getBoolean("store.hive.maprdb_json.all_text_mode");
        JsonTableGroupScan nativeMapRDBScan = new JsonTableGroupScan(hiveScan.getUserName(), (AbstractStoragePlugin)hiveScan.getStoragePlugin(), (MapRDBFormatPlugin)hiveScan.getStoragePlugin().getFormatPlugin((FormatPluginConfig)formatConfig), scanSpec, hiveScanCols, new MapRDBStatistics(), FileSystemMetadataProviderManager.getMetadataProviderForSchema((TupleMetadata)schema));
        List nativeScanColNames = hiveScanRel.getRowType().getFieldList().stream().map(field -> this.replaceOverriddenColumnId(parameters, field.getName())).collect(Collectors.toList());
        List nativeScanColTypes = hiveScanRel.getRowType().getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList());
        RelDataType nativeScanRowType = typeFactory.createStructType(nativeScanColTypes, nativeScanColNames);
        return new DrillScanRel(hiveScanRel.getCluster(), hiveScanRel.getTraitSet(), hiveScanRel.getTable(), (GroupScan)nativeMapRDBScan, nativeScanRowType, hiveScanCols);
    }

    private String replaceOverriddenColumnId(Map<String, String> parameters, String colName) {
        return colName != null && colName.equals(parameters.get(MAPRDB_COLUMN_ID)) ? ID_KEY : colName;
    }

    private SchemaPath replaceOverriddenSchemaPath(Map<String, String> parameters, SchemaPath colNameSchemaPath) {
        String hiveColumnName = colNameSchemaPath.getRootSegmentPath();
        return hiveColumnName != null && hiveColumnName.equals(parameters.get(MAPRDB_COLUMN_ID)) ? SchemaPath.getSimplePath((String)ID_KEY) : colNameSchemaPath;
    }

    private /* synthetic */ void lambda$createNativeScanRel$1(TupleMetadata schema, Map parameters, HiveToRelDataTypeConverter dataTypeConverter, FieldSchema column) {
        schema.addColumn(SchemaUtils.getColumnMetadata((String)this.replaceOverriddenColumnId(parameters, column.getName()), (RelDataType)dataTypeConverter.convertToNullableRelDataType(column)));
    }
}

