/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;

public class IfExpression
extends LogicalExpressionBase {
    public final IfCondition ifCondition;
    public final LogicalExpression elseExpression;
    public final TypeProtos.MajorType outputType;

    private IfExpression(ExpressionPosition pos, IfCondition conditions, LogicalExpression elseExpression, TypeProtos.MajorType outputType) {
        super(pos);
        this.ifCondition = conditions;
        this.elseExpression = elseExpression;
        this.outputType = outputType;
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitIfExpression(this, value);
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        if (this.outputType != null) {
            return this.outputType;
        }
        TypeProtos.MajorType elseType = this.elseExpression.getMajorType();
        TypeProtos.MajorType ifType = this.ifCondition.expression.getMajorType();
        if (elseType.getMinorType() == TypeProtos.MinorType.UNION) {
            HashSet subtypes = Sets.newHashSet();
            for (TypeProtos.MinorType subtype : elseType.getSubTypeList()) {
                subtypes.add(subtype);
            }
            for (TypeProtos.MinorType subtype : ifType.getSubTypeList()) {
                subtypes.add(subtype);
            }
            TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.UNION).setMode(TypeProtos.DataMode.OPTIONAL);
            for (TypeProtos.MinorType subtype : subtypes) {
                builder.addSubType(subtype);
            }
            return builder.build();
        }
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(ifType.getMinorType());
        builder.setMode(elseType.getMode() == TypeProtos.DataMode.OPTIONAL || ifType.getMode() == TypeProtos.DataMode.OPTIONAL ? TypeProtos.DataMode.OPTIONAL : elseType.getMode());
        builder = Types.calculateTypePrecisionAndScale((TypeProtos.MajorType)ifType, (TypeProtos.MajorType)elseType, (TypeProtos.MajorType.Builder)builder);
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        LinkedList children = Lists.newLinkedList();
        children.add(this.ifCondition.condition);
        children.add(this.ifCondition.expression);
        children.add(this.elseExpression);
        return children.iterator();
    }

    @Override
    public int getCumulativeCost() {
        int cost = this.getSelfCost();
        int i = 0;
        for (LogicalExpression e : this) {
            cost += e.getCumulativeCost();
            ++i;
        }
        return cost / i;
    }

    public static class Builder {
        IfCondition conditions;
        private LogicalExpression elseExpression;
        private ExpressionPosition pos = ExpressionPosition.UNKNOWN;
        private TypeProtos.MajorType outputType;

        public Builder setPosition(ExpressionPosition pos) {
            this.pos = pos;
            return this;
        }

        public Builder setElse(LogicalExpression elseExpression) {
            this.elseExpression = elseExpression;
            return this;
        }

        public Builder setIfCondition(IfCondition conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder setOutputType(TypeProtos.MajorType outputType) {
            this.outputType = outputType;
            return this;
        }

        public IfExpression build() {
            Preconditions.checkNotNull((Object)this.pos);
            Preconditions.checkNotNull((Object)this.conditions);
            return new IfExpression(this.pos, this.conditions, this.elseExpression, this.outputType);
        }
    }

    public static class IfCondition {
        public final LogicalExpression condition;
        public final LogicalExpression expression;

        public IfCondition(LogicalExpression condition, LogicalExpression expression) {
            this.condition = condition;
            this.expression = expression;
        }
    }
}

