/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.dbf.structure;

import java.io.DataInput;
import java.io.IOException;
import org.jamel.dbf.exception.DbfException;
import org.jamel.dbf.structure.DbfDataType;
import org.jamel.dbf.utils.DbfUtils;

public class DbfField {
    public static final int HEADER_TERMINATOR = 13;
    private String fieldName;
    private DbfDataType dataType;
    private int reserv1;
    private int fieldLength;
    private byte decimalCount;
    private short reserv2;
    private byte workAreaId;
    private short reserv3;
    private byte setFieldsFlag;
    private byte[] reserv4 = new byte[7];
    private byte indexFieldFlag;
    private final int fieldIndex;

    private DbfField(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public static DbfField read(DataInput in, int fieldIndex) throws DbfException {
        try {
            int zeroIndex;
            DbfField field = new DbfField(fieldIndex);
            byte firstByte = in.readByte();
            if (firstByte == 13) {
                return null;
            }
            byte[] nameBuf = new byte[11];
            in.readFully(nameBuf, 1, 10);
            nameBuf[0] = firstByte;
            for (zeroIndex = 0; zeroIndex < nameBuf.length && nameBuf[zeroIndex] != 0; ++zeroIndex) {
            }
            field.fieldName = new String(nameBuf, 0, zeroIndex);
            byte fieldType = in.readByte();
            field.dataType = DbfDataType.valueOf(fieldType);
            if (field.dataType == null) {
                throw new DbfException(String.format("Unsupported Dbf field type: %s", Integer.toString(fieldType, 16)));
            }
            field.reserv1 = DbfUtils.readLittleEndianInt(in);
            field.fieldLength = in.readUnsignedByte();
            field.decimalCount = in.readByte();
            field.reserv2 = DbfUtils.readLittleEndianShort(in);
            field.workAreaId = in.readByte();
            field.reserv2 = DbfUtils.readLittleEndianShort(in);
            field.setFieldsFlag = in.readByte();
            in.readFully(field.reserv4);
            field.indexFieldFlag = in.readByte();
            return field;
        }
        catch (IOException e) {
            throw new DbfException("Cannot read Dbf field", e);
        }
    }

    public String getName() {
        return this.fieldName;
    }

    public DbfDataType getDataType() {
        return this.dataType;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }
}

