/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchMapping;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchVersion;
import org.apache.calcite.runtime.Hook;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticsearchTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTable.class);
    static final int DEFAULT_FETCH_SIZE = 5196;
    private final ObjectMapper mapper;
    private final RestClient restClient;
    final String indexName;
    final ElasticsearchVersion version;
    final ElasticsearchMapping mapping;
    final int fetchSize;

    ElasticsearchTransport(RestClient restClient, ObjectMapper mapper, String indexName, int fetchSize) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        this.indexName = Objects.requireNonNull(indexName, "indexName");
        this.fetchSize = fetchSize;
        this.version = this.version();
        this.mapping = this.fetchAndCreateMapping();
    }

    RestClient restClient() {
        return this.restClient;
    }

    private ElasticsearchVersion version() {
        HttpGet request = new HttpGet("/");
        Function<ObjectNode, ElasticsearchVersion> fn = node -> ElasticsearchVersion.fromString(node.get("version").get("number").asText());
        return this.rawHttp(ObjectNode.class).andThen(fn).apply((HttpRequest)request);
    }

    private ElasticsearchMapping fetchAndCreateMapping() {
        String uri = String.format(Locale.ROOT, "/%s/_mapping", this.indexName);
        ObjectNode root = this.rawHttp(ObjectNode.class).apply((HttpRequest)new HttpGet(uri));
        ObjectNode properties = (ObjectNode)((JsonNode)root.elements().next()).get("mappings");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ElasticsearchJson.visitMappingProperties(properties, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return new ElasticsearchMapping(this.indexName, (Map<String, String>)builder.build());
    }

    ObjectMapper mapper() {
        return this.mapper;
    }

    Function<HttpRequest, Response> rawHttp() {
        return new HttpFunction(this.restClient);
    }

    <T> Function<HttpRequest, T> rawHttp(Class<T> responseType) {
        Objects.requireNonNull(responseType, "responseType");
        return this.rawHttp().andThen(new JsonParserFn<T>(this.mapper, responseType));
    }

    Function<String, ElasticsearchJson.Result> scroll() {
        return scrollId -> {
            HttpPost request = new HttpPost(URI.create("/_search/scroll"));
            ObjectNode payload = this.mapper.createObjectNode().put("scroll", "1m").put("scroll_id", scrollId);
            try {
                String json = this.mapper.writeValueAsString((Object)payload);
                request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
                return this.rawHttp(ElasticsearchJson.Result.class).apply((HttpRequest)request);
            }
            catch (IOException e) {
                String message = String.format(Locale.ROOT, "Couldn't fetch next scroll %s", scrollId);
                throw new UncheckedIOException(message, e);
            }
        };
    }

    void closeScroll(Iterable<String> scrollIds) {
        Objects.requireNonNull(scrollIds, "scrollIds");
        URI uri = URI.create("/_search/scroll");
        HttpEntityEnclosingRequestBase request = new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return "DELETE";
            }
        };
        request.setURI(uri);
        ObjectNode payload = this.mapper().createObjectNode();
        ArrayNode array = payload.withArray("scroll_id");
        StreamSupport.stream(scrollIds.spliterator(), false).map(TextNode::new).forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        try {
            String json = this.mapper().writeValueAsString((Object)payload);
            request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            Response response = this.rawHttp().apply((HttpRequest)request);
        }
        catch (IOException | UncheckedIOException e) {
            LOGGER.warn("Failed to close scroll(s): {}", scrollIds, (Object)e);
        }
    }

    Function<ObjectNode, ElasticsearchJson.Result> search() {
        return this.search(Collections.emptyMap());
    }

    Function<ObjectNode, ElasticsearchJson.Result> search(Map<String, String> httpParams) {
        Objects.requireNonNull(httpParams, "httpParams");
        return query -> {
            HttpPost post;
            Hook.QUERY_PLAN.run(query);
            String path = String.format(Locale.ROOT, "/%s/_search", this.indexName);
            try {
                URIBuilder builder = new URIBuilder(path);
                httpParams.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
                post = new HttpPost(builder.build());
                String json = this.mapper.writeValueAsString(query);
                LOGGER.debug("Elasticsearch Query: {}", (Object)json);
                post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return this.rawHttp(ElasticsearchJson.Result.class).apply((HttpRequest)post);
        };
    }

    private static class HttpFunction
    implements Function<HttpRequest, Response> {
        private final RestClient restClient;

        HttpFunction(RestClient restClient) {
            this.restClient = Objects.requireNonNull(restClient, "restClient");
        }

        @Override
        public Response apply(HttpRequest request) {
            try {
                return this.applyInternal(request);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Response applyInternal(HttpRequest request) throws IOException {
            String payload;
            Objects.requireNonNull(request, "request");
            HttpEntity entity = request instanceof HttpEntityEnclosingRequest ? ((HttpEntityEnclosingRequest)request).getEntity() : null;
            Request r = new Request(request.getRequestLine().getMethod(), request.getRequestLine().getUri());
            r.setEntity(entity);
            Response response = this.restClient.performRequest(r);
            String string = payload = entity != null && entity.isRepeatable() ? EntityUtils.toString((HttpEntity)entity) : "<empty>";
            if (response.getStatusLine().getStatusCode() != 200) {
                String error = EntityUtils.toString((HttpEntity)response.getEntity());
                String message = String.format(Locale.ROOT, "Error while querying Elastic (on %s/%s) status: %s\nPayload:\n%s\nError:\n%s\n", response.getHost(), response.getRequestLine(), response.getStatusLine(), payload, error);
                throw new RuntimeException(message);
            }
            return response;
        }
    }

    private static class JsonParserFn<T>
    implements Function<Response, T> {
        private final ObjectMapper mapper;
        private final Class<T> klass;

        JsonParserFn(ObjectMapper mapper, Class<T> klass) {
            this.mapper = mapper;
            this.klass = klass;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T apply(Response response) {
            try (InputStream is = response.getEntity().getContent();){
                Object object = this.mapper.readValue(is, this.klass);
                return (T)object;
            }
            catch (IOException e) {
                String message = String.format(Locale.ROOT, "Couldn't parse HTTP response %s into %s", response, this.klass);
                throw new UncheckedIOException(message, e);
            }
        }
    }
}

