/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;

final class TruncDate<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -4617792768119885313L;
    private final Field<T> date;
    private final DatePart part;

    TruncDate(Field<T> date, DatePart part) {
        super(Names.N_TRUNC, date.getDataType());
        this.date = date;
        this.part = part;
    }

    @Override
    public final void accept(Context<?> ctx) {
        String keyword = null;
        String format = null;
        switch (ctx.family()) {
            case CUBRID: 
            case HSQLDB: {
                switch (this.part) {
                    case YEAR: {
                        keyword = "YY";
                        break;
                    }
                    case MONTH: {
                        keyword = "MM";
                        break;
                    }
                    case DAY: {
                        keyword = "DD";
                        break;
                    }
                    case HOUR: {
                        keyword = "HH";
                        break;
                    }
                    case MINUTE: {
                        keyword = "MI";
                        break;
                    }
                    case SECOND: {
                        keyword = "SS";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
                break;
            }
            case H2: {
                switch (this.part) {
                    case YEAR: {
                        format = "yyyy";
                        break;
                    }
                    case MONTH: {
                        format = "yyyy-MM";
                        break;
                    }
                    case DAY: {
                        format = "yyyy-MM-dd";
                        break;
                    }
                    case HOUR: {
                        format = "yyyy-MM-dd HH";
                        break;
                    }
                    case MINUTE: {
                        format = "yyyy-MM-dd HH:mm";
                        break;
                    }
                    case SECOND: {
                        format = "yyyy-MM-dd HH:mm:ss";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(DSL.keyword("parsedatetime")).sql('(').visit(DSL.keyword("formatdatetime")).sql('(').visit(this.date).sql(", ").visit(DSL.inline(format)).sql("), ").visit(DSL.inline(format)).sql(')');
                break;
            }
            case POSTGRES: {
                switch (this.part) {
                    case YEAR: {
                        keyword = "year";
                        break;
                    }
                    case MONTH: {
                        keyword = "month";
                        break;
                    }
                    case DAY: {
                        keyword = "day";
                        break;
                    }
                    case HOUR: {
                        keyword = "hour";
                        break;
                    }
                    case MINUTE: {
                        keyword = "minute";
                        break;
                    }
                    case SECOND: {
                        keyword = "second";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_DATE_TRUNC).sql('(').visit(DSL.inline(keyword)).sql(", ").visit(this.date).sql(')');
                break;
            }
            default: {
                ctx.visit(Keywords.F_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
            }
        }
    }

    private final void throwUnsupported() {
        throw new UnsupportedOperationException("Unknown date part : " + (Object)((Object)this.part));
    }
}

