/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.jooq.Asterisk;
import org.jooq.Attachable;
import org.jooq.BindContext;
import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.EmbeddableRecord;
import org.jooq.EnumType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Param;
import org.jooq.QualifiedAsterisk;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.ResultOrRows;
import org.jooq.Results;
import org.jooq.Row;
import org.jooq.RowN;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.SchemaMapping;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableRecord;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.UpdatableRecord;
import org.jooq.conf.BackslashEscaping;
import org.jooq.conf.ParamType;
import org.jooq.conf.ParseNameCase;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.conf.ThrowExceptions;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.MappingException;
import org.jooq.exception.NoDataFoundException;
import org.jooq.exception.TooManyRowsException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.Alias;
import org.jooq.impl.ArrayDataType;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.EmbeddableTableField;
import org.jooq.impl.F0;
import org.jooq.impl.Fields;
import org.jooq.impl.Identifiers;
import org.jooq.impl.IdentityConverter;
import org.jooq.impl.Intern;
import org.jooq.impl.Keywords;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.RowImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableAlias;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Val;
import org.jooq.tools.Ints;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UShort;

final class Tools {
    static final JooqLogger log = JooqLogger.getLogger(Tools.class);
    static final byte[] EMPTY_BYTE = new byte[0];
    static final Class<?>[] EMPTY_CLASS = new Class[0];
    static final Clause[] EMPTY_CLAUSE = new Clause[0];
    static final Collection<?>[] EMPTY_COLLECTION = new Collection[0];
    static final CommonTableExpression<?>[] EMPTY_COMMON_TABLE_EXPRESSION = new CommonTableExpression[0];
    static final ExecuteListener[] EMPTY_EXECUTE_LISTENER = new ExecuteListener[0];
    static final Field<?>[] EMPTY_FIELD = new Field[0];
    static final int[] EMPTY_INT = new int[0];
    static final Name[] EMPTY_NAME = new Name[0];
    static final Param<?>[] EMPTY_PARAM = new Param[0];
    static final OrderField<?>[] EMPTY_ORDERFIELD = new OrderField[0];
    static final Query[] EMPTY_QUERY = new Query[0];
    static final QueryPart[] EMPTY_QUERYPART = new QueryPart[0];
    static final Record[] EMPTY_RECORD = new Record[0];
    static final RowN[] EMPTY_ROWN = new RowN[0];
    static final Schema[] EMPTY_SCHEMA = new Schema[0];
    static final SelectFieldOrAsterisk[] EMPTY_SELECT_FIELD_OR_ASTERISK = new SelectFieldOrAsterisk[0];
    static final SortField<?>[] EMPTY_SORTFIELD = new SortField[0];
    static final String[] EMPTY_STRING = new String[0];
    static final Table<?>[] EMPTY_TABLE = new Table[0];
    static final TableRecord<?>[] EMPTY_TABLE_RECORD = new TableRecord[0];
    static final UpdatableRecord<?>[] EMPTY_UPDATABLE_RECORD = new UpdatableRecord[0];
    static final char ESCAPE = '!';
    private static final Object initLock = new Object();
    private static volatile Boolean isJPAAvailable;
    private static volatile Boolean isKotlinAvailable;
    private static volatile Reflect ktJvmClassMapping;
    private static volatile Reflect ktKClasses;
    private static volatile Reflect ktKClass;
    private static volatile Reflect ktKTypeParameter;
    private static int maxConsumedExceptions;
    private static int maxConsumedResults;
    private static final Pattern DASH_PATTERN;
    private static final Pattern PIPE_PATTERN;
    private static final Pattern PLUS_PATTERN;
    private static final char[] WHITESPACE_CHARACTERS;
    private static final char[][] JDBC_ESCAPE_PREFIXES;
    private static final char[] TOKEN_SINGLE_LINE_COMMENT;
    private static final char[] TOKEN_SINGLE_LINE_COMMENT_C;
    private static final char[] TOKEN_HASH;
    private static final char[] TOKEN_MULTI_LINE_COMMENT_OPEN;
    private static final char[] TOKEN_MULTI_LINE_COMMENT_CLOSE;
    private static final char[] TOKEN_APOS;
    private static final char[] TOKEN_ESCAPED_APOS;
    private static final char[][] NON_BIND_VARIABLE_SUFFIXES;
    private static final char[] HEX_DIGITS;
    private static final Set<SQLDialect> REQUIRES_BACKSLASH_ESCAPING;
    private static final Set<SQLDialect> NO_SUPPORT_NULL;
    private static final Set<SQLDialect> NO_SUPPORT_BINARY_TYPE_LENGTH;
    private static final Set<SQLDialect> NO_SUPPORT_CAST_TYPE_IN_DDL;
    private static final Set<SQLDialect> DEFAULT_BEFORE_NULL;
    private static final Set<SQLDialect> SUPPORT_MYSQL_SYNTAX;
    private static final Set<SQLDialect> SUPPORT_POSTGRES_SYNTAX;
    static final DSLContext CTX;
    private static final Pattern NEW_LINES;
    private static final Pattern P_PARSE_HTML_ROW;
    private static final Pattern P_PARSE_HTML_COL_HEAD;
    private static final Pattern P_PARSE_HTML_COL_BODY;

    Tools() {
    }

    static final List<Row> rows(Result<?> result) {
        ArrayList<Row> rows = new ArrayList<Row>(result.size());
        for (Record record : result) {
            rows.add(record.valuesRow());
        }
        return rows;
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type) {
        return Tools.newRecord(fetched, type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type, Field<?>[] fields) {
        return Tools.newRecord(fetched, type, fields, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Table<R> type) {
        return Tools.newRecord(fetched, type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Table<R> type, Configuration configuration) {
        return Tools.newRecord(fetched, type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(boolean fetched, UDT<R> type) {
        return Tools.newRecord(fetched, type, null);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(boolean fetched, UDT<R> type, Configuration configuration) {
        return Tools.newRecord(fetched, type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type, Field<?>[] fields, Configuration configuration) {
        return Tools.newRecord(fetched, Tools.recordFactory(type, fields), configuration);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, F0<R> factory, Configuration configuration) {
        try {
            Record record = (Record)factory.apply();
            if (record instanceof AbstractRecord) {
                ((AbstractRecord)record).fetched = fetched;
            }
            return new RecordDelegate<Record>(configuration, record);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new record", e);
        }
    }

    static final <R extends Record> F0<R> recordFactory(Class<R> type, Field<?>[] fields) {
        if (type == RecordImpl.class || type == Record.class) {
            final RowImpl row = new RowImpl(fields);
            return new F0<R>(){

                @Override
                public R apply() {
                    return new RecordImpl(row);
                }
            };
        }
        try {
            final Constructor<R> constructor = Reflect.accessible(type.getDeclaredConstructor(new Class[0]));
            return new F0<R>(){

                @Override
                public R apply() {
                    try {
                        return (Record)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not construct new record", e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new record", e);
        }
    }

    static final void resetChangedOnNotNull(Record record) {
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (record.get(i) != null || record.field(i).getDataType().nullable()) continue;
            record.changed(i, false);
        }
    }

    static final Configuration getConfiguration(Attachable attachable) {
        return attachable.configuration();
    }

    static final Configuration configuration(Attachable attachable) {
        return Tools.configuration(attachable.configuration());
    }

    static final Configuration configuration(Configuration configuration) {
        return configuration != null ? configuration : new DefaultConfiguration();
    }

    static final Settings settings(Attachable attachable) {
        return Tools.configuration(attachable).settings();
    }

    static final Settings settings(Configuration configuration) {
        return Tools.configuration(configuration).settings();
    }

    static final boolean attachRecords(Configuration configuration) {
        Settings settings;
        if (configuration != null && (settings = configuration.settings()) != null) {
            return !Boolean.FALSE.equals(settings.isAttachRecords());
        }
        return true;
    }

    static final Field<?>[] fieldArray(Collection<? extends Field<?>> fields) {
        return fields == null ? null : fields.toArray(EMPTY_FIELD);
    }

    static final Class<?>[] types(Field<?>[] fields) {
        return Tools.types(Tools.dataTypes(fields));
    }

    static final Class<?>[] types(DataType<?>[] types) {
        if (types == null) {
            return null;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? types[i].getType() : Object.class;
        }
        return result;
    }

    static final Class<?>[] types(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] instanceof Field ? ((Field)values[i]).getType() : (values[i] != null ? values[i].getClass() : Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        DataType[] result = new DataType[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i] != null ? fields[i].getDataType() : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Class<?>[] types) {
        if (types == null) {
            return null;
        }
        DataType[] result = new DataType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? DSL.getDataType(types[i]) : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Object[] values) {
        return Tools.dataTypes(Tools.types(values));
    }

    static final <T> SortField<T> sortField(OrderField<T> field) {
        if (field instanceof SortField) {
            return (SortField)field;
        }
        if (field instanceof Field) {
            return ((Field)field).sortDefault();
        }
        throw new IllegalArgumentException("Field not supported : " + field);
    }

    static final SortField<?>[] sortFields(OrderField<?>[] fields) {
        if (fields == null) {
            return null;
        }
        if (fields instanceof SortField[]) {
            return (SortField[])fields;
        }
        SortField[] result = new SortField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = Tools.sortField(fields[i]);
        }
        return result;
    }

    static final List<SortField<?>> sortFields(Collection<? extends OrderField<?>> fields) {
        if (fields == null) {
            return null;
        }
        int size = fields.size();
        ArrayList result = new ArrayList(size);
        for (OrderField<?> field : fields) {
            result.add(Tools.sortField(field));
        }
        return result;
    }

    static final Name[] fieldNames(int length) {
        Name[] result = new Name[length];
        for (int i = 0; i < length; ++i) {
            result[i] = DSL.name("v" + i);
        }
        return result;
    }

    static final String[] fieldNameStrings(int length) {
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = "v" + i;
        }
        return result;
    }

    static final Name[] fieldNames(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        Name[] result = new Name[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getUnqualifiedName();
        }
        return result;
    }

    static final String[] fieldNameStrings(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        String[] result = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getName();
        }
        return result;
    }

    static final Field<?>[] fields(int length) {
        return Tools.fields(length, SQLDataType.OTHER);
    }

    static final <T> Field<T>[] fields(int length, DataType<T> type) {
        Field[] result = new Field[length];
        Name[] names = Tools.fieldNames(length);
        for (int i = 0; i < length; ++i) {
            result[i] = DSL.field(DSL.name(names[i]), type);
        }
        return result;
    }

    static final Field<?>[] unqualified(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        Field[] result = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = DSL.field(fields[i].getUnqualifiedName(), fields[i].getDataType());
        }
        return result;
    }

    static final Name[] unqualifiedNames(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        Name[] result = new Name[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getUnqualifiedName();
        }
        return result;
    }

    static final Field<?>[] aliasedFields(Field<?>[] fields, Name[] aliases) {
        if (fields == null) {
            return null;
        }
        Field[] result = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].as(aliases[i]);
        }
        return result;
    }

    static final Field<?>[] fieldsByName(Collection<String> fieldNames) {
        return Tools.fieldsByName(null, fieldNames.toArray(EMPTY_STRING));
    }

    static final Field<?>[] fieldsByName(String[] fieldNames) {
        return Tools.fieldsByName(null, fieldNames);
    }

    static final Field<?>[] fieldsByName(String tableName, Collection<String> fieldNames) {
        return Tools.fieldsByName(tableName, fieldNames.toArray(EMPTY_STRING));
    }

    static final Field<?>[] fieldsByName(Name tableName, Name[] fieldNames) {
        if (fieldNames == null) {
            return null;
        }
        Field[] result = new Field[fieldNames.length];
        if (tableName == null) {
            for (int i = 0; i < fieldNames.length; ++i) {
                result[i] = DSL.field(fieldNames[i]);
            }
        } else {
            for (int i = 0; i < fieldNames.length; ++i) {
                result[i] = DSL.field(DSL.name(tableName, fieldNames[i]));
            }
        }
        return result;
    }

    static final Field<?>[] fieldsByName(String tableName, String[] fieldNames) {
        if (fieldNames == null) {
            return null;
        }
        Field[] result = new Field[fieldNames.length];
        if (StringUtils.isEmpty(tableName)) {
            for (int i = 0; i < fieldNames.length; ++i) {
                result[i] = DSL.field(DSL.name(fieldNames[i]));
            }
        } else {
            for (int i = 0; i < fieldNames.length; ++i) {
                result[i] = DSL.field(DSL.name(tableName, fieldNames[i]));
            }
        }
        return result;
    }

    static final Field<?>[] fieldsByName(Name[] names) {
        if (names == null) {
            return null;
        }
        Field[] result = new Field[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = DSL.field(names[i]);
        }
        return result;
    }

    static final Name[] names(String[] names) {
        if (names == null) {
            return null;
        }
        Name[] result = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = DSL.name(names[i]);
        }
        return result;
    }

    static final List<Name> names(Collection<?> names) {
        if (names == null) {
            return null;
        }
        ArrayList<Name> result = new ArrayList<Name>(names.size());
        for (Object o : names) {
            result.add(o instanceof Name ? (Name)o : DSL.name(String.valueOf(o)));
        }
        return result;
    }

    private static final IllegalArgumentException fieldExpected(Object value) {
        return new IllegalArgumentException("Cannot interpret argument of type " + value.getClass() + " as a Field: " + value);
    }

    static <T> Field<T>[] castAllIfNeeded(Field<?>[] fields, Class<T> type) {
        Field[] castFields = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            castFields[i] = Tools.castIfNeeded(fields[i], type);
        }
        return castFields;
    }

    static final <T> Field<T> castIfNeeded(Field<?> field, Class<T> type) {
        if (field.getType().equals(type)) {
            return field;
        }
        return field.cast(type);
    }

    static final <T> Field<T> castIfNeeded(Field<?> field, DataType<T> type) {
        if (field.getDataType().equals(type)) {
            return field;
        }
        return field.cast(type);
    }

    static final <T> Field<T> castIfNeeded(Field<?> field, Field<T> type) {
        if (field.getDataType().equals(type.getDataType())) {
            return field;
        }
        return field.cast(type);
    }

    static final <T> Field<T> field(T value) {
        if (value instanceof Field) {
            return (Field)value;
        }
        if (value instanceof Select && ((Select)value).getSelect().size() == 1) {
            return DSL.field((Select)value);
        }
        if (value instanceof QueryPart) {
            throw Tools.fieldExpected(value);
        }
        return DSL.val(value);
    }

    static final Param<Byte> field(byte value) {
        return DSL.val((Object)value, SQLDataType.TINYINT);
    }

    static final Param<Byte> field(Byte value) {
        return DSL.val((Object)value, SQLDataType.TINYINT);
    }

    static final Param<UByte> field(UByte value) {
        return DSL.val((Object)value, SQLDataType.TINYINTUNSIGNED);
    }

    static final Param<Short> field(short value) {
        return DSL.val((Object)value, SQLDataType.SMALLINT);
    }

    static final Param<Short> field(Short value) {
        return DSL.val((Object)value, SQLDataType.SMALLINT);
    }

    static final Param<UShort> field(UShort value) {
        return DSL.val((Object)value, SQLDataType.SMALLINTUNSIGNED);
    }

    static final Param<Integer> field(int value) {
        return DSL.val((Object)value, SQLDataType.INTEGER);
    }

    static final Param<Integer> field(Integer value) {
        return DSL.val((Object)value, SQLDataType.INTEGER);
    }

    static final Param<UInteger> field(UInteger value) {
        return DSL.val((Object)value, SQLDataType.INTEGERUNSIGNED);
    }

    static final Param<Long> field(long value) {
        return DSL.val((Object)value, SQLDataType.BIGINT);
    }

    static final Param<Long> field(Long value) {
        return DSL.val((Object)value, SQLDataType.BIGINT);
    }

    static final Param<ULong> field(ULong value) {
        return DSL.val((Object)value, SQLDataType.BIGINTUNSIGNED);
    }

    static final Param<Float> field(float value) {
        return DSL.val((Object)Float.valueOf(value), SQLDataType.REAL);
    }

    static final Param<Float> field(Float value) {
        return DSL.val((Object)value, SQLDataType.REAL);
    }

    static final Param<Double> field(double value) {
        return DSL.val((Object)value, SQLDataType.DOUBLE);
    }

    static final Param<Double> field(Double value) {
        return DSL.val((Object)value, SQLDataType.DOUBLE);
    }

    static final Param<Boolean> field(boolean value) {
        return DSL.val((Object)value, SQLDataType.BOOLEAN);
    }

    static final Param<Boolean> field(Boolean value) {
        return DSL.val((Object)value, SQLDataType.BOOLEAN);
    }

    static final Param<BigDecimal> field(BigDecimal value) {
        return DSL.val((Object)value, SQLDataType.DECIMAL);
    }

    static final Param<BigInteger> field(BigInteger value) {
        return DSL.val((Object)value, SQLDataType.DECIMAL_INTEGER);
    }

    static final Param<byte[]> field(byte[] value) {
        return DSL.val((Object)value, SQLDataType.VARBINARY);
    }

    static final Param<String> field(String value) {
        return DSL.val((Object)value, SQLDataType.VARCHAR);
    }

    static final Param<Date> field(Date value) {
        return DSL.val((Object)value, SQLDataType.DATE);
    }

    static final Param<Time> field(Time value) {
        return DSL.val((Object)value, SQLDataType.TIME);
    }

    static final Param<Timestamp> field(Timestamp value) {
        return DSL.val((Object)value, SQLDataType.TIMESTAMP);
    }

    static final Param<LocalDate> field(LocalDate value) {
        return DSL.val((Object)value, SQLDataType.LOCALDATE);
    }

    static final Param<LocalTime> field(LocalTime value) {
        return DSL.val((Object)value, SQLDataType.LOCALTIME);
    }

    static final Param<LocalDateTime> field(LocalDateTime value) {
        return DSL.val((Object)value, SQLDataType.LOCALDATETIME);
    }

    static final Param<OffsetTime> field(OffsetTime value) {
        return DSL.val((Object)value, SQLDataType.OFFSETTIME);
    }

    static final Param<OffsetDateTime> field(OffsetDateTime value) {
        return DSL.val((Object)value, SQLDataType.OFFSETDATETIME);
    }

    static final Param<Instant> field(Instant value) {
        return DSL.val((Object)value, SQLDataType.INSTANT);
    }

    static final Param<UUID> field(UUID value) {
        return DSL.val((Object)value, SQLDataType.UUID);
    }

    @Deprecated
    static final Field<Object> field(Name name) {
        return DSL.field(name);
    }

    static final <T> Field<T> field(Object value, Field<T> field) {
        if (value instanceof Field) {
            return (Field)value;
        }
        if (value instanceof QueryPart) {
            throw Tools.fieldExpected(value);
        }
        return DSL.val(value, field);
    }

    static final <T> Field<T> field(Object value, Class<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        if (value instanceof QueryPart) {
            throw Tools.fieldExpected(value);
        }
        return DSL.val(value, type);
    }

    static final <T> Field<T> field(Object value, DataType<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        if (value instanceof QueryPart) {
            throw Tools.fieldExpected(value);
        }
        return DSL.val(value, type);
    }

    static final <T> List<Field<T>> fields(T[] values) {
        if (values == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.add(Tools.field(values[i]));
        }
        return result;
    }

    static final <T> List<Field<T>> fields(Object[] values, Field<T> field) {
        if (values == null || field == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.add(Tools.field(values[i], field));
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Field<?>[] fields) {
        if (values == null || fields == null) {
            return new ArrayList();
        }
        int length = Math.min(values.length, fields.length);
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(Tools.field(values[i], fields[i]));
        }
        return result;
    }

    static final Field<?>[] fieldsArray(Object[] values, Field<?>[] fields) {
        if (values == null || fields == null) {
            return EMPTY_FIELD;
        }
        int length = Math.min(values.length, fields.length);
        Field[] result = new Field[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Tools.field(values[i], fields[i]);
        }
        return result;
    }

    static final <T> List<Field<T>> fields(Object[] values, Class<T> type) {
        if (values == null || type == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.add(Tools.field(values[i], type));
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Class<?>[] types) {
        if (values == null || types == null) {
            return new ArrayList();
        }
        int length = Math.min(values.length, types.length);
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(Tools.field(values[i], types[i]));
        }
        return result;
    }

    static final <T> List<Field<T>> fields(Object[] values, DataType<T> type) {
        if (values == null || type == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.length);
        for (Object value : values) {
            result.add(Tools.field(value, type));
        }
        return result;
    }

    static final <T> List<Field<T>> fields(Collection<?> values, DataType<T> type) {
        if (values == null || type == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.size());
        for (Object value : values) {
            result.add(Tools.field(value, type));
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, DataType<?>[] types) {
        if (values == null || types == null) {
            return new ArrayList();
        }
        int length = Math.min(values.length, types.length);
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(Tools.field(values[i], types[i]));
        }
        return result;
    }

    static final Field<?>[] fieldsArray(Object[] values, DataType<?>[] types) {
        if (values == null || types == null) {
            return EMPTY_FIELD;
        }
        int length = Math.min(values.length, types.length);
        Field[] result = new Field[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Tools.field(values[i], types[i]);
        }
        return result;
    }

    static final <T> List<Field<T>> inline(T[] values) {
        if (values == null) {
            return new ArrayList<Field<T>>();
        }
        ArrayList<Field<T>> result = new ArrayList<Field<T>>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.add(DSL.inline(values[i]));
        }
        return result;
    }

    static final Field<Integer>[] inline(int[] fieldIndexes) {
        if (fieldIndexes == null) {
            return EMPTY_FIELD;
        }
        Field[] result = new Field[fieldIndexes.length];
        for (int i = 0; i < fieldIndexes.length; ++i) {
            result[i] = DSL.inline(fieldIndexes[i]);
        }
        return result;
    }

    static final int indexOrFail(Row row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(Row row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(Row row, Name fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, Name fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in RecordType " + row);
        }
        return result;
    }

    @SafeVarargs
    static final <T> T[] array(T ... array) {
        return array;
    }

    @SafeVarargs
    static final <T> T[] reverse(T ... array) {
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length / 2; ++i) {
            T tmp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = tmp;
        }
        return array;
    }

    @SafeVarargs
    static final <T> Iterable<T> reverseIterable(T ... array) {
        return Tools.reverseIterable(Arrays.asList(array));
    }

    @SafeVarargs
    static final <T> Iterator<T> reverseIterator(T ... array) {
        return Tools.reverseIterator(Arrays.asList(array));
    }

    static final <T> Iterable<T> reverseIterable(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Tools.reverseIterator(list);
            }
        };
    }

    static final <T> Iterator<T> reverseIterator(final List<T> list) {
        return new Iterator<T>(){
            ListIterator<T> li;
            {
                this.li = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.li.hasPrevious();
            }

            @Override
            public T next() {
                return this.li.previous();
            }

            @Override
            public void remove() {
                this.li.remove();
            }
        };
    }

    @SafeVarargs
    static final <T> List<T> list(T ... array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    static final Map<Field<?>, Object> mapOfChangedValues(Record record) {
        LinkedHashMap result = new LinkedHashMap();
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (!record.changed(i)) continue;
            result.put(record.field(i), record.get(i));
        }
        return result;
    }

    static final <T> T first(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    static final void setFetchSize(ExecuteContext ctx, int fetchSize) throws SQLException {
        int f = SettingsTools.getFetchSize(fetchSize, ctx.settings());
        if (f != 0) {
            PreparedStatement statement;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting fetch size", f);
            }
            if ((statement = ctx.statement()) != null) {
                statement.setFetchSize(f);
            }
        }
    }

    @Deprecated
    static final <R extends Record> R filterOne(List<R> list) throws TooManyRowsException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (R)((Record)list.get(0));
        }
        throw new TooManyRowsException("Too many rows selected : " + size);
    }

    static final <R extends Record> R fetchOne(Cursor<R> cursor) throws TooManyRowsException {
        return Tools.fetchOne(cursor, false);
    }

    static final <R extends Record> R fetchOne(Cursor<R> cursor, boolean hasLimit1) throws TooManyRowsException {
        try {
            Result<R> result = cursor.fetchNext(hasLimit1 ? 1 : 2);
            int size = result.size();
            if (size == 0) {
                R r = null;
                return r;
            }
            if (size == 1) {
                Record record = (Record)result.get(0);
                return (R)record;
            }
            throw Tools.exception((CursorImpl)cursor, new TooManyRowsException("Cursor returned more than one result"));
        }
        finally {
            cursor.close();
        }
    }

    static final <R extends Record> R fetchSingle(Cursor<R> cursor) throws NoDataFoundException, TooManyRowsException {
        return Tools.fetchSingle(cursor, false);
    }

    static final <R extends Record> R fetchSingle(Cursor<R> cursor, boolean hasLimit1) throws NoDataFoundException, TooManyRowsException {
        try {
            Result<R> result = cursor.fetchNext(hasLimit1 ? 1 : 2);
            int size = result.size();
            if (size == 0) {
                throw Tools.exception((CursorImpl)cursor, new NoDataFoundException("Cursor returned no rows"));
            }
            if (size == 1) {
                Record record = (Record)result.get(0);
                return (R)record;
            }
            throw Tools.exception((CursorImpl)cursor, new TooManyRowsException("Cursor returned more than one result"));
        }
        finally {
            cursor.close();
        }
    }

    private static final RuntimeException exception(CursorImpl<?> cursor, RuntimeException e) {
        cursor.ctx.exception(e);
        cursor.listener.exception(cursor.ctx);
        return cursor.ctx.exception();
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, Collection<? extends QueryPart> parts) {
        if (parts != null) {
            for (QueryPart queryPart : parts) {
                ctx.visit(queryPart);
            }
        }
        return ctx;
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, QueryPart[] parts) {
        if (parts != null) {
            for (QueryPart part : parts) {
                ctx.visit(part);
            }
        }
        return ctx;
    }

    static final void renderAndBind(Context<?> ctx, String sql, List<QueryPart> substitutes) {
        RenderContext render = (RenderContext)(ctx instanceof RenderContext ? ctx : null);
        BindContext bind = (BindContext)(ctx instanceof BindContext ? ctx : null);
        int substituteIndex = 0;
        char[] sqlChars = sql.toCharArray();
        if (render == null) {
            render = new DefaultRenderContext(bind.configuration());
        }
        SQLDialect family = render.family();
        boolean mysql = SUPPORT_MYSQL_SYNTAX.contains((Object)family);
        char[][][] quotes = Identifiers.QUOTES.get((Object)family);
        boolean needsBackslashEscaping = Tools.needsBackslashEscaping(ctx.configuration());
        block0: for (int i = 0; i < sqlChars.length; ++i) {
            block39: {
                if (Tools.peek(sqlChars, i, TOKEN_SINGLE_LINE_COMMENT) || Tools.peek(sqlChars, i, TOKEN_SINGLE_LINE_COMMENT_C) || mysql && Tools.peek(sqlChars, i, TOKEN_HASH)) {
                    while (i < sqlChars.length && sqlChars[i] != '\r' && sqlChars[i] != '\n') {
                        render.sql(sqlChars[i++]);
                    }
                    if (i >= sqlChars.length) continue;
                    render.sql(sqlChars[i]);
                    continue;
                }
                if (Tools.peek(sqlChars, i, TOKEN_MULTI_LINE_COMMENT_OPEN)) {
                    int nestedMultilineCommentLevel = 1;
                    do {
                        render.sql(sqlChars[i++]);
                        if (Tools.peek(sqlChars, i, TOKEN_MULTI_LINE_COMMENT_OPEN)) {
                            ++nestedMultilineCommentLevel;
                            continue;
                        }
                        if (!Tools.peek(sqlChars, i, TOKEN_MULTI_LINE_COMMENT_CLOSE)) continue;
                        --nestedMultilineCommentLevel;
                    } while (nestedMultilineCommentLevel != 0);
                    render.sql(sqlChars[i]);
                    continue;
                }
                if (sqlChars[i] != '\'') break block39;
                render.sql(sqlChars[i++]);
                while (i < sqlChars.length) {
                    block43: {
                        block41: {
                            block42: {
                                block40: {
                                    if (sqlChars[i] != '\\' || !needsBackslashEscaping) break block40;
                                    render.sql(sqlChars[i++]);
                                    break block41;
                                }
                                if (!Tools.peek(sqlChars, i, TOKEN_ESCAPED_APOS)) break block42;
                                render.sql(sqlChars[i++]);
                                break block41;
                            }
                            if (Tools.peek(sqlChars, i, TOKEN_APOS)) break block43;
                        }
                        render.sql(sqlChars[i++]);
                        continue;
                    }
                    render.sql(sqlChars[i]);
                    continue block0;
                }
                break;
            }
            if ((sqlChars[i] == 'e' || sqlChars[i] == 'E') && ctx.family() == SQLDialect.POSTGRES && i + 1 < sqlChars.length && sqlChars[i + 1] == '\'') {
                render.sql(sqlChars[i++]);
                render.sql(sqlChars[i++]);
                while (true) {
                    if (sqlChars[i] == '\\') {
                        render.sql(sqlChars[i++]);
                    } else if (Tools.peek(sqlChars, i, TOKEN_ESCAPED_APOS)) {
                        render.sql(sqlChars[i++]);
                    } else if (Tools.peek(sqlChars, i, TOKEN_APOS)) break;
                    render.sql(sqlChars[i++]);
                }
                render.sql(sqlChars[i]);
                continue;
            }
            if (Tools.peekAny(sqlChars, i, quotes[0])) {
                int d;
                int delimiter = 0;
                for (d = 0; d < quotes[0].length; ++d) {
                    if (!Tools.peek(sqlChars, i, quotes[0][d])) continue;
                    delimiter = d;
                    break;
                }
                for (d = 0; d < quotes[0][delimiter].length; ++d) {
                    render.sql(sqlChars[i++]);
                }
                while (i < sqlChars.length) {
                    if (Tools.peek(sqlChars, i, quotes[2][delimiter])) {
                        for (d = 0; d < quotes[2][delimiter].length; ++d) {
                            render.sql(sqlChars[i++]);
                        }
                        continue;
                    }
                    if (!Tools.peek(sqlChars, i, quotes[1][delimiter])) {
                        render.sql(sqlChars[i++]);
                        continue;
                    }
                    for (d = 0; d < quotes[1][delimiter].length; ++d) {
                        if (d > 0) {
                            ++i;
                        }
                        render.sql(sqlChars[i]);
                    }
                    continue block0;
                }
                break;
            }
            if (substituteIndex < substitutes.size() && (sqlChars[i] == '?' || sqlChars[i] == ':' && i + 1 < sqlChars.length && Character.isJavaIdentifierPart(sqlChars[i + 1]) && (i - 1 < 0 || sqlChars[i - 1] != ':'))) {
                if (sqlChars[i] == '?' && i + 1 < sqlChars.length) {
                    for (char[] suffix : NON_BIND_VARIABLE_SUFFIXES) {
                        if (!Tools.peek(sqlChars, i + 1, suffix)) continue;
                        int j = i;
                        while (i - j <= suffix.length) {
                            render.sql(sqlChars[i]);
                            ++i;
                        }
                        render.sql(sqlChars[i]);
                        continue block0;
                    }
                }
                if (sqlChars[i] == ':') {
                    while (i + 1 < sqlChars.length && Character.isJavaIdentifierPart(sqlChars[i + 1])) {
                        ++i;
                    }
                }
                QueryPart substitute = substitutes.get(substituteIndex++);
                if (render.paramType() == ParamType.INLINED || render.paramType() == ParamType.NAMED || render.paramType() == ParamType.NAMED_OR_INLINED) {
                    render.visit(substitute);
                } else {
                    RenderContext.CastMode previous = render.castMode();
                    ((RenderContext)render.castMode(RenderContext.CastMode.NEVER).visit(substitute)).castMode(previous);
                }
                if (bind == null) continue;
                bind.visit(substitute);
                continue;
            }
            if (sqlChars[i] == '{') {
                if (Tools.peekAny(sqlChars, i, JDBC_ESCAPE_PREFIXES, true)) {
                    render.sql(sqlChars[i]);
                    continue;
                }
                int start = ++i;
                while (i < sqlChars.length && sqlChars[i] != '}') {
                    ++i;
                }
                int end = i;
                Integer index = Ints.tryParse(sql, start, end);
                if (index != null) {
                    QueryPart substitute = substitutes.get(index);
                    render.visit(substitute);
                    if (bind == null) continue;
                    bind.visit(substitute);
                    continue;
                }
                render.visit(DSL.keyword(sql.substring(start, end)));
                continue;
            }
            render.sql(sqlChars[i]);
        }
    }

    static final boolean needsBackslashEscaping(Configuration configuration) {
        BackslashEscaping escaping = SettingsTools.getBackslashEscaping(configuration.settings());
        return escaping == BackslashEscaping.ON || escaping == BackslashEscaping.DEFAULT && REQUIRES_BACKSLASH_ESCAPING.contains((Object)configuration.family());
    }

    static final boolean peek(char[] sqlChars, int index, char[] peek) {
        return Tools.peek(sqlChars, index, peek, false);
    }

    static final boolean peek(char[] sqlChars, int index, char[] peek, boolean anyWhitespace) {
        block0: for (int i = 0; i < peek.length; ++i) {
            if (index + i >= sqlChars.length) {
                return false;
            }
            if (sqlChars[index + i] == peek[i]) continue;
            if (anyWhitespace && peek[i] == ' ') {
                for (int j = 0; j < WHITESPACE_CHARACTERS.length; ++j) {
                    if (sqlChars[index + i] == WHITESPACE_CHARACTERS[j]) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    static final boolean peekAny(char[] sqlChars, int index, char[][] peekAny) {
        return Tools.peekAny(sqlChars, index, peekAny, false);
    }

    static final boolean peekAny(char[] sqlChars, int index, char[][] peekAny, boolean anyWhitespace) {
        for (char[] peek : peekAny) {
            if (!Tools.peek(sqlChars, index, peek, anyWhitespace)) continue;
            return true;
        }
        return false;
    }

    static final List<QueryPart> queryParts(Object ... substitutes) {
        if (substitutes == null) {
            return Tools.queryParts(new Object[]{null});
        }
        ArrayList<QueryPart> result = new ArrayList<QueryPart>(substitutes.length);
        for (Object substitute : substitutes) {
            if (substitute instanceof QueryPart) {
                result.add((QueryPart)substitute);
                continue;
            }
            Class type = substitute != null ? substitute.getClass() : Object.class;
            result.add(new Val<Object>(substitute, DSL.getDataType(type)));
        }
        return result;
    }

    static final void fieldNames(Context<?> context, Fields<?> fields) {
        Tools.fieldNames(context, Tools.list(fields.fields));
    }

    static final void fieldNames(Context<?> context, Field<?> ... fields) {
        Tools.fieldNames(context, Tools.list(fields));
    }

    static final void fieldNames(Context<?> context, Collection<? extends Field<?>> list) {
        String separator = "";
        for (Field<?> field : list) {
            context.sql(separator).visit(field.getUnqualifiedName());
            separator = ", ";
        }
    }

    static final void tableNames(Context<?> context, Table<?> ... list) {
        Tools.tableNames(context, Tools.list(list));
    }

    static final void tableNames(Context<?> context, Collection<? extends Table<?>> list) {
        String separator = "";
        for (Table<?> table : list) {
            context.sql(separator).visit(table.getUnqualifiedName());
            separator = ", ";
        }
    }

    static final <T> T[] combine(T[] array, T value) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = value;
        return result;
    }

    static final Field<?>[] combine(Field<?> field, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field};
        }
        Field[] result = new Field[fields.length + 1];
        result[0] = field;
        System.arraycopy(fields, 0, result, 1, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2};
        }
        Field[] result = new Field[fields.length + 2];
        result[0] = field1;
        result[1] = field2;
        System.arraycopy(fields, 0, result, 2, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> field3, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2, field3};
        }
        Field[] result = new Field[fields.length + 3];
        result[0] = field1;
        result[1] = field2;
        result[2] = field3;
        System.arraycopy(fields, 0, result, 3, fields.length);
        return result;
    }

    static final DataAccessException translate(String sql, SQLException e) {
        if (e != null) {
            return new DataAccessException("SQL [" + sql + "]; " + e.getMessage(), e);
        }
        return new DataAccessException("SQL [" + sql + "]; Unspecified SQLException");
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx) {
        Tools.safeClose(listener, ctx, false);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement) {
        Tools.safeClose(listener, ctx, keepStatement, true);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement, boolean keepResultSet) {
        JDBCUtils.safeClose(ctx.resultSet());
        ctx.resultSet(null);
        PreparedStatement statement = ctx.statement();
        if (statement != null) {
            Tools.consumeWarnings(ctx, listener);
        }
        if (!keepStatement) {
            if (statement != null) {
                JDBCUtils.safeClose(statement);
                ctx.statement(null);
            } else {
                Connection connection = DefaultExecuteContext.localConnection();
                if (connection != null && ((DefaultExecuteContext)ctx).connectionProvider != null) {
                    ((DefaultExecuteContext)ctx).connectionProvider.release(connection);
                }
            }
        }
        if (keepResultSet) {
            listener.end(ctx);
        }
        DefaultExecuteContext.clean();
    }

    static final <T> void setValue(Record target, Field<T> targetField, Record source, Field<?> sourceField) {
        Tools.setValue(target, targetField, source.get(sourceField));
    }

    static final <T> void setValue(Record target, Field<T> targetField, Object value) {
        target.set(targetField, targetField.getDataType().convert(value));
    }

    static final <T> void copyValue(AbstractRecord target, Field<T> targetField, Record source, Field<?> sourceField) {
        DataType targetType = targetField.getDataType();
        int targetIndex = Tools.indexOrFail(target.fieldsRow(), targetField);
        int sourceIndex = Tools.indexOrFail(source.fieldsRow(), sourceField);
        target.values[targetIndex] = targetType.convert(source.get(sourceIndex));
        target.originals[targetIndex] = targetType.convert(source.original(sourceIndex));
        target.changed.set(targetIndex, source.changed(sourceIndex));
    }

    static final Catalog getMappedCatalog(Configuration configuration, Catalog catalog) {
        SchemaMapping mapping;
        if (configuration != null && (mapping = configuration.schemaMapping()) != null) {
            return mapping.map(catalog);
        }
        return catalog;
    }

    static final Schema getMappedSchema(Configuration configuration, Schema schema) {
        SchemaMapping mapping;
        if (configuration != null && (mapping = configuration.schemaMapping()) != null) {
            return mapping.map(schema);
        }
        return schema;
    }

    static final <R extends Record> Table<R> getMappedTable(Configuration configuration, Table<R> table) {
        SchemaMapping mapping;
        if (configuration != null && (mapping = configuration.schemaMapping()) != null) {
            return mapping.map(table);
        }
        return table;
    }

    static final String getMappedUDTName(Configuration configuration, Class<? extends UDTRecord<?>> type) {
        return Tools.getMappedUDTName(configuration, Tools.newRecord(false, type).operate(null));
    }

    static final String getMappedUDTName(Configuration configuration, UDTRecord<?> record) {
        UDT<?> udt = record.getUDT();
        Schema mapped = Tools.getMappedSchema(configuration, udt.getSchema());
        StringBuilder sb = new StringBuilder();
        if (mapped != null && !"".equals(mapped.getName())) {
            sb.append(mapped.getName()).append('.');
        }
        sb.append(record.getUDT().getName());
        return sb.toString();
    }

    static final int hash(QueryPart part) {
        return 0x7FFFFFF & CTX.render(part).hashCode();
    }

    static final Field<String> escapeForLike(Field<?> field) {
        return Tools.escapeForLike(field, new DefaultConfiguration());
    }

    static final Field<String> escapeForLike(Field<?> field, Configuration configuration) {
        if (DSL.nullSafeDataType(field).isString()) {
            return DSL.escape(field, '!');
        }
        return Tools.castIfNeeded(field, String.class);
    }

    static final boolean isVal(Field<?> field) {
        return field instanceof Param;
    }

    static final boolean hasDefaultConverter(Field<?> field) {
        return field.getConverter() instanceof IdentityConverter;
    }

    static final <T> T extractVal(Field<T> field) {
        if (Tools.isVal(field)) {
            return ((Param)field).getValue();
        }
        return null;
    }

    static final void addConditions(ConditionProvider query, Record record, Field<?> ... keys) {
        for (Field<?> field : keys) {
            Tools.addCondition(query, record, field);
        }
    }

    static final <T> void addCondition(ConditionProvider provider, Record record, Field<T> field) {
        if (SettingsTools.updatablePrimaryKeys(Tools.settings(record))) {
            provider.addConditions(Tools.condition(field, record.original(field)));
        } else {
            provider.addConditions(Tools.condition(field, record.get(field)));
        }
    }

    static final <T> Condition condition(Field<T> field, T value) {
        return value == null ? field.isNull() : field.eq(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isJPAAvailable() {
        if (isJPAAvailable == null) {
            Object object = initLock;
            synchronized (object) {
                if (isJPAAvailable == null) {
                    try {
                        Class.forName(Column.class.getName());
                        isJPAAvailable = true;
                    }
                    catch (Throwable e) {
                        isJPAAvailable = false;
                    }
                }
            }
        }
        return isJPAAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isKotlinAvailable() {
        if (isKotlinAvailable == null) {
            Object object = initLock;
            synchronized (object) {
                if (isKotlinAvailable == null) {
                    try {
                        if (Tools.ktJvmClassMapping() != null) {
                            if (Tools.ktKClasses() != null) {
                                isKotlinAvailable = true;
                            } else {
                                isKotlinAvailable = false;
                                log.info("Kotlin is available, but not kotlin-reflect. Add the kotlin-reflect dependency to better use Kotlin features like data classes");
                            }
                        } else {
                            isKotlinAvailable = false;
                        }
                    }
                    catch (ReflectException e) {
                        isKotlinAvailable = false;
                    }
                }
            }
        }
        return isKotlinAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Reflect ktJvmClassMapping() {
        if (ktJvmClassMapping == null) {
            Object object = initLock;
            synchronized (object) {
                if (ktJvmClassMapping == null) {
                    try {
                        ktJvmClassMapping = Reflect.on("kotlin.jvm.JvmClassMappingKt");
                    }
                    catch (ReflectException reflectException) {
                        // empty catch block
                    }
                }
            }
        }
        return ktJvmClassMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Reflect ktKClasses() {
        if (ktKClasses == null) {
            Object object = initLock;
            synchronized (object) {
                if (ktKClasses == null) {
                    try {
                        ktKClasses = Reflect.on("kotlin.reflect.full.KClasses");
                    }
                    catch (ReflectException reflectException) {
                        // empty catch block
                    }
                }
            }
        }
        return ktKClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Reflect ktKClass() {
        if (ktKClass == null) {
            Object object = initLock;
            synchronized (object) {
                if (ktKClass == null) {
                    try {
                        ktKClass = Reflect.on("kotlin.reflect.KClass");
                    }
                    catch (ReflectException reflectException) {
                        // empty catch block
                    }
                }
            }
        }
        return ktKClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Reflect ktKTypeParameter() {
        if (ktKTypeParameter == null) {
            Object object = initLock;
            synchronized (object) {
                if (ktKTypeParameter == null) {
                    try {
                        ktKTypeParameter = Reflect.on("kotlin.reflect.KTypeParameter");
                    }
                    catch (ReflectException reflectException) {
                        // empty catch block
                    }
                }
            }
        }
        return ktKTypeParameter;
    }

    static final boolean hasColumnAnnotations(Configuration configuration, final Class<?> type) {
        return Cache.run(configuration, new F0<Boolean>(){

            @Override
            public Boolean apply() {
                if (!Tools.isJPAAvailable()) {
                    return false;
                }
                if (type.getAnnotation(Entity.class) != null) {
                    return true;
                }
                if (type.getAnnotation(javax.persistence.Table.class) != null) {
                    return true;
                }
                for (java.lang.reflect.Field member : Tools.getInstanceMembers(type)) {
                    if (member.getAnnotation(Column.class) != null) {
                        return true;
                    }
                    if (member.getAnnotation(Id.class) == null) continue;
                    return true;
                }
                for (Method method : Tools.getInstanceMethods(type)) {
                    if (method.getAnnotation(Column.class) == null) continue;
                    return true;
                }
                return false;
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_HAS_COLUMN_ANNOTATIONS, type);
    }

    static final List<java.lang.reflect.Field> getAnnotatedMembers(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<List<java.lang.reflect.Field>>(){

            @Override
            public List<java.lang.reflect.Field> apply() {
                ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
                for (java.lang.reflect.Field member : Tools.getInstanceMembers(type)) {
                    Column column = member.getAnnotation(Column.class);
                    if (column != null) {
                        if (!Tools.namesMatch(name, column.name())) continue;
                        result.add(Reflect.accessible(member));
                        continue;
                    }
                    Id id = member.getAnnotation(Id.class);
                    if (id == null || !Tools.namesMatch(name, member.getName())) continue;
                    result.add(Reflect.accessible(member));
                }
                return result;
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_ANNOTATED_MEMBERS, Cache.key(type, name));
    }

    private static final boolean namesMatch(String name, String annotation) {
        return annotation.startsWith("\"") ? ('\"' + name + '\"').equals(annotation) : name.equalsIgnoreCase(annotation);
    }

    static final List<java.lang.reflect.Field> getMatchingMembers(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<List<java.lang.reflect.Field>>(){

            @Override
            public List<java.lang.reflect.Field> apply() {
                ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
                String camelCaseLC = StringUtils.toCamelCaseLC(name);
                for (java.lang.reflect.Field member : Tools.getInstanceMembers(type)) {
                    if (name.equals(member.getName())) {
                        result.add(Reflect.accessible(member));
                        continue;
                    }
                    if (!camelCaseLC.equals(member.getName())) continue;
                    result.add(Reflect.accessible(member));
                }
                return result;
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_MATCHING_MEMBERS, Cache.key(type, name));
    }

    static final List<Method> getAnnotatedSetters(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<List<Method>>(){

            @Override
            public List<Method> apply() {
                LinkedHashSet<SourceMethod> set = new LinkedHashSet<SourceMethod>();
                for (Method method : Tools.getInstanceMethods(type)) {
                    String m;
                    String suffix;
                    Column column = method.getAnnotation(Column.class);
                    if (column == null || !Tools.namesMatch(name, column.name())) continue;
                    if (method.getParameterTypes().length == 1) {
                        set.add(new SourceMethod(Reflect.accessible(method)));
                        continue;
                    }
                    if (method.getParameterTypes().length != 0 || (suffix = (m = method.getName()).startsWith("get") ? m.substring(3) : (m.startsWith("is") ? m.substring(2) : null)) == null) continue;
                    try {
                        Method setter = Tools.getInstanceMethod(type, "set" + suffix, new Class[]{method.getReturnType()});
                        if (setter.getAnnotation(Column.class) != null) continue;
                        set.add(new SourceMethod(Reflect.accessible(setter)));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                return SourceMethod.methods(set);
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_ANNOTATED_SETTERS, Cache.key(type, name));
    }

    static final Method getAnnotatedGetter(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<Method>(){

            @Override
            public Method apply() {
                for (Method method : Tools.getInstanceMethods(type)) {
                    Method getter2;
                    String m;
                    Column column = method.getAnnotation(Column.class);
                    if (column == null || !Tools.namesMatch(name, column.name())) continue;
                    if (method.getParameterTypes().length == 0) {
                        return Reflect.accessible(method);
                    }
                    if (method.getParameterTypes().length != 1 || !(m = method.getName()).startsWith("set")) continue;
                    try {
                        getter2 = type.getMethod("get" + m.substring(3), new Class[0]);
                        if (getter2.getAnnotation(Column.class) == null) {
                            return Reflect.accessible(getter2);
                        }
                    }
                    catch (NoSuchMethodException getter2) {
                        // empty catch block
                    }
                    try {
                        getter2 = type.getMethod("is" + m.substring(3), new Class[0]);
                        if (getter2.getAnnotation(Column.class) != null) continue;
                        return Reflect.accessible(getter2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                return null;
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_ANNOTATED_GETTER, Cache.key(type, name));
    }

    static final List<Method> getMatchingSetters(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<List<Method>>(){

            @Override
            public List<Method> apply() {
                LinkedHashSet<SourceMethod> set = new LinkedHashSet<SourceMethod>();
                String camelCase = StringUtils.toCamelCase(name);
                String camelCaseLC = StringUtils.toLC(camelCase);
                for (Method method : Tools.getInstanceMethods(type)) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) continue;
                    if (name.equals(method.getName())) {
                        set.add(new SourceMethod(Reflect.accessible(method)));
                        continue;
                    }
                    if (camelCaseLC.equals(method.getName())) {
                        set.add(new SourceMethod(Reflect.accessible(method)));
                        continue;
                    }
                    if (("set" + name).equals(method.getName())) {
                        set.add(new SourceMethod(Reflect.accessible(method)));
                        continue;
                    }
                    if (!("set" + camelCase).equals(method.getName())) continue;
                    set.add(new SourceMethod(Reflect.accessible(method)));
                }
                return SourceMethod.methods(set);
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_MATCHING_SETTERS, Cache.key(type, name));
    }

    static final Method getMatchingGetter(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new F0<Method>(){

            @Override
            public Method apply() {
                String camelCase = StringUtils.toCamelCase(name);
                String camelCaseLC = StringUtils.toLC(camelCase);
                for (Method method : Tools.getInstanceMethods(type)) {
                    if (method.getParameterTypes().length != 0) continue;
                    if (name.equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (camelCaseLC.equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("get" + name).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("get" + camelCase).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("is" + name).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (!("is" + camelCase).equals(method.getName())) continue;
                    return Reflect.accessible(method);
                }
                return null;
            }
        }, DataCacheKey.DATA_REFLECTION_CACHE_GET_MATCHING_GETTER, Cache.key(type, name));
    }

    private static final Method getInstanceMethod(Class<?> type, String name, Class<?>[] parameters) throws NoSuchMethodException {
        try {
            return type.getMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            while (true) {
                try {
                    return type.getDeclaredMethod(name, parameters);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ((type = type.getSuperclass()) != null) continue;
                    throw new NoSuchMethodException();
                }
                break;
            }
        }
    }

    private static final Set<Method> getInstanceMethods(Class<?> type) {
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        for (Method method : type.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            result.add(method);
        }
        do {
            for (Method method : type.getDeclaredMethods()) {
                if ((method.getModifiers() & 8) != 0) continue;
                result.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return result;
    }

    private static final List<java.lang.reflect.Field> getInstanceMembers(Class<?> type) {
        ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : type.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            result.add(field);
        }
        do {
            for (java.lang.reflect.Field field : type.getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0) continue;
                result.add(field);
            }
        } while ((type = type.getSuperclass()) != null);
        return result;
    }

    static final String getPropertyName(String methodName) {
        String name = methodName;
        if (name.startsWith("is") && name.length() > 2) {
            name = name.substring(2, 3).toLowerCase() + name.substring(3);
        } else if (name.startsWith("get") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        } else if (name.startsWith("set") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    static final void consumeExceptions(Configuration configuration, PreparedStatement stmt, SQLException previous) {
        ThrowExceptions exceptions = configuration.settings().getThrowExceptions();
        if (exceptions == ThrowExceptions.THROW_FIRST) {
            return;
        }
    }

    static final void consumeWarnings(ExecuteContext ctx, ExecuteListener listener) {
        if (!Boolean.FALSE.equals(ctx.settings().isFetchWarnings())) {
            try {
                ctx.sqlWarning(ctx.statement().getWarnings());
            }
            catch (SQLException e) {
                ctx.sqlWarning(new SQLWarning("Could not fetch SQLWarning", e));
            }
        }
        if (ctx.sqlWarning() != null) {
            listener.warning(ctx);
        }
    }

    static final SQLException executeStatementAndGetFirstResultSet(ExecuteContext ctx, int skipUpdateCounts) throws SQLException {
        PreparedStatement stmt = ctx.statement();
        try {
            if (stmt.execute()) {
                ctx.resultSet(stmt.getResultSet());
            } else {
                ctx.resultSet(null);
                ctx.rows(stmt.getUpdateCount());
            }
            return null;
        }
        catch (SQLException e) {
            if (ctx.settings().getThrowExceptions() != ThrowExceptions.THROW_NONE) {
                Tools.consumeExceptions(ctx.configuration(), ctx.statement(), e);
                throw e;
            }
            return e;
        }
    }

    static final void consumeResultSets(ExecuteContext ctx, ExecuteListener listener, Results results, Intern intern, SQLException prev) throws SQLException {
        boolean anyResults = false;
        int i = 0;
        int rows = ctx.resultSet() == null ? ctx.rows() : 0;
        for (i = 0; i < maxConsumedResults; ++i) {
            try {
                if (ctx.resultSet() != null) {
                    anyResults = true;
                    Field<?>[] fields = new MetaDataFieldProvider(ctx.configuration(), ctx.resultSet().getMetaData()).getFields();
                    CursorImpl c = new CursorImpl(ctx, listener, fields, intern != null ? intern.internIndexes(fields) : null, true, false);
                    results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(c.fetch()));
                } else if (prev == null) {
                    if (rows == -1) break;
                    results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(rows));
                }
                if (ctx.statement().getMoreResults()) {
                    ctx.resultSet(ctx.statement().getResultSet());
                } else {
                    rows = ctx.statement().getUpdateCount();
                    ctx.rows(rows);
                    if (rows == -1) break;
                    ctx.resultSet(null);
                }
                prev = null;
                continue;
            }
            catch (SQLException e) {
                prev = e;
                if (ctx.settings().getThrowExceptions() == ThrowExceptions.THROW_NONE) {
                    ctx.sqlException(e);
                    results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(Tools.translate(ctx.sql(), e)));
                    continue;
                }
                Tools.consumeExceptions(ctx.configuration(), ctx.statement(), e);
                throw e;
            }
        }
        if (i == maxConsumedResults) {
            log.warn("Maximum consumed results reached: " + maxConsumedResults + ". This is probably a bug. Please report to https://github.com/jOOQ/jOOQ/issues/new");
        }
        if (anyResults && ctx.family() != SQLDialect.CUBRID) {
            ctx.statement().getMoreResults(3);
        }
        if (ctx.settings().getThrowExceptions() == ThrowExceptions.THROW_NONE) {
            SQLException s1 = null;
            for (ResultOrRows r : results.resultsOrRows()) {
                DataAccessException d = r.exception();
                if (d == null || !(d.getCause() instanceof SQLException)) continue;
                SQLException s2 = (SQLException)d.getCause();
                if (s1 != null) {
                    s1.setNextException(s2);
                }
                s1 = s2;
            }
        }
    }

    static final List<String[]> parseTXT(String string, String nullLiteral) {
        boolean formattedOracle;
        String[] strings = NEW_LINES.split(string);
        if (strings.length < 2) {
            throw new DataAccessException("String must contain at least two lines");
        }
        boolean formattedJOOQ = string.charAt(0) == '+';
        boolean bl = formattedOracle = string.charAt(0) == '-';
        if (formattedJOOQ) {
            return Tools.parseTXTLines(nullLiteral, strings, PLUS_PATTERN, 0, 1, 3, strings.length - 1);
        }
        if (formattedOracle) {
            return Tools.parseTXTLines(nullLiteral, strings, PIPE_PATTERN, 1, 1, 3, strings.length - 1);
        }
        return Tools.parseTXTLines(nullLiteral, strings, DASH_PATTERN, 1, 0, 2, strings.length);
    }

    private static final List<String[]> parseTXTLines(String nullLiteral, String[] strings, Pattern pattern, int matchLine, int headerLine, int dataLineStart, int dataLineEnd) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        Matcher m = pattern.matcher(strings[matchLine]);
        while (m.find()) {
            positions.add(new int[]{m.start(1), m.end(1)});
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        Tools.parseTXTLine(positions, result, strings[headerLine], nullLiteral);
        for (int j = dataLineStart; j < dataLineEnd; ++j) {
            Tools.parseTXTLine(positions, result, strings[j], nullLiteral);
        }
        return result;
    }

    private static final void parseTXTLine(List<int[]> positions, List<String[]> result, String string, String nullLiteral) {
        String[] fields = new String[positions.size()];
        result.add(fields);
        int length = string.length();
        for (int i = 0; i < fields.length; ++i) {
            int[] position = positions.get(i);
            fields[i] = position[0] < length ? string.substring(position[0], Math.min(position[1], length)).trim() : null;
            if (!StringUtils.equals(fields[i], nullLiteral)) continue;
            fields[i] = null;
        }
    }

    static final List<String[]> parseHTML(String string) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Matcher mRow = P_PARSE_HTML_ROW.matcher(string);
        while (mRow.find()) {
            String row = mRow.group(1);
            ArrayList<String> col = new ArrayList<String>();
            if (result.isEmpty()) {
                Matcher mColHead = P_PARSE_HTML_COL_HEAD.matcher(row);
                while (mColHead.find()) {
                    col.add(mColHead.group(1));
                }
            }
            if (col.isEmpty()) {
                Matcher mColBody = P_PARSE_HTML_COL_BODY.matcher(row);
                while (mColBody.find()) {
                    col.add(mColBody.group(1));
                }
                if (result.isEmpty()) {
                    result.add(Tools.fieldNameStrings(col.size()));
                }
            }
            result.add(col.toArray(EMPTY_STRING));
        }
        return result;
    }

    static final void begin(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(Keywords.K_EXECUTE_BLOCK).formatSeparator().visit(Keywords.K_AS).formatSeparator().visit(Keywords.K_BEGIN).formatIndentStart().formatSeparator();
                break;
            }
            case MARIADB: {
                ctx.visit(Keywords.K_BEGIN).sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ATOMIC).formatIndentStart().formatSeparator();
                break;
            }
            case POSTGRES: {
                if (Tools.increment(ctx.data(), DataKey.DATA_BLOCK_NESTING)) {
                    ctx.visit(Keywords.K_DO).sql(" $$").formatSeparator();
                }
                ctx.visit(Keywords.K_BEGIN).formatIndentStart().formatSeparator();
            }
        }
    }

    static final void end(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case MARIADB: {
                ctx.formatIndentEnd().formatSeparator().visit(Keywords.K_END);
                break;
            }
            case POSTGRES: {
                ctx.formatIndentEnd().formatSeparator().visit(Keywords.K_END);
                if (!Tools.decrement(ctx.data(), DataKey.DATA_BLOCK_NESTING)) break;
                ctx.sql(" $$");
            }
        }
    }

    static final void beginExecuteImmediate(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(Keywords.K_EXECUTE_STATEMENT).sql(" '").stringLiteral(true).formatIndentStart().formatSeparator();
            }
        }
    }

    static final void endExecuteImmediate(Context<?> ctx) {
        ctx.formatIndentEnd().formatSeparator().stringLiteral(false).sql("';");
    }

    static final void beginTryCatch(Context<?> ctx, DDLStatementType type) {
        Tools.beginTryCatch(ctx, type, null, null);
    }

    static final void beginTryCatch(Context<?> ctx, DDLStatementType type, Boolean container, Boolean element) {
        switch (ctx.family()) {
            case FIREBIRD: {
                Tools.begin(ctx);
                Tools.beginExecuteImmediate(ctx);
                break;
            }
            case MARIADB: {
                ArrayList<String> sqlstates = new ArrayList<String>();
                sqlstates.add("42S02");
                Tools.begin(ctx);
                for (String sqlstate : sqlstates) {
                    ctx.visit(DSL.keyword("declare continue handler for sqlstate")).sql(' ').visit(DSL.inline(sqlstate)).sql(' ').visit(Keywords.K_BEGIN).sql(' ').visit(Keywords.K_END).sql(';').formatSeparator();
                }
                break;
            }
            case POSTGRES: {
                Tools.begin(ctx);
                break;
            }
        }
    }

    static final void endTryCatch(Context<?> ctx, DDLStatementType type) {
        Tools.endTryCatch(ctx, type, null, null);
    }

    static final void endTryCatch(Context<?> ctx, DDLStatementType type, Boolean container, Boolean element) {
        switch (ctx.family()) {
            case FIREBIRD: {
                Tools.endExecuteImmediate(ctx);
                ctx.formatSeparator().visit(Keywords.K_WHEN).sql(" sqlcode -607 ").visit(Keywords.K_DO).formatIndentStart().formatSeparator().visit(Keywords.K_BEGIN).sql(' ').visit(Keywords.K_END).formatIndentEnd();
                Tools.end(ctx);
                break;
            }
            case MARIADB: {
                ctx.sql(';');
                Tools.end(ctx);
                break;
            }
            case POSTGRES: {
                ctx.sql(';').formatIndentEnd().formatSeparator().visit(Keywords.K_EXCEPTION).formatIndentStart().formatSeparator().visit(Keywords.K_WHEN).sql(' ').visit(Keywords.K_SQLSTATE).sql(" '42P07' ").visit(Keywords.K_THEN).sql(' ').visit(Keywords.K_NULL).sql(';').formatIndentEnd();
                Tools.end(ctx);
                break;
            }
        }
    }

    static final void toSQLDDLTypeDeclarationForAddition(Context<?> ctx, DataType<?> type) {
        Tools.toSQLDDLTypeDeclaration(ctx, type);
        Tools.toSQLDDLTypeDeclarationIdentityBeforeNull(ctx, type);
        if (DEFAULT_BEFORE_NULL.contains((Object)ctx.family())) {
            Tools.toSQLDDLTypeDeclarationDefault(ctx, type);
        }
        if (!type.nullable()) {
            ctx.sql(' ').visit(Keywords.K_NOT_NULL);
        } else if (!NO_SUPPORT_NULL.contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_NULL);
        }
        if (!DEFAULT_BEFORE_NULL.contains((Object)ctx.family())) {
            Tools.toSQLDDLTypeDeclarationDefault(ctx, type);
        }
        Tools.toSQLDDLTypeDeclarationIdentityAfterNull(ctx, type);
    }

    static final void toSQLDDLTypeDeclarationIdentityBeforeNull(Context<?> ctx, DataType<?> type) {
        if (type.identity()) {
            switch (ctx.family()) {
                case CUBRID: {
                    ctx.sql(' ').visit(Keywords.K_AUTO_INCREMENT);
                    break;
                }
                case DERBY: {
                    ctx.sql(' ').visit(Keywords.K_GENERATED_BY_DEFAULT_AS_IDENTITY);
                    break;
                }
                case HSQLDB: {
                    ctx.sql(' ').visit(Keywords.K_GENERATED_BY_DEFAULT_AS_IDENTITY).sql('(').visit(Keywords.K_START_WITH).sql(" 1)");
                    break;
                }
                case SQLITE: {
                    ctx.sql(' ').visit(Keywords.K_PRIMARY_KEY).sql(' ').visit(Keywords.K_AUTOINCREMENT);
                    break;
                }
                case POSTGRES: {
                    switch (ctx.dialect()) {
                        case POSTGRES: {
                            ctx.sql(' ').visit(Keywords.K_GENERATED_BY_DEFAULT_AS_IDENTITY);
                        }
                    }
                }
            }
        }
    }

    static final void toSQLDDLTypeDeclarationIdentityAfterNull(Context<?> ctx, DataType<?> type) {
        if (type.identity()) {
            switch (ctx.family()) {
                case MARIADB: 
                case H2: 
                case MYSQL: {
                    ctx.sql(' ').visit(Keywords.K_AUTO_INCREMENT);
                }
            }
        }
    }

    private static final void toSQLDDLTypeDeclarationDefault(Context<?> ctx, DataType<?> type) {
        if (type.defaulted()) {
            ctx.sql(' ').visit(Keywords.K_DEFAULT).sql(' ').visit(type.defaultValue());
        }
    }

    static final void toSQLDDLTypeDeclaration(Context<?> ctx, DataType<?> type) {
        DataType<EnumType> elementType;
        DataType<Object> dataType = elementType = type instanceof ArrayDataType ? ((ArrayDataType)type).elementType : type;
        if (type.identity()) {
            switch (ctx.family()) {
                // Empty switch
            }
        }
        if (EnumType.class.isAssignableFrom(type.getType())) {
            DataType<EnumType> enumType = type;
            switch (ctx.family()) {
                case MARIADB: 
                case H2: 
                case MYSQL: {
                    ctx.visit(Keywords.K_ENUM).sql('(');
                    String separator = "";
                    for (EnumType e : Tools.enumConstants(enumType)) {
                        ctx.sql(separator).visit(DSL.inline(e.getLiteral()));
                        separator = ", ";
                    }
                    ctx.sql(')');
                    return;
                }
                case POSTGRES: {
                    if (Tools.storedEnumType(enumType)) break;
                    type = Tools.emulateEnumType(enumType);
                    break;
                }
                default: {
                    type = Tools.emulateEnumType(enumType);
                }
            }
        }
        if (type.getType() == UUID.class && NO_SUPPORT_CAST_TYPE_IN_DDL.contains((Object)ctx.family())) {
            Tools.toSQLDDLTypeDeclaration(ctx, SQLDataType.VARCHAR(36));
            return;
        }
        String typeName = type.getTypeName(ctx.configuration());
        if (type.hasLength() || elementType.hasLength()) {
            if (type.isBinary() && NO_SUPPORT_BINARY_TYPE_LENGTH.contains((Object)ctx.family())) {
                ctx.sql(typeName);
            } else if (type.length() > 0) {
                ctx.sql(typeName).sql('(').sql(type.length()).sql(')');
            } else if (NO_SUPPORT_CAST_TYPE_IN_DDL.contains((Object)ctx.family())) {
                if (type.isBinary()) {
                    ctx.sql(SQLDataType.BLOB.getTypeName(ctx.configuration()));
                } else {
                    ctx.sql(SQLDataType.CLOB.getTypeName(ctx.configuration()));
                }
            } else {
                String castTypeName = type.getCastTypeName(ctx.configuration());
                if (!typeName.equals(castTypeName)) {
                    ctx.sql(castTypeName);
                } else {
                    ctx.sql(typeName);
                }
            }
        } else if (type.hasPrecision() && type.precision() > 0) {
            if (type.hasScale()) {
                ctx.sql(typeName).sql('(').sql(type.precision()).sql(", ").sql(type.scale()).sql(')');
            } else {
                ctx.sql(typeName).sql('(').sql(type.precision()).sql(')');
            }
        } else if (type.identity() && ctx.family() == SQLDialect.SQLITE && type.isNumeric()) {
            ctx.sql("integer");
        } else {
            ctx.sql(typeName);
        }
        if (type.characterSet() != null && ctx.configuration().data("org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.sql(' ').visit(Keywords.K_CHARACTER_SET).sql(' ').visit(type.characterSet());
        }
        if (type.collation() != null && ctx.configuration().data("org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.sql(' ').visit(Keywords.K_COLLATE).sql(' ').visit(type.collation());
        }
    }

    static boolean storedEnumType(DataType<EnumType> enumType) {
        return Tools.enumConstants(enumType)[0].getSchema() != null;
    }

    private static EnumType[] enumConstants(DataType<? extends EnumType> type) {
        EnumType[] enums = type.getType().getEnumConstants();
        if (enums == null) {
            throw new DataTypeException("EnumType must be a Java enum");
        }
        return enums;
    }

    static final DataType<String> emulateEnumType(DataType<? extends EnumType> type) {
        return Tools.emulateEnumType(type, Tools.enumConstants(type));
    }

    private static final DataType<String> emulateEnumType(DataType<? extends EnumType> type, EnumType[] enums) {
        int length = 0;
        for (EnumType e : enums) {
            if (e.getLiteral() == null) continue;
            length = Math.max(length, e.getLiteral().length());
        }
        return SQLDataType.VARCHAR(length).nullability(type.nullability()).defaultValue(type.defaultValue());
    }

    static <T> Supplier<T> blocking(Supplier<T> supplier) {
        return Tools.blocking(supplier, false);
    }

    static <T> Supplier<T> blocking(final Supplier<T> supplier, boolean threadLocal) {
        return threadLocal ? supplier : new Supplier<T>(){
            volatile T asyncResult;

            @Override
            public T get() {
                try {
                    ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                        @Override
                        public boolean block() {
                            asyncResult = supplier.get();
                            return true;
                        }

                        @Override
                        public boolean isReleasable() {
                            return asyncResult != null;
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return this.asyncResult;
            }
        };
    }

    static String[] enumLiterals(Class<? extends EnumType> type) {
        EnumType[] values = Tools.enums(type);
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getLiteral();
        }
        return result;
    }

    static <E extends EnumType> E[] enums(Class<? extends E> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return (EnumType[])type.getEnumConstants();
        }
        try {
            Class<?> companionClass = Thread.currentThread().getContextClassLoader().loadClass(type.getName() + "$");
            java.lang.reflect.Field module = companionClass.getField("MODULE$");
            Object companion = module.get(companionClass);
            return (EnumType[])companionClass.getMethod("values", new Class[0]).invoke(companion, new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException("Error while looking up Scala enum", e);
        }
    }

    static final boolean isTime(Class<?> t) {
        return t == Time.class || t == LocalTime.class;
    }

    static final boolean isTimestamp(Class<?> t) {
        return t == Timestamp.class || t == LocalDateTime.class;
    }

    static final boolean isDate(Class<?> t) {
        return t == Date.class || t == LocalDate.class;
    }

    static final boolean hasAmbiguousNames(Collection<? extends Field<?>> fields) {
        if (fields == null) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        for (Field<?> field : fields) {
            if (names.add(field.getName())) continue;
            return true;
        }
        return false;
    }

    static final QueryPartList<SelectFieldOrAsterisk> qualify(final Table<?> table, SelectFieldList<SelectFieldOrAsterisk> fields) {
        QueryPartList<SelectFieldOrAsterisk> result = new QueryPartList<SelectFieldOrAsterisk>(){

            @Override
            protected void toSQLEmptyList(Context<?> context) {
                table.asterisk();
            }

            @Override
            public boolean declaresFields() {
                return true;
            }
        };
        for (SelectFieldOrAsterisk field : fields) {
            result.add(Tools.qualify(table, field));
        }
        return result;
    }

    static final SelectFieldOrAsterisk qualify(Table<?> table, SelectFieldOrAsterisk field) {
        if (field instanceof Field) {
            return Tools.qualify(table, (Field)field);
        }
        if (field instanceof Asterisk) {
            return table.asterisk();
        }
        if (field instanceof QualifiedAsterisk) {
            return table.asterisk();
        }
        throw new IllegalArgumentException("Unsupported field : " + field);
    }

    static final <T> Field<T> qualify(Table<?> table, Field<T> field) {
        Field<T> result = table.field(field);
        if (result != null) {
            return result;
        }
        Name[] part = table.getQualifiedName().parts();
        Name[] name = new Name[part.length + 1];
        System.arraycopy(part, 0, name, 0, part.length);
        name[part.length] = field.getUnqualifiedName();
        return DSL.field(DSL.name(name), field.getDataType());
    }

    static final <R extends Record> Table<R> aliased(Table<R> table) {
        if (table instanceof TableImpl) {
            return ((TableImpl)table).getAliasedTable();
        }
        if (table instanceof TableAlias) {
            return ((TableAlias)table).getAliasedTable();
        }
        return null;
    }

    static final <R extends Record> Alias<Table<R>> alias(Table<R> table) {
        if (table instanceof TableImpl) {
            return ((TableImpl)table).alias;
        }
        if (table instanceof TableAlias) {
            return ((TableAlias)table).alias;
        }
        return null;
    }

    static final boolean toplevel(Map<Object, Object> data, DataKey key) {
        Integer updateCounts = (Integer)data.get((Object)key);
        if (updateCounts == null) {
            throw new IllegalStateException();
        }
        return updateCounts == 1;
    }

    static final boolean increment(Map<Object, Object> data, DataKey key) {
        boolean result = true;
        Integer updateCounts = (Integer)data.get((Object)key);
        if (updateCounts == null) {
            updateCounts = 0;
        } else {
            result = false;
        }
        data.put((Object)key, updateCounts + 1);
        return result;
    }

    static final boolean decrement(Map<Object, Object> data, DataKey key) {
        boolean result = false;
        Integer updateCounts = (Integer)data.get((Object)key);
        if (updateCounts == null || updateCounts == 0) {
            throw new IllegalStateException("Unmatching increment / decrement on key: " + (Object)((Object)key));
        }
        if (updateCounts == 1) {
            result = true;
        }
        data.put((Object)key, updateCounts - 1);
        return result;
    }

    static Field<?> tableField(Table<?> table, Object field) {
        if (field instanceof Field) {
            return (Field)field;
        }
        if (field instanceof Name) {
            return table.field((Name)field);
        }
        if (field instanceof String) {
            return table.field((String)field);
        }
        throw new IllegalArgumentException("Field type not supported: " + field);
    }

    static final String convertBytesToHex(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX_DIGITS;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    static final String convertBytesToHex(byte[] value) {
        return Tools.convertBytesToHex(value, value.length);
    }

    static final boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    static final boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    static final boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    static final boolean isEmbeddable(Field<?> field) {
        return field instanceof EmbeddableTableField || field instanceof Val && ((Val)field).value instanceof EmbeddableRecord;
    }

    static final Field<?>[] embeddedFields(Field<?> field) {
        return field instanceof EmbeddableTableField ? ((EmbeddableTableField)field).fields : (field instanceof Val && ((Val)field).value instanceof EmbeddableRecord ? ((EmbeddableRecord)((Val)field).value).valuesRow().fields() : (field instanceof Val && EmbeddableRecord.class.isAssignableFrom(field.getType()) ? Tools.newInstance(field.getType()).valuesRow().fields() : null));
    }

    private static final EmbeddableRecord<?> newInstance(Class<? extends EmbeddableRecord<?>> type) {
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException("Cannot create EmbeddableRecord type", e);
        }
    }

    static final <E extends Field<?>> Iterable<E> flatten(final E field) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                Iterator<Field> it = Collections.singletonList(field).iterator();
                if (field instanceof EmbeddableTableField) {
                    return new FlatteningIterator<E>(it){

                        @Override
                        List<E> flatten(E e) {
                            return Arrays.asList(((EmbeddableTableField)e).fields);
                        }
                    };
                }
                return it;
            }
        };
    }

    static final <E extends Field<?>> Iterable<E> flattenCollection(final Iterable<E> iterable) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new FlatteningIterator<E>(iterable.iterator()){

                    @Override
                    List<E> flatten(E e) {
                        if (e instanceof EmbeddableTableField) {
                            return Arrays.asList(((EmbeddableTableField)e).fields);
                        }
                        return null;
                    }
                };
            }
        };
    }

    static final <E extends Map.Entry<Field<?>, Field<?>>> Iterable<E> flattenEntrySet(final Iterable<E> iterable) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new FlatteningIterator<E>(iterable.iterator()){

                    @Override
                    List<E> flatten(E e) {
                        if (e.getKey() instanceof EmbeddableTableField) {
                            ArrayList result = new ArrayList();
                            Field<?>[] keys = Tools.embeddedFields((Field)e.getKey());
                            Field<?>[] values = Tools.embeddedFields((Field)e.getValue());
                            for (int i = 0; i < keys.length; ++i) {
                                result.add(new AbstractMap.SimpleImmutableEntry(keys[i], values[i]));
                            }
                            return result;
                        }
                        return null;
                    }
                };
            }
        };
    }

    static final String asString(Name name) {
        if (!name.qualified()) {
            return name.first();
        }
        StringBuilder sb = new StringBuilder();
        Name[] parts = name.parts();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i].first());
            if (i >= parts.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    static final <T> boolean intersect(Collection<T> c1, Collection<T> c2) {
        for (T t1 : c1) {
            if (!c2.contains(t1)) continue;
            return true;
        }
        return false;
    }

    static final String normaliseNameCase(Configuration configuration, String name, boolean quoted, Locale locale) {
        switch (Tools.parseNameCase(configuration)) {
            case LOWER_IF_UNQUOTED: {
                if (quoted) {
                    return name;
                }
            }
            case LOWER: {
                return name.toLowerCase(locale);
            }
            case UPPER_IF_UNQUOTED: {
                if (quoted) {
                    return name;
                }
            }
            case UPPER: {
                return name.toUpperCase(locale);
            }
        }
        return name;
    }

    private static final ParseNameCase parseNameCase(Configuration configuration) {
        ParseNameCase result = StringUtils.defaultIfNull(configuration.settings().getParseNameCase(), ParseNameCase.DEFAULT);
        if (result == ParseNameCase.DEFAULT) {
            switch (StringUtils.defaultIfNull(configuration.settings().getParseDialect(), configuration.family()).family()) {
                case POSTGRES: {
                    return ParseNameCase.LOWER_IF_UNQUOTED;
                }
                case FIREBIRD: 
                case DERBY: 
                case HSQLDB: 
                case H2: {
                    return ParseNameCase.UPPER_IF_UNQUOTED;
                }
                case SQLITE: 
                case MYSQL: {
                    return ParseNameCase.AS_IS;
                }
            }
            return ParseNameCase.UPPER_IF_UNQUOTED;
        }
        return result;
    }

    static {
        maxConsumedExceptions = 256;
        maxConsumedResults = 65536;
        DASH_PATTERN = Pattern.compile("(-+)");
        PIPE_PATTERN = Pattern.compile("(?<=\\|)([^|]+)(?=\\|)");
        PLUS_PATTERN = Pattern.compile("\\+(-+)(?=\\+)");
        WHITESPACE_CHARACTERS = " \t\n\u000b\f\r".toCharArray();
        JDBC_ESCAPE_PREFIXES = new char[][]{"{fn ".toCharArray(), "{d ".toCharArray(), "{t ".toCharArray(), "{ts ".toCharArray()};
        TOKEN_SINGLE_LINE_COMMENT = new char[]{'-', '-'};
        TOKEN_SINGLE_LINE_COMMENT_C = new char[]{'/', '/'};
        TOKEN_HASH = new char[]{'#'};
        TOKEN_MULTI_LINE_COMMENT_OPEN = new char[]{'/', '*'};
        TOKEN_MULTI_LINE_COMMENT_CLOSE = new char[]{'*', '/'};
        TOKEN_APOS = new char[]{'\''};
        TOKEN_ESCAPED_APOS = new char[]{'\'', '\''};
        NON_BIND_VARIABLE_SUFFIXES = new char[][]{{'?'}, {'|'}, {'&'}, {'@'}, {'<'}, {'~'}, {'#'}, {'-'}};
        HEX_DIGITS = "0123456789abcdef".toCharArray();
        REQUIRES_BACKSLASH_ESCAPING = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
        NO_SUPPORT_NULL = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
        NO_SUPPORT_BINARY_TYPE_LENGTH = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        NO_SUPPORT_CAST_TYPE_IN_DDL = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
        DEFAULT_BEFORE_NULL = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
        SUPPORT_MYSQL_SYNTAX = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
        SUPPORT_POSTGRES_SYNTAX = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        CTX = DSL.using(new DefaultConfiguration());
        NEW_LINES = Pattern.compile("[\\r\\n]+");
        P_PARSE_HTML_ROW = Pattern.compile("<tr>(.*?)</tr>");
        P_PARSE_HTML_COL_HEAD = Pattern.compile("<th>(.*?)</th>");
        P_PARSE_HTML_COL_BODY = Pattern.compile("<td>(.*?)</td>");
    }

    static abstract class FlatteningIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private Iterator<E> flatten;
        private E next;

        FlatteningIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        abstract List<E> flatten(E var1);

        private final void move() {
            if (this.next == null) {
                if (this.flatten != null) {
                    if (this.flatten.hasNext()) {
                        this.next = this.flatten.next();
                        return;
                    }
                    this.flatten = null;
                }
                if (this.delegate.hasNext()) {
                    this.next = this.delegate.next();
                    List<E> flattened = this.flatten(this.next);
                    if (flattened == null) {
                        return;
                    }
                    this.next = null;
                    this.flatten = flattened.iterator();
                    this.move();
                    return;
                }
            }
        }

        @Override
        public final boolean hasNext() {
            this.move();
            return this.next != null;
        }

        @Override
        public final E next() {
            this.move();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            E result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class SourceMethod {
        final Method method;

        SourceMethod(Method method) {
            this.method = method;
        }

        static List<Method> methods(Collection<? extends SourceMethod> methods) {
            ArrayList<Method> result = new ArrayList<Method>(methods.size());
            for (SourceMethod sourceMethod : methods) {
                result.add(sourceMethod.method);
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceMethod) {
                Method other = ((SourceMethod)obj).method;
                if (this.method.getName().equals(other.getName())) {
                    Object[] p1 = this.method.getParameterTypes();
                    Object[] p2 = other.getParameterTypes();
                    return Arrays.equals(p1, p2);
                }
            }
            return false;
        }

        public String toString() {
            return this.method.toString();
        }
    }

    static class Cache {
        private static final Object NULL = new Object();

        Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final <V> V run(Configuration configuration, F0<V> operation, DataCacheKey type, Object key) {
            Object result;
            if (configuration == null) {
                configuration = new DefaultConfiguration();
            }
            if (!SettingsTools.reflectionCaching(configuration.settings())) {
                return operation.apply();
            }
            ConcurrentHashMap<Object, Object> cache = (ConcurrentHashMap<Object, Object>)configuration.data((Object)type);
            if (cache == null) {
                DataCacheKey dataCacheKey = type;
                synchronized (dataCacheKey) {
                    cache = (Map)configuration.data((Object)type);
                    if (cache == null) {
                        cache = new ConcurrentHashMap<Object, Object>();
                        configuration.data((Object)type, cache);
                    }
                }
            }
            if ((result = cache.get(key)) == null) {
                ConcurrentHashMap<Object, Object> concurrentHashMap = cache;
                synchronized (concurrentHashMap) {
                    result = cache.get(key);
                    if (result == null) {
                        result = operation.apply();
                        cache.put(key, result == null ? NULL : result);
                    }
                }
            }
            return result == NULL ? null : (V)result;
        }

        static final Object key(Object key1, Object key2) {
            return new Key2(key1, key2);
        }

        private static class Key2
        implements Serializable {
            private static final long serialVersionUID = 5822370287443922993L;
            private final Object key1;
            private final Object key2;

            Key2(Object key1, Object key2) {
                this.key1 = key1;
                this.key2 = key2;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.key1 == null ? 0 : this.key1.hashCode());
                result = 31 * result + (this.key2 == null ? 0 : this.key2.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key2 other = (Key2)obj;
                if (this.key1 == null ? other.key1 != null : !this.key1.equals(other.key1)) {
                    return false;
                }
                return !(this.key2 == null ? other.key2 != null : !this.key2.equals(other.key2));
            }

            public String toString() {
                return "[" + this.key1 + ", " + this.key2 + "]";
            }
        }
    }

    static class ThreadGuard {
        ThreadGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final <V> V run(Guard guard, GuardedOperation<V> operation) {
            boolean unguarded;
            boolean bl = unguarded = guard.tl.get() == null;
            if (unguarded) {
                guard.tl.set(Guard.class);
            }
            try {
                if (unguarded) {
                    V v = operation.unguarded();
                    return v;
                }
                V v = operation.guarded();
                return v;
            }
            finally {
                if (unguarded) {
                    guard.tl.remove();
                }
            }
        }

        static abstract class AbstractGuardedOperation<V>
        implements GuardedOperation<V> {
            AbstractGuardedOperation() {
            }

            @Override
            public V guarded() {
                return null;
            }
        }

        static interface GuardedOperation<V> {
            public V unguarded();

            public V guarded();
        }

        static enum Guard {
            RECORD_TOSTRING;

            ThreadLocal<Object> tl = new ThreadLocal();
        }
    }

    static enum DataCacheKey {
        DATA_REFLECTION_CACHE_GET_ANNOTATED_GETTER("org.jooq.configuration.reflection-cache.get-annotated-getter"),
        DATA_REFLECTION_CACHE_GET_ANNOTATED_MEMBERS("org.jooq.configuration.reflection-cache.get-annotated-members"),
        DATA_REFLECTION_CACHE_GET_ANNOTATED_SETTERS("org.jooq.configuration.reflection-cache.get-annotated-setters"),
        DATA_REFLECTION_CACHE_GET_MATCHING_GETTER("org.jooq.configuration.reflection-cache.get-matching-getter"),
        DATA_REFLECTION_CACHE_GET_MATCHING_MEMBERS("org.jooq.configuration.reflection-cache.get-matching-members"),
        DATA_REFLECTION_CACHE_GET_MATCHING_SETTERS("org.jooq.configuration.reflection-cache.get-matching-setters"),
        DATA_REFLECTION_CACHE_HAS_COLUMN_ANNOTATIONS("org.jooq.configuration.reflection-cache.has-column-annotations"),
        DATA_CACHE_RECORD_MAPPERS("org.jooq.configuration.cache.record-mappers");

        final String key;

        private DataCacheKey(String key) {
            this.key = key;
        }
    }

    static enum DataExtendedKey {

    }

    static enum DataKey {
        DATA_BLOCK_NESTING,
        DATA_WINDOW_DEFINITIONS,
        DATA_DEFAULT_TRANSACTION_PROVIDER_SAVEPOINTS,
        DATA_DEFAULT_TRANSACTION_PROVIDER_CONNECTION,
        DATA_OVERRIDE_ALIASES_IN_ORDER_BY,
        DATA_SELECT_INTO_TABLE,
        DATA_COLLECTED_SEMI_ANTI_JOIN,
        DATA_DML_TARGET_TABLE,
        DATA_ON_DUPLICATE_KEY_WHERE,
        DATA_TOP_LEVEL_CTE;

    }

    static enum BooleanDataKey {
        DATA_OMIT_RETURNING_CLAUSE,
        DATA_LOCK_ROWS_FOR_UPDATE,
        DATA_COUNT_BIND_VALUES,
        DATA_FORCE_STATIC_STATEMENT,
        DATA_OMIT_CLAUSE_EVENT_EMISSION,
        DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES,
        DATA_DEFAULT_TRANSACTION_PROVIDER_AUTOCOMMIT,
        DATA_UNALIAS_ALIASED_EXPRESSIONS,
        DATA_SELECT_NO_DATA,
        DATA_OMIT_INTO_CLAUSE,
        DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE,
        DATA_LIST_ALREADY_INDENTED,
        DATA_CONSTRAINT_REFERENCE,
        DATA_COLLECT_SEMI_ANTI_JOIN,
        DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST,
        DATA_NESTED_SET_OPERATIONS,
        DATA_EMULATE_BULK_INSERT_RETURNING,
        DATA_RANKING_FUNCTION;

    }
}

