/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Comparator;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.CompareCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class IsDistinctFrom<T>
extends AbstractCondition {
    private static final long serialVersionUID = 4568269684824736461L;
    private static final Set<SQLDialect> EMULATE_DISTINCT_PREDICATE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<T> lhs;
    private final Field<T> rhs;
    private final Comparator comparator;
    private transient QueryPartInternal mySQLCondition;
    private transient QueryPartInternal sqliteCondition;
    private transient QueryPartInternal compareCondition;

    IsDistinctFrom(Field<T> lhs, Field<T> rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (Tools.isEmbeddable(this.lhs) && Tools.isEmbeddable(this.rhs)) {
            return (QueryPartInternal)((Object)DSL.row(Tools.embeddedFields(this.lhs)).compare(this.comparator, DSL.row(Tools.embeddedFields(this.rhs))));
        }
        if (EMULATE_DISTINCT_PREDICATE.contains((Object)configuration.family())) {
            return this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.notExists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x"))))) : (QueryPartInternal)((Object)DSL.exists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x")))));
        }
        if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)configuration.family())) {
            if (this.mySQLCondition == null) {
                this.mySQLCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{not}({0} <=> {1})", this.lhs, this.rhs) : DSL.condition("{0} <=> {1}", this.lhs, this.rhs)));
            }
            return this.mySQLCondition;
        }
        if (SQLDialect.SQLITE == configuration.family()) {
            if (this.sqliteCondition == null) {
                this.sqliteCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{0} {is not} {1}", this.lhs, this.rhs) : DSL.condition("{0} {is} {1}", this.lhs, this.rhs)));
            }
            return this.sqliteCondition;
        }
        if (this.compareCondition == null) {
            this.compareCondition = new CompareCondition(this.lhs, this.rhs, this.comparator);
        }
        return this.compareCondition;
    }
}

