/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateSequenceFlagsStep;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Sequence;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class CreateSequenceImpl
extends AbstractRowCountQuery
implements CreateSequenceFlagsStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_SEQUENCE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_START_WITH = SQLDialect.supportedBy(SQLDialect.DERBY);
    private static final Set<SQLDialect> NO_SUPPORT_CACHE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> NO_SEPARATOR = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.MARIADB);
    private static final Set<SQLDialect> OMIT_NO_CACHE = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> OMIT_NO_CYCLE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> OMIT_NO_MINVALUE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> OMIT_NO_MAXVALUE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private final Sequence<?> sequence;
    private final boolean ifNotExists;
    private Field<? extends Number> startWith;
    private Field<? extends Number> incrementBy;
    private Field<? extends Number> minvalue;
    private boolean noMinvalue;
    private Field<? extends Number> maxvalue;
    private boolean noMaxvalue;
    private boolean cycle;
    private boolean noCycle;
    private Field<? extends Number> cache;
    private boolean noCache;

    CreateSequenceImpl(Configuration configuration, Sequence<?> sequence, boolean ifNotExists) {
        super(configuration);
        this.sequence = sequence;
        this.ifNotExists = ifNotExists;
    }

    final Sequence<?> $sequence() {
        return this.sequence;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    final Field<? extends Number> $startWith() {
        return this.startWith;
    }

    final Field<? extends Number> $incrementBy() {
        return this.incrementBy;
    }

    final Field<? extends Number> $minvalue() {
        return this.minvalue;
    }

    final boolean $noMinvalue() {
        return this.noMinvalue;
    }

    final Field<? extends Number> $maxvalue() {
        return this.maxvalue;
    }

    final boolean $noMaxvalue() {
        return this.noMaxvalue;
    }

    final boolean $cycle() {
        return this.cycle;
    }

    final boolean $noCycle() {
        return this.noCycle;
    }

    final Field<? extends Number> $cache() {
        return this.cache;
    }

    final boolean $noCache() {
        return this.noCache;
    }

    @Override
    public final CreateSequenceImpl startWith(Number value) {
        return this.startWith(Tools.field((Object)value, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl startWith(Field<? extends Number> value) {
        this.startWith = value;
        return this;
    }

    @Override
    public final CreateSequenceImpl incrementBy(Number value) {
        return this.incrementBy(Tools.field((Object)value, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl incrementBy(Field<? extends Number> value) {
        this.incrementBy = value;
        return this;
    }

    @Override
    public final CreateSequenceImpl minvalue(Number value) {
        return this.minvalue(Tools.field((Object)value, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl minvalue(Field<? extends Number> value) {
        this.minvalue = value;
        return this;
    }

    @Override
    public final CreateSequenceImpl noMinvalue() {
        this.noMinvalue = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl maxvalue(Number value) {
        return this.maxvalue(Tools.field((Object)value, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl maxvalue(Field<? extends Number> value) {
        this.maxvalue = value;
        return this;
    }

    @Override
    public final CreateSequenceImpl noMaxvalue() {
        this.noMaxvalue = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl cycle() {
        this.cycle = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl noCycle() {
        this.noCycle = true;
        return this;
    }

    @Override
    public final CreateSequenceImpl cache(Number value) {
        return this.cache(Tools.field((Object)value, this.sequence.getDataType()));
    }

    @Override
    public final CreateSequenceImpl cache(Field<? extends Number> value) {
        this.cache = value;
        return this;
    }

    @Override
    public final CreateSequenceImpl noCache() {
        this.noCache = true;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_SEQUENCE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_SEQUENCE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        String noSeparator;
        SQLDialect family = ctx.family();
        ctx.start(Clause.CREATE_SEQUENCE_SEQUENCE).visit(Keywords.K_CREATE).sql(' ').visit(family == SQLDialect.CUBRID ? Keywords.K_SERIAL : Keywords.K_SEQUENCE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.sequence);
        String string = noSeparator = NO_SEPARATOR.contains((Object)family) ? "" : " ";
        if (this.startWith == null && REQUIRES_START_WITH.contains((Object)family)) {
            ctx.sql(' ').visit(Keywords.K_START_WITH).sql(" 1");
        } else if (this.startWith != null) {
            ctx.sql(' ').visit(Keywords.K_START_WITH).sql(' ').visit(this.startWith);
        }
        if (this.incrementBy != null) {
            ctx.sql(' ').visit(Keywords.K_INCREMENT_BY).sql(' ').visit(this.incrementBy);
        }
        if (this.minvalue != null) {
            ctx.sql(' ').visit(Keywords.K_MINVALUE).sql(' ').visit(this.minvalue);
        } else if (this.noMinvalue && !OMIT_NO_MINVALUE.contains((Object)family)) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MINVALUE);
        }
        if (this.maxvalue != null) {
            ctx.sql(' ').visit(Keywords.K_MAXVALUE).sql(' ').visit(this.maxvalue);
        } else if (this.noMaxvalue && !OMIT_NO_MAXVALUE.contains((Object)family)) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MAXVALUE);
        }
        if (this.cycle) {
            ctx.sql(' ').visit(Keywords.K_CYCLE);
        } else if (this.noCycle && !OMIT_NO_CYCLE.contains((Object)family)) {
            ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CYCLE);
        }
        if (!NO_SUPPORT_CACHE.contains((Object)family)) {
            if (this.cache != null) {
                ctx.sql(' ').visit(Keywords.K_CACHE).sql(' ').visit(this.cache);
            } else if (this.noCache && !OMIT_NO_CACHE.contains((Object)family)) {
                ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CACHE);
            }
        }
        ctx.end(Clause.CREATE_SEQUENCE_SEQUENCE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

