/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Expression;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Concat
extends AbstractField<String> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<?>[] arguments;

    Concat(Field<?> ... arguments) {
        super(Names.N_CONCAT, SQLDataType.VARCHAR);
        this.arguments = arguments;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Field<String>[] cast = Tools.castAllIfNeeded(this.arguments, String.class);
        if (cast.length == 1) {
            ctx.visit(cast[0]);
            return;
        }
        Field<String> first = cast[0];
        Field[] others = new Field[cast.length - 1];
        System.arraycopy(cast, 1, others, 0, others.length);
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.function("concat", SQLDataType.VARCHAR, cast));
                break;
            }
            default: {
                ctx.visit(new Expression<String>(ExpressionOperator.CONCAT, first, others));
            }
        }
    }
}

