/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.SqlDialect;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

public class JdbcConventionFactory {
    public static final int CACHE_SIZE = 100;
    public static final Duration CACHE_TTL = Duration.ofHours(1L);
    private final Cache<Pair<SqlDialect, UserBitShared.UserCredentials>, DrillJdbcConvention> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(CACHE_TTL).build();

    public DrillJdbcConvention getJdbcConvention(final JdbcStoragePlugin plugin, final SqlDialect dialect, final UserBitShared.UserCredentials userCredentials) {
        try {
            return (DrillJdbcConvention)((Object)this.cache.get((Object)Pair.of((Object)dialect, (Object)userCredentials), (Callable)new Callable<DrillJdbcConvention>(){

                @Override
                public DrillJdbcConvention call() {
                    return new DrillJdbcConvention(dialect, plugin.getName(), plugin, userCredentials);
                }
            }));
        }
        catch (ExecutionException ex) {
            throw new DrillRuntimeException("Cannot load the requested DrillJdbcConvention", (Throwable)ex);
        }
    }
}

